/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class FMElm
extends CircuitElm {
    static final int FLAG_COS = 2;
    double carrierfreq;
    double signalfreq;
    double maxVoltage;
    double freqTimeZero;
    double deviation;
    double lasttime = 0.0;
    double funcx = 0.0;
    final int circleSize = 17;

    public FMElm(int n, int n2) {
        super(n, n2);
        this.deviation = 200.0;
        this.maxVoltage = 5.0;
        this.carrierfreq = 800.0;
        this.signalfreq = 40.0;
        this.reset();
    }

    public FMElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.carrierfreq = new Double(stringTokenizer.nextToken());
        this.signalfreq = new Double(stringTokenizer.nextToken());
        this.maxVoltage = new Double(stringTokenizer.nextToken());
        this.deviation = new Double(stringTokenizer.nextToken());
        if ((this.flags & 2) != 0) {
            this.flags &= 0xFFFFFFFD;
        }
        this.reset();
    }

    int getDumpType() {
        return 201;
    }

    String dump() {
        return super.dump() + " " + this.carrierfreq + " " + this.signalfreq + " " + this.maxVoltage + " " + this.deviation;
    }

    void reset() {
        this.freqTimeZero = 0.0;
        this.curcount = 0.0;
    }

    int getPostCount() {
        return 1;
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[0], this.voltSource);
    }

    void doStep() {
        sim.updateVoltageSource(0, this.nodes[0], this.voltSource, this.getVoltage());
    }

    double getVoltage() {
        double d = FMElm.sim.t - this.lasttime;
        this.lasttime = FMElm.sim.t;
        double d2 = Math.sin(Math.PI * 2 * (FMElm.sim.t - this.freqTimeZero) * this.signalfreq);
        this.funcx += d * (this.carrierfreq + d2 * this.deviation);
        double d3 = Math.PI * 2 * this.funcx;
        return Math.sin(d3) * this.maxVoltage;
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 17.0);
        this.setVoltageColor(graphics, this.volts[0]);
        FMElm.drawThickLine(graphics, this.point1, this.lead1);
        Font font = new Font("SansSerif", 0, 12);
        graphics.setFont(font);
        graphics.setColor(this.needsHighlight() ? selectColor : whiteColor);
        this.setPowerColor(graphics, false);
        double d = this.getVoltage();
        String string = "FM";
        this.drawCenteredText(graphics, string, this.x2, this.y2, true);
        this.drawWaveform(graphics, this.point2);
        this.drawPosts(graphics);
        this.curcount = this.updateDotCount(-this.current, this.curcount);
        if (FMElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
        }
    }

    void drawWaveform(Graphics graphics, Point point) {
        graphics.setColor(this.needsHighlight() ? selectColor : Color.gray);
        this.setPowerColor(graphics, false);
        int n = point.x;
        int n2 = point.y;
        FMElm.drawThickCircle(graphics, n, n2, 17);
        int n3 = 8;
        this.adjustBbox(n - 17, n2 - 17, n + 17, n2 + 17);
    }

    void setPoints() {
        super.setPoints();
        this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 17.0 / this.dn);
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    boolean hasGroundConnection(int n) {
        return true;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    double getPower() {
        return -this.getVoltageDiff() * this.current;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "FM Source";
        stringArray[1] = "I = " + FMElm.getCurrentText(this.getCurrent());
        stringArray[2] = "V = " + FMElm.getVoltageText(this.getVoltageDiff());
        stringArray[3] = "cf = " + FMElm.getUnitText(this.carrierfreq, "Hz");
        stringArray[4] = "sf = " + FMElm.getUnitText(this.signalfreq, "Hz");
        stringArray[5] = "dev =" + FMElm.getUnitText(this.deviation, "Hz");
        stringArray[6] = "Vmax = " + FMElm.getVoltageText(this.maxVoltage);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Max Voltage", this.maxVoltage, -20.0, 20.0);
        }
        if (n == 1) {
            return new EditInfo("Carrier Frequency (Hz)", this.carrierfreq, 4.0, 500.0);
        }
        if (n == 2) {
            return new EditInfo("Signal Frequency (Hz)", this.signalfreq, 4.0, 500.0);
        }
        if (n == 3) {
            return new EditInfo("Deviation (Hz)", this.deviation, 4.0, 500.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.maxVoltage = editInfo.value;
        }
        if (n == 1) {
            this.carrierfreq = editInfo.value;
        }
        if (n == 2) {
            this.signalfreq = editInfo.value;
        }
        if (n == 3) {
            this.deviation = editInfo.value;
        }
    }
}

