/*
 * Decompiled with CFR 0.152.
 */
class Inductor {
    public static final int FLAG_BACK_EULER = 2;
    int[] nodes;
    int flags;
    CirSim sim;
    double inductance;
    double compResistance;
    double current;
    double curSourceValue;

    Inductor(CirSim cirSim) {
        this.sim = cirSim;
        this.nodes = new int[2];
    }

    void setup(double d, double d2, int n) {
        this.inductance = d;
        this.current = d2;
        this.flags = n;
    }

    boolean isTrapezoidal() {
        return (this.flags & 2) == 0;
    }

    void reset() {
        this.current = 0.0;
    }

    void stamp(int n, int n2) {
        this.nodes[0] = n;
        this.nodes[1] = n2;
        this.compResistance = this.isTrapezoidal() ? 2.0 * this.inductance / this.sim.timeStep : this.inductance / this.sim.timeStep;
        this.sim.stampResistor(this.nodes[0], this.nodes[1], this.compResistance);
        this.sim.stampRightSide(this.nodes[0]);
        this.sim.stampRightSide(this.nodes[1]);
    }

    boolean nonLinear() {
        return false;
    }

    void startIteration(double d) {
        this.curSourceValue = this.isTrapezoidal() ? d / this.compResistance + this.current : this.current;
    }

    double calculateCurrent(double d) {
        if (this.compResistance > 0.0) {
            this.current = d / this.compResistance + this.curSourceValue;
        }
        return this.current;
    }

    void doStep(double d) {
        this.sim.stampCurrentSource(this.nodes[0], this.nodes[1], this.curSourceValue);
    }
}

