/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.debug.DebuggableScript;

final class InterpretedFunction
extends NativeFunction
implements Script {
    static final long serialVersionUID = 541475680333911468L;
    InterpreterData idata;
    SecurityController securityController;
    Object securityDomain;
    Scriptable[] functionRegExps;

    private InterpretedFunction(InterpreterData interpreterData, Object object) {
        Object object2;
        this.idata = interpreterData;
        Context context = Context.getContext();
        SecurityController securityController = context.getSecurityController();
        if (securityController != null) {
            object2 = securityController.getDynamicSecurityDomain(object);
        } else {
            if (object != null) {
                throw new IllegalArgumentException();
            }
            object2 = null;
        }
        this.securityController = securityController;
        this.securityDomain = object2;
    }

    private InterpretedFunction(InterpretedFunction interpretedFunction, int n) {
        this.idata = interpretedFunction.idata.itsNestedFunctions[n];
        this.securityController = interpretedFunction.securityController;
        this.securityDomain = interpretedFunction.securityDomain;
    }

    static InterpretedFunction createScript(InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        interpretedFunction.initInterpretedFunction(context, scriptable);
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = new InterpretedFunction(interpretedFunction, n);
        interpretedFunction2.initInterpretedFunction(context, scriptable);
        return interpretedFunction2;
    }

    Scriptable[] createRegExpWraps(Context context, Scriptable scriptable) {
        if (this.idata.itsRegExpLiterals == null) {
            Kit.codeBug();
        }
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        int n = this.idata.itsRegExpLiterals.length;
        Scriptable[] scriptableArray = new Scriptable[n];
        int n2 = 0;
        while (n2 != n) {
            scriptableArray[n2] = regExpProxy.wrapRegExp(context, scriptable, this.idata.itsRegExpLiterals[n2]);
            ++n2;
        }
        return scriptableArray;
    }

    private void initInterpretedFunction(Context context, Scriptable scriptable) {
        this.initScriptFunction(context, scriptable);
        if (this.idata.itsRegExpLiterals != null) {
            this.functionRegExps = this.createRegExpWraps(context, scriptable);
        }
    }

    @Override
    public String getFunctionName() {
        return this.idata.itsName == null ? "" : this.idata.itsName;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(this, context, scriptable, scriptable2, objectArray);
        }
        return Interpreter.interpret(this, context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Object exec(Context context, Scriptable scriptable) {
        if (!this.isScript()) {
            throw new IllegalStateException();
        }
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(this, context, scriptable, scriptable, ScriptRuntime.emptyArgs);
        }
        return Interpreter.interpret(this, context, scriptable, scriptable, ScriptRuntime.emptyArgs);
    }

    public boolean isScript() {
        return this.idata.itsFunctionType == 0;
    }

    @Override
    public String getEncodedSource() {
        return Interpreter.getEncodedSource(this.idata);
    }

    @Override
    public DebuggableScript getDebuggableView() {
        return this.idata;
    }

    @Override
    public Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        return Interpreter.resumeGenerator(context, scriptable, n, object, object2);
    }

    @Override
    protected int getLanguageVersion() {
        return this.idata.languageVersion;
    }

    @Override
    protected int getParamCount() {
        return this.idata.argCount;
    }

    @Override
    protected int getParamAndVarCount() {
        return this.idata.argNames.length;
    }

    @Override
    protected String getParamOrVarName(int n) {
        return this.idata.argNames[n];
    }

    @Override
    protected boolean getParamOrVarConst(int n) {
        return this.idata.argIsConst[n];
    }
}

