/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class LazilyLoadedCtor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STATE_BEFORE_INIT = 0;
    private static final int STATE_INITIALIZING = 1;
    private static final int STATE_WITH_VALUE = 2;
    private final ScriptableObject scope;
    private final String propertyName;
    private final String className;
    private final boolean sealed;
    private Object initializedValue;
    private int state;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl) {
        this.scope = scriptableObject;
        this.propertyName = string;
        this.className = string2;
        this.sealed = bl;
        this.state = 0;
        scriptableObject.addLazilyInitializedValue(string, 0, this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        LazilyLoadedCtor lazilyLoadedCtor = this;
        synchronized (lazilyLoadedCtor) {
            if (this.state == 1) {
                throw new IllegalStateException("Recursive initialization for " + this.propertyName);
            }
            if (this.state == 0) {
                this.state = 1;
                Object object = Scriptable.NOT_FOUND;
                try {
                    object = this.buildValue();
                }
                finally {
                    this.initializedValue = object;
                    this.state = 2;
                }
            }
        }
    }

    Object getValue() {
        if (this.state != 2) {
            throw new IllegalStateException(this.propertyName);
        }
        return this.initializedValue;
    }

    private Object buildValue() {
        Class<? extends Scriptable> clazz = this.cast(Kit.classOrNull(this.className));
        if (clazz != null) {
            try {
                Object object = ScriptableObject.buildClassCtor(this.scope, clazz, this.sealed, false);
                if (object != null) {
                    return object;
                }
                object = this.scope.get(this.propertyName, (Scriptable)this.scope);
                if (object != Scriptable.NOT_FOUND) {
                    return object;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
            }
            catch (RhinoException rhinoException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (SecurityException securityException) {}
        }
        return Scriptable.NOT_FOUND;
    }

    private Class<? extends Scriptable> cast(Class<?> clazz) {
        return clazz;
    }
}

