/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.REBackTrackData;
import org.mozilla.javascript.regexp.RECharSet;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.REGlobalData;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.REProgState;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptableObject
implements Function {
    static final long serialVersionUID = 4965263491464903264L;
    private static final Object REGEXP_TAG = new Object();
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_ASSERTTEST = 43;
    private static final byte REOP_ASSERTNOTTEST = 44;
    private static final byte REOP_MINIMALSTAR = 45;
    private static final byte REOP_MINIMALPLUS = 46;
    private static final byte REOP_MINIMALOPT = 47;
    private static final byte REOP_MINIMALQUANT = 48;
    private static final byte REOP_ENDCHILD = 49;
    private static final byte REOP_CLASS = 50;
    private static final byte REOP_REPEAT = 51;
    private static final byte REOP_MINIMALREPEAT = 52;
    private static final byte REOP_END = 53;
    private static final int OFFSET_LEN = 2;
    private static final int INDEX_LEN = 2;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_exec = 4;
    private static final int Id_test = 5;
    private static final int Id_prefix = 6;
    private static final int MAX_PROTOTYPE_ID = 6;
    private RECompiled re;
    double lastIndex;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.re = (RECompiled)NativeRegExp.compileRE(context, "", null, false);
        nativeRegExp.activatePrototypeMap(6);
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(NativeRegExp.getObjectPrototype(scriptable));
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        nativeRegExp.put("constructor", (Scriptable)nativeRegExp, (Object)nativeRegExpCtor);
        ScriptRuntime.setFunctionProtoAndParent(nativeRegExpCtor, scriptable);
        nativeRegExpCtor.setImmunePrototypeProperty(nativeRegExp);
        if (bl) {
            nativeRegExp.sealObject();
            nativeRegExpCtor.sealObject();
        }
        NativeRegExp.defineProperty(scriptable, "RegExp", nativeRegExpCtor, 2);
    }

    NativeRegExp(Scriptable scriptable, Object object) {
        this.re = (RECompiled)object;
        this.lastIndex = 0.0;
        ScriptRuntime.setObjectProtoAndParent(this, scriptable);
    }

    @Override
    public String getClassName() {
        return "RegExp";
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.execSub(context, scriptable, objectArray, 1);
    }

    Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
            if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.bad.regexp.compile");
            }
            NativeRegExp nativeRegExp = (NativeRegExp)objectArray[0];
            this.re = nativeRegExp.re;
            this.lastIndex = nativeRegExp.lastIndex;
            return this;
        }
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 && objectArray[1] != Undefined.instance ? ScriptRuntime.toString(objectArray[1]) : null;
        this.re = (RECompiled)NativeRegExp.compileRE(context, string, string2, false);
        this.lastIndex = 0.0;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        if (this.re.source.length != 0) {
            stringBuffer.append(this.re.source);
        } else {
            stringBuffer.append("(?:)");
        }
        stringBuffer.append('/');
        if ((this.re.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.re.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((this.re.flags & 4) != 0) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    NativeRegExp() {
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    private Object execSub(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        Object object;
        double d;
        String string;
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        if (objectArray.length == 0) {
            string = regExpImpl.input;
            if (string == null) {
                NativeRegExp.reportError("msg.no.re.input.for", this.toString());
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        double d2 = d = (this.re.flags & 1) != 0 ? this.lastIndex : 0.0;
        if (d < 0.0 || (double)string.length() < d) {
            this.lastIndex = 0.0;
            object = null;
        } else {
            int[] nArray = new int[]{(int)d};
            object = this.executeRegExp(context, scriptable, regExpImpl, string, nArray, n);
            if ((this.re.flags & 1) != 0) {
                this.lastIndex = object == null || object == Undefined.instance ? 0 : nArray[0];
            }
        }
        return object;
    }

    static Object compileRE(Context context, String string, String string2, boolean bl) {
        int n;
        RECompiled rECompiled = new RECompiled();
        rECompiled.source = string.toCharArray();
        int n2 = string.length();
        int n3 = 0;
        if (string2 != null) {
            int n4 = 0;
            while (n4 < string2.length()) {
                n = string2.charAt(n4);
                if (n == 103) {
                    n3 |= 1;
                } else if (n == 105) {
                    n3 |= 2;
                } else if (n == 109) {
                    n3 |= 4;
                } else {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf((char)n));
                }
                ++n4;
            }
        }
        rECompiled.flags = n3;
        CompilerState compilerState = new CompilerState(context, rECompiled.source, n2, n3);
        if (bl && n2 > 0) {
            compilerState.result = new RENode(21);
            compilerState.result.chr = compilerState.cpbegin[0];
            compilerState.result.length = n2;
            compilerState.result.flatIndex = 0;
            compilerState.progLength += 5;
        } else if (!NativeRegExp.parseDisjunction(compilerState)) {
            return null;
        }
        rECompiled.program = new byte[compilerState.progLength + 1];
        if (compilerState.classCount != 0) {
            rECompiled.classList = new RECharSet[compilerState.classCount];
            rECompiled.classCount = compilerState.classCount;
        }
        n = NativeRegExp.emitREBytecode(compilerState, rECompiled, 0, compilerState.result);
        rECompiled.program[n++] = 53;
        rECompiled.parenCount = compilerState.parenCount;
        switch (rECompiled.program[0]) {
            case 28: 
            case 35: {
                rECompiled.anchorCh = (char)NativeRegExp.getIndex(rECompiled.program, 1);
                break;
            }
            case 22: 
            case 33: {
                rECompiled.anchorCh = (char)(rECompiled.program[1] & 0xFF);
                break;
            }
            case 21: 
            case 32: {
                int n5 = NativeRegExp.getIndex(rECompiled.program, 1);
                rECompiled.anchorCh = rECompiled.source[n5];
            }
        }
        return rECompiled;
    }

    static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private static boolean isLineTerm(char c) {
        return ScriptRuntime.isJSLineTerminator(c);
    }

    private static boolean isREWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 8232 || n == 8233 || n == 12 || n == 11 || n == 160 || Character.getType((char)n) == 12;
    }

    private static char upcase(char c) {
        if (c < '\u0080') {
            if ('a' <= c && c <= 'z') {
                return (char)(c + -32);
            }
            return c;
        }
        char c2 = Character.toUpperCase(c);
        if (c >= '\u0080' && c2 < '\u0080') {
            return c;
        }
        return c2;
    }

    private static char downcase(char c) {
        if (c < '\u0080') {
            if ('A' <= c && c <= 'Z') {
                return (char)(c + 32);
            }
            return c;
        }
        char c2 = Character.toLowerCase(c);
        if (c >= '\u0080' && c2 < '\u0080') {
            return c;
        }
        return c2;
    }

    private static int toASCIIHexDigit(int n) {
        if (n < 48) {
            return -1;
        }
        if (n <= 57) {
            return n - 48;
        }
        if (97 <= (n |= 0x20) && n <= 102) {
            return n - 97 + 10;
        }
        return -1;
    }

    private static boolean parseDisjunction(CompilerState compilerState) {
        int n;
        if (!NativeRegExp.parseAlternative(compilerState)) {
            return false;
        }
        char[] cArray = compilerState.cpbegin;
        if ((n = compilerState.cp++) != cArray.length && cArray[n] == '|') {
            RENode rENode = new RENode(1);
            rENode.kid = compilerState.result;
            if (!NativeRegExp.parseDisjunction(compilerState)) {
                return false;
            }
            rENode.kid2 = compilerState.result;
            compilerState.result = rENode;
            compilerState.progLength += 9;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean parseAlternative(CompilerState var0) {
        var1_1 = null;
        var2_2 = null;
        var3_3 = var0.cpbegin;
        block0: while (true) {
            if (var0.cp == var0.cpend || var3_3[var0.cp] == '|' || var0.parenNesting != 0 && var3_3[var0.cp] == ')') {
                var0.result = var1_1 == null ? new RENode(0) : var1_1;
                return true;
            }
            if (!NativeRegExp.parseTerm(var0)) {
                return false;
            }
            if (var1_1 == null) {
                var1_1 = var0.result;
                continue;
            }
            if (var2_2 == null) {
                var1_1.next = var0.result;
                var2_2 = var0.result;
                while (true) {
                    if (var2_2.next == null) continue block0;
                    var2_2 = var2_2.next;
                }
            }
            var2_2 = var2_2.next = var0.result;
            while (true) {
                if (var2_2.next != null) ** break;
                continue block0;
                var2_2 = var2_2.next;
            }
            break;
        }
    }

    private static boolean calculateBitmapSize(CompilerState compilerState, RENode rENode, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        rENode.bmsize = 0;
        if (n == n2) {
            return true;
        }
        if (cArray[n] == '^') {
            ++n;
        }
        while (n != n2) {
            int n5 = 0;
            int n6 = 2;
            block0 : switch (cArray[n]) {
                case '\\': {
                    int n7 = ++n;
                    ++n;
                    int n8 = cArray[n7];
                    switch (n8) {
                        case 98: {
                            n5 = 8;
                            break block0;
                        }
                        case 102: {
                            n5 = 12;
                            break block0;
                        }
                        case 110: {
                            n5 = 10;
                            break block0;
                        }
                        case 114: {
                            n5 = 13;
                            break block0;
                        }
                        case 116: {
                            n5 = 9;
                            break block0;
                        }
                        case 118: {
                            n5 = 11;
                            break block0;
                        }
                        case 99: {
                            if (n + 1 < n2 && Character.isLetter(cArray[n + 1])) {
                                n5 = (char)(cArray[n++] & 0x1F);
                                break block0;
                            }
                            n5 = 92;
                            break block0;
                        }
                        case 117: {
                            n6 += 2;
                        }
                        case 120: {
                            int n9 = 0;
                            int n10 = 0;
                            while (n10 < n6 && n < n2) {
                                if ((n9 = Kit.xDigitToInt(n8 = cArray[n++], n9)) < 0) {
                                    n -= n10 + 1;
                                    n9 = 92;
                                    break;
                                }
                                ++n10;
                            }
                            n5 = n9;
                            break block0;
                        }
                        case 100: {
                            if (bl) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            n5 = 57;
                            break block0;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 115: 
                        case 119: {
                            if (bl) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            rENode.bmsize = 65535;
                            return true;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int n10;
                            int n9 = n8 - 48;
                            n8 = cArray[n];
                            if (48 <= n8 && n8 <= 55) {
                                n9 = 8 * n9 + (n8 - 48);
                                if (48 <= (n8 = cArray[++n]) && n8 <= 55) {
                                    ++n;
                                    n10 = 8 * n9 + (n8 - 48);
                                    if (n10 <= 255) {
                                        n9 = n10;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            n5 = n9;
                            break block0;
                        }
                    }
                    n5 = n8;
                    break;
                }
                default: {
                    n5 = cArray[n++];
                }
            }
            if (bl) {
                if (n3 > n5) {
                    NativeRegExp.reportError("msg.bad.range", "");
                    return false;
                }
                bl = false;
            } else if (n < n2 - 1 && cArray[n] == '-') {
                ++n;
                bl = true;
                n3 = (char)n5;
                continue;
            }
            if ((compilerState.flags & 2) != 0) {
                char c;
                char c2 = NativeRegExp.upcase((char)n5);
                n5 = c2 >= (c = NativeRegExp.downcase((char)n5)) ? c2 : c;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        rENode.bmsize = n4;
        return true;
    }

    private static void doFlat(CompilerState compilerState, char c) {
        compilerState.result = new RENode(21);
        compilerState.result.chr = c;
        compilerState.result.length = 1;
        compilerState.result.flatIndex = -1;
        compilerState.progLength += 3;
    }

    private static int getDecimalValue(char c, CompilerState compilerState, int n, String string) {
        boolean bl = false;
        int n2 = compilerState.cp;
        char[] cArray = compilerState.cpbegin;
        int n3 = c - 48;
        while (compilerState.cp != compilerState.cpend) {
            c = cArray[compilerState.cp];
            if (!NativeRegExp.isDigit(c)) break;
            if (!bl) {
                int n4 = c - 48;
                if (n3 < (n - n4) / 10) {
                    n3 = n3 * 10 + n4;
                } else {
                    bl = true;
                    n3 = n;
                }
            }
            ++compilerState.cp;
        }
        if (bl) {
            NativeRegExp.reportError(string, String.valueOf(cArray, n2, compilerState.cp - n2));
        }
        return n3;
    }

    private static boolean parseTerm(CompilerState compilerState) {
        int n;
        char[] cArray = compilerState.cpbegin;
        char c = cArray[compilerState.cp++];
        int n2 = 2;
        int n3 = compilerState.parenCount;
        block0 : switch (c) {
            case '^': {
                compilerState.result = new RENode(2);
                ++compilerState.progLength;
                return true;
            }
            case '$': {
                compilerState.result = new RENode(3);
                ++compilerState.progLength;
                return true;
            }
            case '\\': {
                if (compilerState.cp < compilerState.cpend) {
                    c = cArray[compilerState.cp++];
                    switch (c) {
                        case 'b': {
                            compilerState.result = new RENode(4);
                            ++compilerState.progLength;
                            return true;
                        }
                        case 'B': {
                            compilerState.result = new RENode(5);
                            ++compilerState.progLength;
                            return true;
                        }
                        case '0': {
                            NativeRegExp.reportWarning(compilerState.cx, "msg.bad.backref", "");
                            int n4 = 0;
                            while (compilerState.cp < compilerState.cpend) {
                                c = cArray[compilerState.cp];
                                if (c < 48 || c > 55) break;
                                ++compilerState.cp;
                                int n5 = 8 * n4 + (c - 48);
                                if (n5 > 255) break;
                                n4 = n5;
                            }
                            c = (char)n4;
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int n6 = compilerState.cp - 1;
                            int n7 = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.backref");
                            if (n7 > compilerState.parenCount) {
                                NativeRegExp.reportWarning(compilerState.cx, "msg.bad.backref", "");
                            }
                            if (n7 > 9 && n7 > compilerState.parenCount) {
                                compilerState.cp = n6;
                                n7 = 0;
                                while (compilerState.cp < compilerState.cpend) {
                                    c = cArray[compilerState.cp];
                                    if (c < 48 || c > 55) break;
                                    ++compilerState.cp;
                                    int n8 = 8 * n7 + (c - 48);
                                    if (n8 > 255) break;
                                    n7 = n8;
                                }
                                c = (char)n7;
                                NativeRegExp.doFlat(compilerState, c);
                                break block0;
                            }
                            compilerState.result = new RENode(20);
                            compilerState.result.parenIndex = n7 - 1;
                            compilerState.progLength += 3;
                            break block0;
                        }
                        case 'f': {
                            c = '\f';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'n': {
                            c = '\n';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'r': {
                            c = '\r';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 't': {
                            c = '\t';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'v': {
                            c = '\u000b';
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'c': {
                            if (compilerState.cp + 1 < compilerState.cpend && Character.isLetter(cArray[compilerState.cp + 1])) {
                                c = (char)(cArray[compilerState.cp++] & 0x1F);
                            } else {
                                --compilerState.cp;
                                c = '\\';
                            }
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'u': {
                            n2 += 2;
                        }
                        case 'x': {
                            int n9 = 0;
                            n = 0;
                            while (n < n2 && compilerState.cp < compilerState.cpend) {
                                if ((n9 = Kit.xDigitToInt(c = cArray[compilerState.cp++], n9)) < 0) {
                                    compilerState.cp -= n + 2;
                                    n9 = cArray[compilerState.cp++];
                                    break;
                                }
                                ++n;
                            }
                            c = (char)n9;
                            NativeRegExp.doFlat(compilerState, c);
                            break block0;
                        }
                        case 'd': {
                            compilerState.result = new RENode(14);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'D': {
                            compilerState.result = new RENode(15);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 's': {
                            compilerState.result = new RENode(18);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'S': {
                            compilerState.result = new RENode(19);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'w': {
                            compilerState.result = new RENode(16);
                            ++compilerState.progLength;
                            break block0;
                        }
                        case 'W': {
                            compilerState.result = new RENode(17);
                            ++compilerState.progLength;
                            break block0;
                        }
                    }
                    compilerState.result = new RENode(21);
                    compilerState.result.chr = c;
                    compilerState.result.length = 1;
                    compilerState.result.flatIndex = compilerState.cp - 1;
                    compilerState.progLength += 3;
                    break;
                }
                NativeRegExp.reportError("msg.trail.backslash", "");
                return false;
            }
            case '(': {
                RENode rENode = null;
                int n10 = compilerState.cp;
                if (compilerState.cp + 1 < compilerState.cpend && cArray[compilerState.cp] == '?' && ((c = cArray[compilerState.cp + 1]) == '=' || c == '!' || c == ':')) {
                    compilerState.cp += 2;
                    if (c == '=') {
                        rENode = new RENode(41);
                        compilerState.progLength += 4;
                    } else if (c == '!') {
                        rENode = new RENode(42);
                        compilerState.progLength += 4;
                    }
                } else {
                    rENode = new RENode(10);
                    compilerState.progLength += 6;
                    rENode.parenIndex = compilerState.parenCount++;
                }
                ++compilerState.parenNesting;
                if (!NativeRegExp.parseDisjunction(compilerState)) {
                    return false;
                }
                if (compilerState.cp == compilerState.cpend || cArray[compilerState.cp] != ')') {
                    NativeRegExp.reportError("msg.unterm.paren", "");
                    return false;
                }
                ++compilerState.cp;
                --compilerState.parenNesting;
                if (rENode == null) break;
                rENode.kid = compilerState.result;
                compilerState.result = rENode;
                break;
            }
            case ')': {
                NativeRegExp.reportError("msg.re.unmatched.right.paren", "");
                return false;
            }
            case '[': {
                int n11;
                compilerState.result = new RENode(50);
                compilerState.result.startIndex = n11 = compilerState.cp;
                while (true) {
                    if (compilerState.cp == compilerState.cpend) {
                        NativeRegExp.reportError("msg.unterm.class", "");
                        return false;
                    }
                    if (cArray[compilerState.cp] == '\\') {
                        ++compilerState.cp;
                    } else if (cArray[compilerState.cp] == ']') break;
                    ++compilerState.cp;
                }
                compilerState.result.kidlen = compilerState.cp - n11;
                compilerState.result.index = compilerState.classCount++;
                if (!NativeRegExp.calculateBitmapSize(compilerState, compilerState.result, cArray, n11, compilerState.cp++)) {
                    return false;
                }
                compilerState.progLength += 3;
                break;
            }
            case '.': {
                compilerState.result = new RENode(12);
                ++compilerState.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': {
                NativeRegExp.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.cp - 1]));
                return false;
            }
            default: {
                compilerState.result = new RENode(21);
                compilerState.result.chr = c;
                compilerState.result.length = 1;
                compilerState.result.flatIndex = compilerState.cp - 1;
                compilerState.progLength += 3;
            }
        }
        RENode rENode = compilerState.result;
        if (compilerState.cp == compilerState.cpend) {
            return true;
        }
        boolean bl = false;
        switch (cArray[compilerState.cp]) {
            case '+': {
                compilerState.result = new RENode(6);
                compilerState.result.min = 1;
                compilerState.result.max = -1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '*': {
                compilerState.result = new RENode(6);
                compilerState.result.min = 0;
                compilerState.result.max = -1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '?': {
                compilerState.result = new RENode(6);
                compilerState.result.min = 0;
                compilerState.result.max = 1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '{': {
                n = 0;
                int n12 = -1;
                int n13 = compilerState.cp++;
                c = cArray[compilerState.cp];
                if (NativeRegExp.isDigit(c)) {
                    ++compilerState.cp;
                    n = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.min");
                    c = cArray[compilerState.cp];
                    if (c == ',') {
                        if (NativeRegExp.isDigit(c = cArray[++compilerState.cp])) {
                            ++compilerState.cp;
                            n12 = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.max");
                            c = cArray[compilerState.cp];
                            if (n > n12) {
                                NativeRegExp.reportError("msg.max.lt.min", String.valueOf(cArray[compilerState.cp]));
                                return false;
                            }
                        }
                    } else {
                        n12 = n;
                    }
                    if (c == '}') {
                        compilerState.result = new RENode(6);
                        compilerState.result.min = n;
                        compilerState.result.max = n12;
                        compilerState.progLength += 12;
                        bl = true;
                    }
                }
                if (bl) break;
                compilerState.cp = n13;
            }
        }
        if (!bl) {
            return true;
        }
        ++compilerState.cp;
        compilerState.result.kid = rENode;
        compilerState.result.parenIndex = n3;
        compilerState.result.parenCount = compilerState.parenCount - n3;
        if (compilerState.cp < compilerState.cpend && cArray[compilerState.cp] == '?') {
            ++compilerState.cp;
            compilerState.result.greedy = false;
        } else {
            compilerState.result.greedy = true;
        }
        return true;
    }

    private static void resolveForwardJump(byte[] byArray, int n, int n2) {
        if (n > n2) {
            throw Kit.codeBug();
        }
        NativeRegExp.addIndex(byArray, n, n2 - n);
    }

    private static int getOffset(byte[] byArray, int n) {
        return NativeRegExp.getIndex(byArray, n);
    }

    private static int addIndex(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw Kit.codeBug();
        }
        if (n2 > 65535) {
            throw Context.reportRuntimeError("Too complex regexp");
        }
        byArray[n] = (byte)(n2 >> 8);
        byArray[n + 1] = (byte)n2;
        return n + 2;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int emitREBytecode(CompilerState compilerState, RECompiled rECompiled, int n, RENode rENode) {
        byte[] byArray = rECompiled.program;
        while (rENode != null) {
            byArray[n++] = rENode.op;
            switch (rENode.op) {
                case 0: {
                    --n;
                    break;
                }
                case 1: {
                    RENode rENode2 = rENode.kid2;
                    int n2 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 23;
                    int n3 = n;
                    NativeRegExp.resolveForwardJump(byArray, n2, n += 2);
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode2);
                    byArray[n++] = 23;
                    n2 = n;
                    NativeRegExp.resolveForwardJump(byArray, n3, n += 2);
                    NativeRegExp.resolveForwardJump(byArray, n2, n);
                    break;
                }
                case 21: {
                    if (rENode.flatIndex != -1) {
                        while (rENode.next != null && rENode.next.op == 21 && rENode.flatIndex + rENode.length == rENode.next.flatIndex) {
                            rENode.length += rENode.next.length;
                            rENode.next = rENode.next.next;
                        }
                    }
                    if (rENode.flatIndex != -1 && rENode.length > 1) {
                        byArray[n - 1] = (compilerState.flags & 2) != 0 ? 32 : 21;
                        n = NativeRegExp.addIndex(byArray, n, rENode.flatIndex);
                        n = NativeRegExp.addIndex(byArray, n, rENode.length);
                        break;
                    }
                    if (rENode.chr < '\u0100') {
                        byArray[n - 1] = (compilerState.flags & 2) != 0 ? 33 : 22;
                        byArray[n++] = (byte)rENode.chr;
                        break;
                    }
                    byArray[n - 1] = (compilerState.flags & 2) != 0 ? 35 : 28;
                    n = NativeRegExp.addIndex(byArray, n, rENode.chr);
                    break;
                }
                case 10: {
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 11;
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    break;
                }
                case 20: {
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    break;
                }
                case 41: {
                    int n3 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 43;
                    NativeRegExp.resolveForwardJump(byArray, n3, n);
                    break;
                }
                case 42: {
                    int n3 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 44;
                    NativeRegExp.resolveForwardJump(byArray, n3, n);
                    break;
                }
                case 6: {
                    if (rENode.min == 0 && rENode.max == -1) {
                        byArray[n - 1] = rENode.greedy ? 7 : 45;
                    } else if (rENode.min == 0 && rENode.max == 1) {
                        byArray[n - 1] = rENode.greedy ? 9 : 47;
                    } else if (rENode.min == 1 && rENode.max == -1) {
                        byArray[n - 1] = rENode.greedy ? 8 : 46;
                    } else {
                        if (!rENode.greedy) {
                            byArray[n - 1] = 48;
                        }
                        n = NativeRegExp.addIndex(byArray, n, rENode.min);
                        n = NativeRegExp.addIndex(byArray, n, rENode.max + 1);
                    }
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenCount);
                    int n3 = n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 49;
                    NativeRegExp.resolveForwardJump(byArray, n3, n);
                    break;
                }
                case 50: {
                    n = NativeRegExp.addIndex(byArray, n, rENode.index);
                    rECompiled.classList[rENode.index] = new RECharSet(rENode.bmsize, rENode.startIndex, rENode.kidlen);
                    break;
                }
            }
            rENode = rENode.next;
        }
        return n;
    }

    private static void pushProgState(REGlobalData rEGlobalData, int n, int n2, REBackTrackData rEBackTrackData, int n3, int n4) {
        rEGlobalData.stateStackTop = new REProgState(rEGlobalData.stateStackTop, n, n2, rEGlobalData.cp, rEBackTrackData, n3, n4);
    }

    private static REProgState popProgState(REGlobalData rEGlobalData) {
        REProgState rEProgState = rEGlobalData.stateStackTop;
        rEGlobalData.stateStackTop = rEProgState.previous;
        return rEProgState;
    }

    private static void pushBackTrackState(REGlobalData rEGlobalData, byte by, int n) {
        rEGlobalData.backTrackStackTop = new REBackTrackData(rEGlobalData, by, n);
    }

    private static boolean flatNMatcher(REGlobalData rEGlobalData, int n, int n2, char[] cArray, int n3) {
        if (rEGlobalData.cp + n2 > n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (rEGlobalData.regexp.source[n + n4] != cArray[rEGlobalData.cp + n4]) {
                return false;
            }
            ++n4;
        }
        rEGlobalData.cp += n2;
        return true;
    }

    private static boolean flatNIMatcher(REGlobalData rEGlobalData, int n, int n2, char[] cArray, int n3) {
        if (rEGlobalData.cp + n2 > n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (NativeRegExp.upcase(rEGlobalData.regexp.source[n + n4]) != NativeRegExp.upcase(cArray[rEGlobalData.cp + n4])) {
                return false;
            }
            ++n4;
        }
        rEGlobalData.cp += n2;
        return true;
    }

    private static boolean backrefMatcher(REGlobalData rEGlobalData, int n, char[] cArray, int n2) {
        int n3 = rEGlobalData.parens_index(n);
        if (n3 == -1) {
            return true;
        }
        int n4 = rEGlobalData.parens_length(n);
        if (rEGlobalData.cp + n4 > n2) {
            return false;
        }
        if ((rEGlobalData.regexp.flags & 2) != 0) {
            int n5 = 0;
            while (n5 < n4) {
                if (NativeRegExp.upcase(cArray[n3 + n5]) != NativeRegExp.upcase(cArray[rEGlobalData.cp + n5])) {
                    return false;
                }
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n4) {
                if (cArray[n3 + n6] != cArray[rEGlobalData.cp + n6]) {
                    return false;
                }
                ++n6;
            }
        }
        rEGlobalData.cp += n4;
        return true;
    }

    private static void addCharacterToCharSet(RECharSet rECharSet, char c) {
        int n = c / 8;
        if (c > rECharSet.length) {
            throw new RuntimeException();
        }
        int n2 = n;
        rECharSet.bits[n2] = (byte)(rECharSet.bits[n2] | 1 << (c & 7));
    }

    private static void addCharacterRangeToCharSet(RECharSet rECharSet, char c, char c2) {
        int n = c / 8;
        int n2 = c2 / 8;
        if (c2 > rECharSet.length || c > c2) {
            throw new RuntimeException();
        }
        c = (char)(c & 7);
        c2 = (char)(c2 & 7);
        if (n == n2) {
            int n3 = n;
            rECharSet.bits[n3] = (byte)(rECharSet.bits[n3] | 255 >> 7 - (c2 - c) << c);
        } else {
            int n4 = n;
            rECharSet.bits[n4] = (byte)(rECharSet.bits[n4] | 255 << c);
            int n5 = n + 1;
            while (n5 < n2) {
                rECharSet.bits[n5] = -1;
                ++n5;
            }
            int n6 = n2;
            rECharSet.bits[n6] = (byte)(rECharSet.bits[n6] | 255 >> 7 - c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCharSet(REGlobalData rEGlobalData, RECharSet rECharSet) {
        RECharSet rECharSet2 = rECharSet;
        synchronized (rECharSet2) {
            if (!rECharSet.converted) {
                NativeRegExp.processCharSetImpl(rEGlobalData, rECharSet);
                rECharSet.converted = true;
            }
        }
    }

    private static void processCharSetImpl(REGlobalData rEGlobalData, RECharSet rECharSet) {
        int n = rECharSet.startIndex;
        int n2 = n + rECharSet.strlength;
        char c = '\u0000';
        boolean bl = false;
        rECharSet.sense = true;
        int n3 = rECharSet.length / 8 + 1;
        rECharSet.bits = new byte[n3];
        if (n == n2) {
            return;
        }
        if (rEGlobalData.regexp.source[n] == '^') {
            rECharSet.sense = false;
            ++n;
        }
        block21: while (n != n2) {
            char c2;
            int n4 = 2;
            switch (rEGlobalData.regexp.source[n]) {
                case '\\': {
                    int n5 = ++n;
                    ++n;
                    char c3 = rEGlobalData.regexp.source[n5];
                    switch (c3) {
                        case 'b': {
                            c2 = '\b';
                            break;
                        }
                        case 'f': {
                            c2 = '\f';
                            break;
                        }
                        case 'n': {
                            c2 = '\n';
                            break;
                        }
                        case 'r': {
                            c2 = '\r';
                            break;
                        }
                        case 't': {
                            c2 = '\t';
                            break;
                        }
                        case 'v': {
                            c2 = '\u000b';
                            break;
                        }
                        case 'c': {
                            if (n + 1 < n2 && NativeRegExp.isWord(rEGlobalData.regexp.source[n + 1])) {
                                c2 = (char)(rEGlobalData.regexp.source[n++] & 0x1F);
                                break;
                            }
                            --n;
                            c2 = '\\';
                            break;
                        }
                        case 'u': {
                            n4 += 2;
                        }
                        case 'x': {
                            int n6 = 0;
                            int n7 = 0;
                            while (n7 < n4 && n < n2) {
                                int n8;
                                if ((n8 = NativeRegExp.toASCIIHexDigit(c3 = rEGlobalData.regexp.source[n++])) < 0) {
                                    n -= n7 + 1;
                                    n6 = 92;
                                    break;
                                }
                                n6 = n6 << 4 | n8;
                                ++n7;
                            }
                            c2 = (char)n6;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int n7;
                            int n6 = c3 - 48;
                            c3 = rEGlobalData.regexp.source[n];
                            if ('0' <= c3 && c3 <= '7') {
                                n6 = 8 * n6 + (c3 - 48);
                                if ('0' <= (c3 = rEGlobalData.regexp.source[++n]) && c3 <= '7') {
                                    ++n;
                                    n7 = 8 * n6 + (c3 - 48);
                                    if (n7 <= 255) {
                                        n6 = n7;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            c2 = (char)n6;
                            break;
                        }
                        case 'd': {
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, '0', '9');
                            continue block21;
                        }
                        case 'D': {
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, '\u0000', '/');
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, ':', (char)rECharSet.length);
                            continue block21;
                        }
                        case 's': {
                            int n7 = rECharSet.length;
                            while (n7 >= 0) {
                                if (NativeRegExp.isREWhiteSpace(n7)) {
                                    NativeRegExp.addCharacterToCharSet(rECharSet, (char)n7);
                                }
                                --n7;
                            }
                            continue block21;
                        }
                        case 'S': {
                            int n7 = rECharSet.length;
                            while (n7 >= 0) {
                                if (!NativeRegExp.isREWhiteSpace(n7)) {
                                    NativeRegExp.addCharacterToCharSet(rECharSet, (char)n7);
                                }
                                --n7;
                            }
                            continue block21;
                        }
                        case 'w': {
                            int n7 = rECharSet.length;
                            while (n7 >= 0) {
                                if (NativeRegExp.isWord((char)n7)) {
                                    NativeRegExp.addCharacterToCharSet(rECharSet, (char)n7);
                                }
                                --n7;
                            }
                            continue block21;
                        }
                        case 'W': {
                            int n7 = rECharSet.length;
                            while (n7 >= 0) {
                                if (!NativeRegExp.isWord((char)n7)) {
                                    NativeRegExp.addCharacterToCharSet(rECharSet, (char)n7);
                                }
                                --n7;
                            }
                            continue block21;
                        }
                        default: {
                            c2 = c3;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    c2 = rEGlobalData.regexp.source[n++];
                }
            }
            if (bl) {
                if ((rEGlobalData.regexp.flags & 2) != 0) {
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, NativeRegExp.upcase(c), NativeRegExp.upcase(c2));
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, NativeRegExp.downcase(c), NativeRegExp.downcase(c2));
                } else {
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, c, c2);
                }
                bl = false;
                continue;
            }
            if ((rEGlobalData.regexp.flags & 2) != 0) {
                NativeRegExp.addCharacterToCharSet(rECharSet, NativeRegExp.upcase(c2));
                NativeRegExp.addCharacterToCharSet(rECharSet, NativeRegExp.downcase(c2));
            } else {
                NativeRegExp.addCharacterToCharSet(rECharSet, c2);
            }
            if (n >= n2 - 1 || rEGlobalData.regexp.source[n] != '-') continue;
            ++n;
            bl = true;
            c = c2;
        }
    }

    private static boolean classMatcher(REGlobalData rEGlobalData, RECharSet rECharSet, char c) {
        if (!rECharSet.converted) {
            NativeRegExp.processCharSet(rEGlobalData, rECharSet);
        }
        int n = c / 8;
        return !(rECharSet.sense ? rECharSet.length == 0 || c > rECharSet.length || (rECharSet.bits[n] & 1 << (c & 7)) == 0 : rECharSet.length != 0 && c <= rECharSet.length && (rECharSet.bits[n] & 1 << (c & 7)) != 0);
    }

    private static boolean executeREBytecode(REGlobalData rEGlobalData, char[] cArray, int n) {
        int n2 = 0;
        byte[] byArray = rEGlobalData.regexp.program;
        boolean bl = false;
        int n3 = 0;
        int n4 = 53;
        int n5 = byArray[n2++];
        block43: while (true) {
            switch (n5) {
                case 0: {
                    bl = true;
                    break;
                }
                case 2: {
                    if (rEGlobalData.cp != 0) {
                        if (rEGlobalData.multiline || (rEGlobalData.regexp.flags & 4) != 0) {
                            if (!NativeRegExp.isLineTerm(cArray[rEGlobalData.cp - 1])) {
                                bl = false;
                                break;
                            }
                        } else {
                            bl = false;
                            break;
                        }
                    }
                    bl = true;
                    break;
                }
                case 3: {
                    if (rEGlobalData.cp != n) {
                        if (rEGlobalData.multiline || (rEGlobalData.regexp.flags & 4) != 0) {
                            if (!NativeRegExp.isLineTerm(cArray[rEGlobalData.cp])) {
                                bl = false;
                                break;
                            }
                        } else {
                            bl = false;
                            break;
                        }
                    }
                    bl = true;
                    break;
                }
                case 4: {
                    bl = (rEGlobalData.cp == 0 || !NativeRegExp.isWord(cArray[rEGlobalData.cp - 1])) ^ (rEGlobalData.cp >= n || !NativeRegExp.isWord(cArray[rEGlobalData.cp]));
                    break;
                }
                case 5: {
                    bl = (rEGlobalData.cp == 0 || !NativeRegExp.isWord(cArray[rEGlobalData.cp - 1])) ^ (rEGlobalData.cp < n && NativeRegExp.isWord(cArray[rEGlobalData.cp]));
                    break;
                }
                case 12: {
                    boolean bl2 = bl = rEGlobalData.cp != n && !NativeRegExp.isLineTerm(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 14: {
                    boolean bl3 = bl = rEGlobalData.cp != n && NativeRegExp.isDigit(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 15: {
                    boolean bl4 = bl = rEGlobalData.cp != n && !NativeRegExp.isDigit(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 18: {
                    boolean bl5 = bl = rEGlobalData.cp != n && NativeRegExp.isREWhiteSpace(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 19: {
                    boolean bl6 = bl = rEGlobalData.cp != n && !NativeRegExp.isREWhiteSpace(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 16: {
                    boolean bl7 = bl = rEGlobalData.cp != n && NativeRegExp.isWord(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 17: {
                    boolean bl8 = bl = rEGlobalData.cp != n && !NativeRegExp.isWord(cArray[rEGlobalData.cp]);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 21: {
                    int n6 = NativeRegExp.getIndex(byArray, n2);
                    int n7 = NativeRegExp.getIndex(byArray, n2 += 2);
                    n2 += 2;
                    bl = NativeRegExp.flatNMatcher(rEGlobalData, n6, n7, cArray, n);
                    break;
                }
                case 32: {
                    int n8 = NativeRegExp.getIndex(byArray, n2);
                    int n9 = NativeRegExp.getIndex(byArray, n2 += 2);
                    n2 += 2;
                    bl = NativeRegExp.flatNIMatcher(rEGlobalData, n8, n9, cArray, n);
                    break;
                }
                case 22: {
                    char c = (char)(byArray[n2++] & 0xFF);
                    boolean bl9 = bl = rEGlobalData.cp != n && cArray[rEGlobalData.cp] == c;
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 33: {
                    char c = (char)(byArray[n2++] & 0xFF);
                    boolean bl10 = bl = rEGlobalData.cp != n && NativeRegExp.upcase(cArray[rEGlobalData.cp]) == NativeRegExp.upcase(c);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 28: {
                    char c = (char)NativeRegExp.getIndex(byArray, n2);
                    n2 += 2;
                    boolean bl11 = bl = rEGlobalData.cp != n && cArray[rEGlobalData.cp] == c;
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 35: {
                    char c = (char)NativeRegExp.getIndex(byArray, n2);
                    n2 += 2;
                    boolean bl12 = bl = rEGlobalData.cp != n && NativeRegExp.upcase(cArray[rEGlobalData.cp]) == NativeRegExp.upcase(c);
                    if (!bl) break;
                    ++rEGlobalData.cp;
                    break;
                }
                case 1: {
                    NativeRegExp.pushProgState(rEGlobalData, 0, 0, null, n3, n4);
                    int n10 = n2 + NativeRegExp.getOffset(byArray, n2);
                    byte by = byArray[n10++];
                    NativeRegExp.pushBackTrackState(rEGlobalData, by, n10);
                    n2 += 2;
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 23: {
                    REProgState rEProgState = NativeRegExp.popProgState(rEGlobalData);
                    n3 = rEProgState.continuation_pc;
                    n4 = rEProgState.continuation_op;
                    int n11 = NativeRegExp.getOffset(byArray, n2);
                    n2 += n11;
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 10: {
                    int n12 = NativeRegExp.getIndex(byArray, n2);
                    n2 += 2;
                    rEGlobalData.set_parens(n12, rEGlobalData.cp, 0);
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 11: {
                    int n13 = NativeRegExp.getIndex(byArray, n2);
                    n2 += 2;
                    int n14 = rEGlobalData.parens_index(n13);
                    rEGlobalData.set_parens(n13, n14, rEGlobalData.cp - n14);
                    if (n13 > rEGlobalData.lastParen) {
                        rEGlobalData.lastParen = n13;
                    }
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 20: {
                    int n15 = NativeRegExp.getIndex(byArray, n2);
                    n2 += 2;
                    bl = NativeRegExp.backrefMatcher(rEGlobalData, n15, cArray, n);
                    break;
                }
                case 50: {
                    int n16 = NativeRegExp.getIndex(byArray, n2);
                    n2 += 2;
                    if (rEGlobalData.cp != n && NativeRegExp.classMatcher(rEGlobalData, rEGlobalData.regexp.classList[n16], cArray[rEGlobalData.cp])) {
                        ++rEGlobalData.cp;
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 41: 
                case 42: {
                    NativeRegExp.pushProgState(rEGlobalData, 0, 0, rEGlobalData.backTrackStackTop, n3, n4);
                    byte by = n5 == 41 ? (byte)43 : 44;
                    NativeRegExp.pushBackTrackState(rEGlobalData, by, n2 + NativeRegExp.getOffset(byArray, n2));
                    n2 += 2;
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 43: 
                case 44: {
                    REProgState rEProgState = NativeRegExp.popProgState(rEGlobalData);
                    rEGlobalData.cp = rEProgState.index;
                    rEGlobalData.backTrackStackTop = rEProgState.backTrack;
                    n3 = rEProgState.continuation_pc;
                    n4 = rEProgState.continuation_op;
                    if (bl) {
                        if (n5 == 43) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (n5 == 43) break;
                    bl = true;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    int n17;
                    int n18;
                    int n19 = 0;
                    switch (n5) {
                        case 7: {
                            n19 = 1;
                        }
                        case 45: {
                            n18 = 0;
                            n17 = -1;
                            break;
                        }
                        case 8: {
                            n19 = 1;
                        }
                        case 46: {
                            n18 = 1;
                            n17 = -1;
                            break;
                        }
                        case 9: {
                            n19 = 1;
                        }
                        case 47: {
                            n18 = 0;
                            n17 = 1;
                            break;
                        }
                        case 6: {
                            n19 = 1;
                        }
                        case 48: {
                            n18 = NativeRegExp.getOffset(byArray, n2);
                            n17 = NativeRegExp.getOffset(byArray, n2 += 2) - 1;
                            n2 += 2;
                            break;
                        }
                        default: {
                            throw Kit.codeBug();
                        }
                    }
                    NativeRegExp.pushProgState(rEGlobalData, n18, n17, null, n3, n4);
                    if (n19 != 0) {
                        n4 = 51;
                        n3 = n2;
                        NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2);
                        n2 += 6;
                        n5 = byArray[n2++];
                        continue block43;
                    }
                    if (n18 != 0) {
                        n4 = 52;
                        n3 = n2;
                        n2 += 6;
                        n5 = byArray[n2++];
                        continue block43;
                    }
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2);
                    NativeRegExp.popProgState(rEGlobalData);
                    n2 += 4;
                    n2 += NativeRegExp.getOffset(byArray, n2);
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 49: {
                    n2 = n3;
                    n5 = n4;
                    continue block43;
                }
                case 51: {
                    REProgState rEProgState = NativeRegExp.popProgState(rEGlobalData);
                    if (!bl) {
                        if (rEProgState.min == 0) {
                            bl = true;
                        }
                        n3 = rEProgState.continuation_pc;
                        n4 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += NativeRegExp.getOffset(byArray, n2);
                        break;
                    }
                    if (rEProgState.min == 0 && rEGlobalData.cp == rEProgState.index) {
                        bl = false;
                        n3 = rEProgState.continuation_pc;
                        n4 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += NativeRegExp.getOffset(byArray, n2);
                        break;
                    }
                    int n20 = rEProgState.min;
                    int n19 = rEProgState.max;
                    if (n20 != 0) {
                        --n20;
                    }
                    if (n19 != -1) {
                        --n19;
                    }
                    if (n19 == 0) {
                        bl = true;
                        n3 = rEProgState.continuation_pc;
                        n4 = rEProgState.continuation_op;
                        n2 += 4;
                        n2 += NativeRegExp.getOffset(byArray, n2);
                        break;
                    }
                    NativeRegExp.pushProgState(rEGlobalData, n20, n19, null, rEProgState.continuation_pc, rEProgState.continuation_op);
                    n4 = 51;
                    n3 = n2;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)51, n2);
                    int n21 = NativeRegExp.getIndex(byArray, n2);
                    int n22 = NativeRegExp.getIndex(byArray, n2 += 2);
                    n2 += 4;
                    n5 = byArray[n2++];
                    int n23 = 0;
                    while (true) {
                        if (n23 >= n21) continue block43;
                        rEGlobalData.set_parens(n22 + n23, -1, 0);
                        ++n23;
                    }
                }
                case 52: {
                    int n23;
                    int n22;
                    int n21;
                    int n19;
                    REProgState rEProgState = NativeRegExp.popProgState(rEGlobalData);
                    if (!bl) {
                        if (rEProgState.max == -1 || rEProgState.max > 0) {
                            NativeRegExp.pushProgState(rEGlobalData, rEProgState.min, rEProgState.max, null, rEProgState.continuation_pc, rEProgState.continuation_op);
                            n4 = 52;
                            n3 = n2;
                            int n24 = NativeRegExp.getIndex(byArray, n2);
                            n19 = NativeRegExp.getIndex(byArray, n2 += 2);
                            n2 += 4;
                            n21 = 0;
                            while (n21 < n24) {
                                rEGlobalData.set_parens(n19 + n21, -1, 0);
                                ++n21;
                            }
                            n5 = byArray[n2++];
                            continue block43;
                        }
                        n3 = rEProgState.continuation_pc;
                        n4 = rEProgState.continuation_op;
                        break;
                    }
                    if (rEProgState.min == 0 && rEGlobalData.cp == rEProgState.index) {
                        bl = false;
                        n3 = rEProgState.continuation_pc;
                        n4 = rEProgState.continuation_op;
                        break;
                    }
                    int n25 = rEProgState.min;
                    n19 = rEProgState.max;
                    if (n25 != 0) {
                        --n25;
                    }
                    if (n19 != -1) {
                        --n19;
                    }
                    NativeRegExp.pushProgState(rEGlobalData, n25, n19, null, rEProgState.continuation_pc, rEProgState.continuation_op);
                    if (n25 != 0) {
                        n4 = 52;
                        n3 = n2;
                        n21 = NativeRegExp.getIndex(byArray, n2);
                        n22 = NativeRegExp.getIndex(byArray, n2 += 2);
                        n2 += 4;
                        n23 = 0;
                        while (n23 < n21) {
                            rEGlobalData.set_parens(n22 + n23, -1, 0);
                            ++n23;
                        }
                        n5 = byArray[n2++];
                        continue block43;
                    }
                    n3 = rEProgState.continuation_pc;
                    n4 = rEProgState.continuation_op;
                    NativeRegExp.pushBackTrackState(rEGlobalData, (byte)52, n2);
                    NativeRegExp.popProgState(rEGlobalData);
                    n2 += 4;
                    n2 += NativeRegExp.getOffset(byArray, n2);
                    n5 = byArray[n2++];
                    continue block43;
                }
                case 53: {
                    return true;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            if (!bl) {
                REBackTrackData rEBackTrackData = rEGlobalData.backTrackStackTop;
                if (rEBackTrackData != null) {
                    rEGlobalData.backTrackStackTop = rEBackTrackData.previous;
                    rEGlobalData.lastParen = rEBackTrackData.lastParen;
                    if (rEBackTrackData.parens != null) {
                        rEGlobalData.parens = (long[])rEBackTrackData.parens.clone();
                    }
                    rEGlobalData.cp = rEBackTrackData.cp;
                    rEGlobalData.stateStackTop = rEBackTrackData.stateStackTop;
                    n4 = rEGlobalData.stateStackTop.continuation_op;
                    n3 = rEGlobalData.stateStackTop.continuation_pc;
                    n2 = rEBackTrackData.continuation_pc;
                    n5 = rEBackTrackData.continuation_op;
                    continue;
                }
                return false;
            }
            n5 = byArray[n2++];
        }
    }

    private static boolean matchRegExp(REGlobalData rEGlobalData, RECompiled rECompiled, char[] cArray, int n, int n2, boolean bl) {
        rEGlobalData.parens = (long[])(rECompiled.parenCount != 0 ? new long[rECompiled.parenCount] : null);
        rEGlobalData.backTrackStackTop = null;
        rEGlobalData.stateStackTop = null;
        rEGlobalData.multiline = bl;
        rEGlobalData.regexp = rECompiled;
        rEGlobalData.lastParen = 0;
        int n3 = rEGlobalData.regexp.anchorCh;
        int n4 = n;
        while (n4 <= n2) {
            char c;
            if (n3 >= 0) {
                while (true) {
                    if (n4 == n2) {
                        return false;
                    }
                    c = cArray[n4];
                    if (c == n3 || (rEGlobalData.regexp.flags & 2) != 0 && NativeRegExp.upcase(c) == NativeRegExp.upcase((char)n3)) break;
                    ++n4;
                }
            }
            rEGlobalData.cp = n4;
            c = '\u0000';
            while (c < rECompiled.parenCount) {
                rEGlobalData.set_parens(c, -1, 0);
                ++c;
            }
            c = (char)(NativeRegExp.executeREBytecode(rEGlobalData, cArray, n2) ? 1 : 0);
            rEGlobalData.backTrackStackTop = null;
            rEGlobalData.stateStackTop = null;
            if (c != '\u0000') {
                rEGlobalData.skipped = n4 - n;
                return true;
            }
            ++n4;
        }
        return false;
    }

    Object executeRegExp(Context context, Scriptable scriptable, RegExpImpl regExpImpl, String string, int[] nArray, int n) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n2;
        int n3;
        boolean bl;
        REGlobalData rEGlobalData = new REGlobalData();
        int n4 = nArray[0];
        char[] cArray = string.toCharArray();
        int n5 = cArray.length;
        if (n4 > n5) {
            n4 = n5;
        }
        if (!(bl = NativeRegExp.matchRegExp(rEGlobalData, this.re, cArray, n4, n5, regExpImpl.multiline))) {
            if (n != 2) {
                return null;
            }
            return Undefined.instance;
        }
        nArray[0] = n3 = (n2 = rEGlobalData.cp);
        int n6 = n3 - (n4 + rEGlobalData.skipped);
        int n7 = n2;
        n2 -= n6;
        if (n == 0) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = NativeRegExp.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n2, n6);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (this.re.parenCount == 0) {
            regExpImpl.parens = null;
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens = new SubString[this.re.parenCount];
            int n8 = 0;
            while (n8 < this.re.parenCount) {
                int n9 = rEGlobalData.parens_index(n8);
                if (n9 != -1) {
                    int n10 = rEGlobalData.parens_length(n8);
                    regExpImpl.parens[n8] = object = new SubString(cArray, n9, n10);
                    if (n != 0) {
                        String string3 = ((SubString)object).toString();
                        scriptable2.put(n8 + 1, scriptable2, (Object)string3);
                    }
                } else if (n != 0) {
                    scriptable2.put(n8 + 1, scriptable2, Undefined.instance);
                }
                ++n8;
            }
            regExpImpl.lastParen = object;
        }
        if (n != 0) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n4 + rEGlobalData.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.charArray = cArray;
        regExpImpl.lastMatch.index = n2;
        regExpImpl.lastMatch.length = n6;
        regExpImpl.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n4;
            regExpImpl.leftContext.length = rEGlobalData.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n4 + rEGlobalData.skipped;
        }
        regExpImpl.rightContext.charArray = cArray;
        regExpImpl.rightContext.index = n7;
        regExpImpl.rightContext.length = n5 - n7;
        return object2;
    }

    int getFlags() {
        return this.re.flags;
    }

    private static void reportWarning(Context context, String string, String string2) {
        if (context.hasFeature(11)) {
            String string3 = ScriptRuntime.getMessage1(string, string2);
            Context.reportWarning(string3);
        }
    }

    private static void reportError(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        throw ScriptRuntime.constructError("SyntaxError", string3);
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        int n3 = string.length();
        if (n3 == 6) {
            char c = string.charAt(0);
            if (c == 'g') {
                string2 = "global";
                n2 = 3;
            } else if (c == 's') {
                string2 = "source";
                n2 = 2;
            }
        } else if (n3 == 9) {
            char c = string.charAt(0);
            if (c == 'l') {
                string2 = "lastIndex";
                n2 = 1;
            } else if (c == 'm') {
                string2 = "multiline";
                n2 = 5;
            }
        } else if (n3 == 10) {
            string2 = "ignoreCase";
            n2 = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: {
                n = 6;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n = 7;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return NativeRegExp.instanceIdInfo(n, n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return ScriptRuntime.wrapNumber(this.lastIndex);
            }
            case 2: {
                return new String(this.re.source);
            }
            case 3: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 1) != 0);
            }
            case 4: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 2) != 0);
            }
            case 5: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 4) != 0);
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n == 1) {
            this.lastIndex = ScriptRuntime.toNumber(object);
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "compile";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 1;
                string = "exec";
                break;
            }
            case 5: {
                n2 = 1;
                string = "test";
                break;
            }
            case 6: {
                n2 = 1;
                string = "prefix";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(REGEXP_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(REGEXP_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).compile(context, scriptable, objectArray);
            }
            case 2: 
            case 3: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).toString();
            }
            case 4: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).execSub(context, scriptable, objectArray, 1);
            }
            case 5: {
                Object object = NativeRegExp.realThis(scriptable2, idFunctionObject).execSub(context, scriptable, objectArray, 0);
                return Boolean.TRUE.equals(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).execSub(context, scriptable, objectArray, 2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static NativeRegExp realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeRegExp)) {
            throw NativeRegExp.incompatibleCallError(idFunctionObject);
        }
        return (NativeRegExp)scriptable;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                char c = string.charAt(0);
                if (c == 'e') {
                    string2 = "exec";
                    n = 4;
                    break;
                }
                if (c != 't') break;
                string2 = "test";
                n = 5;
                break;
            }
            case 6: {
                string2 = "prefix";
                n = 6;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 1;
                break;
            }
            case 8: {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 3;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

