/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public class ScriptableOutputStream
extends ObjectOutputStream {
    private Scriptable scope;
    private Map<Object, String> table;

    public ScriptableOutputStream(OutputStream outputStream, Scriptable scriptable) throws IOException {
        super(outputStream);
        this.scope = scriptable;
        this.table = new HashMap<Object, String>();
        this.table.put(scriptable, "");
        this.enableReplaceObject(true);
        this.excludeStandardObjectNames();
    }

    public void excludeAllIds(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof String && this.scope.get((String)object, this.scope) instanceof Scriptable) {
                this.addExcludedName((String)object);
            }
            ++n2;
        }
    }

    public void addOptionalExcludedName(String string) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string);
        if (object != null && object != UniqueTag.NOT_FOUND) {
            if (!(object instanceof Scriptable)) {
                throw new IllegalArgumentException("Object for excluded name " + string + " is not a Scriptable, it is " + object.getClass().getName());
            }
            this.table.put(object, string);
        }
    }

    public void addExcludedName(String string) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string);
        if (!(object instanceof Scriptable)) {
            throw new IllegalArgumentException("Object for excluded name " + string + " not found.");
        }
        this.table.put(object, string);
    }

    public boolean hasExcludedName(String string) {
        return this.table.get(string) != null;
    }

    public void removeExcludedName(String string) {
        this.table.remove(string);
    }

    public void excludeStandardObjectNames() {
        String[] stringArray = new String[]{"Object", "Object.prototype", "Function", "Function.prototype", "String", "String.prototype", "Math", "Array", "Array.prototype", "Error", "Error.prototype", "Number", "Number.prototype", "Date", "Date.prototype", "RegExp", "RegExp.prototype", "Script", "Script.prototype", "Continuation", "Continuation.prototype"};
        int n = 0;
        while (n < stringArray.length) {
            this.addExcludedName(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = new String[]{"XML", "XML.prototype", "XMLList", "XMLList.prototype"};
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.addOptionalExcludedName(stringArray2[n2]);
            ++n2;
        }
    }

    static Object lookupQualifiedName(Scriptable scriptable, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Object object = scriptable;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((object = ScriptableObject.getProperty((Scriptable)object, string2)) == null || !(object instanceof Scriptable)) break;
        }
        return object;
    }

    @Override
    protected Object replaceObject(Object object) throws IOException {
        String string = this.table.get(object);
        if (string == null) {
            return object;
        }
        return new PendingLookup(string);
    }

    static class PendingLookup
    implements Serializable {
        static final long serialVersionUID = -2692990309789917727L;
        private String name;

        PendingLookup(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }
    }
}

