/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GCamera;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GCutDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GCutAction
implements GLoggable,
GActionWithHelp {
    private String figureName;
    private String figure1Name;
    private String figure2Name;
    private String[] pLabels;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block6: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GCutDialog dialog = new GCutDialog(documentHandler.getOwnerFrame(), this);
                dialog.prefill(this.pLabels[0], this.pLabels[1], this.pLabels[2]);
                dialog.setVisible(true);
                if (dialog.getResult()) break block6;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figure2Name);
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels) + ", " + this.figure1Name + ", " + this.figure2Name));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info((Object)"");
        GDocument document = GDocumentHandler.getInstance().getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        GSolid solid = figure.getSolid();
        this.pLabels = new String[3];
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GStick && element2 instanceof GStick) {
                this.pLabels[0] = ((GStick)element1).label1;
                this.pLabels[1] = ((GStick)element1).label2;
                this.pLabels[2] = ((GStick)element2).label1;
                Collection<GFace> faces = solid.facesThroughPoints(this.pLabels);
                if (!faces.isEmpty()) {
                    this.pLabels[2] = ((GStick)element2).label2;
                }
            } else if (element1 instanceof GPoint3d && element2 instanceof GStick || element2 instanceof GPoint3d && element1 instanceof GStick) {
                if (element1 instanceof GPoint3d && element2 instanceof GStick) {
                    GPoint3d p = (GPoint3d)element1;
                    GStick s = (GStick)element2;
                    this.pLabels = new String[]{p.getLabel(), s.label1, s.label2};
                } else {
                    GPoint3d p = (GPoint3d)element2;
                    GStick s = (GStick)element1;
                    this.pLabels = new String[]{p.getLabel(), s.label1, s.label2};
                }
            }
        } else if (selection.size() == 3) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            GSelectable element3 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d && element3 instanceof GPoint3d) {
                this.pLabels = new String[]{((GPoint3d)element1).getLabel(), ((GPoint3d)element2).getLabel(), ((GPoint3d)element3).getLabel()};
            }
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        GPoint3d[] ps = new GPoint3d[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)("No end points: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
            }
            ps[i] = this.solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(this.pLabels);
        if (!faces.isEmpty()) {
            logger.info((Object)("No face: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("PointsBelongToSameFace", this.pLabels[0], this.pLabels[1], this.pLabels[2]));
        }
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GFigure[] childFigures = new GFigure[2];
        Vector3d v1 = new Vector3d((Tuple3d)ps[1].coords);
        v1.sub((Tuple3d)ps[0].coords);
        Vector3d v2 = new Vector3d((Tuple3d)ps[2].coords);
        v2.sub((Tuple3d)ps[0].coords);
        Vector3d n = new Vector3d();
        n.cross(v1, v2);
        n.normalize();
        if (n.z < -1.0E-7) {
            n.scale(-1.0);
        } else if (n.z < 1.0E-7) {
            if (n.y < -1.0E-7) {
                n.scale(-1.0);
            } else if (n.y < 1.0E-7 && n.x < -1.0E-7) {
                n.scale(-1.0);
            }
        }
        GSolid[] childSolids = new GSolid[2];
        for (int i = 0; i < 2; ++i) {
            childSolids[i] = this.solid.clone();
            childSolids[i].cutOff(this.pLabels[0], n);
            n.scale(-1.0);
            childSolids[i].makeConfig();
            double zoomFactor = childSolids[i].getBoundingSphere().getRadius() / this.solid.getBoundingSphere().getRadius();
            childFigures[i] = documentHandler.newFigure(childSolids[i], zoomFactor);
            childFigures[i].setTransparent(this.figure.isTransparent());
            childFigures[i].setLabelled(this.figure.isLabelled());
            GCamera camera = this.figure.getCamera();
            GCamera c = childFigures[i].getCamera();
            c.setAttitude(new Matrix3d(camera.getAttitude()));
            c.setInitialAttitude(new Matrix3d(camera.getInitialAttitude()));
            Color baseColor = this.figure.getBaseColor();
            childFigures[i].setBaseColor(new Color(baseColor.getRGB()));
        }
        this.figure1Name = childFigures[0].getName();
        this.figure2Name = childFigures[1].getName();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        documentHandler.removeFigure(this.figure1Name);
        this.document.removeFigure(this.figure1Name);
        documentHandler.removeFigure(this.figure2Name);
        this.document.removeFigure(this.figure2Name);
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)("Cut figure " + this.figureName + " into figures " + this.figure1Name + ", " + this.figure2Name + " undone"));
        logger.info((Object)this.figureName);
    }

    @Override
    public GLoggable clone() {
        GCutAction action = new GCutAction();
        action.figureName = this.figureName;
        action.pLabels = (String[])this.pLabels.clone();
        action.figure1Name = this.figure1Name;
        action.figure2Name = this.figure2Name;
        return action;
    }

    @Override
    public String toLogString() {
        StringBuffer buf = new StringBuffer();
        buf.append(GDictionary.get("CutFigureThroughPoints", this.figureName, this.pLabels[1], this.pLabels[0], this.pLabels[2]));
        return String.valueOf(buf);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("figure1Name");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure1 name");
            throw new Exception();
        }
        this.figure1Name = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("figure2Name");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure2 name");
            throw new Exception();
        }
        this.figure2Name = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p0Label>").append(this.pLabels[0]).append("</p0Label>").append("\n<p1Label>").append(this.pLabels[1]).append("</p1Label>").append("\n<p2Label>").append(this.pLabels[2]).append("</p2Label>").append("\n<figure1Name>").append(this.figure1Name).append("</figure1Name>").append("\n<figure2Name>").append(this.figure2Name).append("</figure2Name>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p0String, String p1String, String p2String) {
        logger.info((Object)(p0String + ", " + p1String + ", " + p2String));
        this.pLabels[0] = p0String.toUpperCase();
        this.pLabels[1] = p1String.toUpperCase();
        this.pLabels[2] = p2String.toUpperCase();
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("cutFigure", this.figureName);
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

