/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Set;
import net.geocentral.geometria.action.GDivideLineAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GDivideLineDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GDrawMidpointAction
extends GDivideLineAction {
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block6: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    logger.error((Object)GStringUtils.stackTraceToString(exception));
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GDivideLineDialog dialog = new GDivideLineDialog(documentHandler.getOwnerFrame(), this, false);
                dialog.prefill(this.p1Label, this.p2Label, this.numeratorString, this.denominatorString);
                dialog.setVisible(true);
                if (dialog.getResult()) break block6;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        return true;
    }

    @Override
    protected void prefill(Set<GSelectable> selection) {
        super.prefill(selection);
        this.numeratorString = "1";
        this.denominatorString = "1";
    }

    @Override
    public GLoggable clone() {
        GDrawMidpointAction action = new GDrawMidpointAction();
        action.figureName = this.figureName;
        action.numeratorString = this.numeratorString;
        action.denominatorString = this.denominatorString;
        action.p1Label = this.p1Label;
        action.p2Label = this.p2Label;
        action.addedPointLabel = this.addedPointLabel;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("DrawMidpointOfLine", this.p1Label + this.p2Label, this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.p1Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.p2Label = ns.item(0).getTextContent();
        this.numeratorString = "1";
        this.denominatorString = "1";
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p1Label>").append(this.p1Label).append("</p1Label>").append("\n<p2Label>").append(this.p2Label).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("drawMidpointOfLine", this.p1Label + this.p2Label);
    }
}

