/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Frame;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLabelFactory;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GXmlUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class GOpenFigureAction
implements GUndoable {
    private GDocument document;
    private String figureName;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        String filePath = documentHandler.getFigurePath();
        Frame ownerFrame = documentHandler.getOwnerFrame();
        FileFilter[] filters = new FileFilter[]{};
        GFileReader reader = documentHandler.getFileReader(ownerFrame, filePath, filters, true);
        try {
            reader.init();
            reader.selectFile();
            filePath = reader.getSelectedFilePath();
            if (filePath == null) {
                return false;
            }
            InputSource source = new InputSource(reader.getInputStream());
            solid = GXmlUtils.readSolid(source);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            documentHandler.error(exception);
            return false;
        }
        if (this.execute(solid)) {
            this.setFilePath(filePath);
            if (!silent) {
                documentHandler.setDocumentModified(true);
            }
            return true;
        }
        return false;
    }

    public boolean execute(GSolid solid) {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        List<String> figureNames = this.document.getFigureNames();
        this.figureName = GLabelFactory.getInstance().newFigureName(figureNames);
        GFigure figure = new GFigure(solid);
        figure.setName(this.figureName);
        this.document.addFigure(figure);
        this.document.setSelectedFigure(this.figureName);
        documentHandler.addFigure(figure);
        documentHandler.notepadChanged();
        documentHandler.clearUndoableActions();
        documentHandler.setActiveDocument(this.document);
        documentHandler.setMasterSolution(null);
        documentHandler.documentChanged();
        documentHandler.setDocumentModified(false);
        return true;
    }

    public void setFilePath(String filePath) {
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        documentHandler.setFigurePath(filePath);
        logger.info((Object)filePath);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.document.removeFigure(this.figureName);
        documentHandler.removeFigure(this.figureName);
        documentHandler.notepadChanged();
        logger.info((Object)this.figureName);
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("openFigure", this.figureName);
    }
}

