/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.geocentral.geometria.evaluator.function.GAcos;
import net.geocentral.geometria.evaluator.function.GAsin;
import net.geocentral.geometria.evaluator.function.GAtan;
import net.geocentral.geometria.evaluator.function.GCos;
import net.geocentral.geometria.evaluator.function.GSin;
import net.geocentral.geometria.evaluator.function.GSqrt;
import net.geocentral.geometria.evaluator.function.GTan;
import net.geocentral.geometria.evaluator.operator.GAdd;
import net.geocentral.geometria.evaluator.operator.GDivide;
import net.geocentral.geometria.evaluator.operator.GNegate;
import net.geocentral.geometria.evaluator.operator.GPower;
import net.geocentral.geometria.evaluator.operator.GSubtract;
import net.geocentral.geometria.evaluator.operator.GTimes;
import net.geocentral.geometria.evaluator.token.GConstant;
import net.geocentral.geometria.evaluator.token.GDecimal;
import net.geocentral.geometria.evaluator.token.GFunction;
import net.geocentral.geometria.evaluator.token.GLeftParanthesis;
import net.geocentral.geometria.evaluator.token.GOperator;
import net.geocentral.geometria.evaluator.token.GPi;
import net.geocentral.geometria.evaluator.token.GRightParanthesis;
import net.geocentral.geometria.evaluator.token.GToken;
import net.geocentral.geometria.evaluator.token.GTokenBounds;
import net.geocentral.geometria.evaluator.token.GValueToken;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GTokenizer {
    public static final String CHARSET = "[0-9\\.a-zA-Z\\p{InCyrillic}_]";
    private Map<String, GConstant> constants;
    private Map<String, GVariable> variables;
    private GTokenBounds errorTokenBounds;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public <T extends GVariable> GTokenizer(Collection<T> variableList) {
        logger.info(variableList);
        this.makeConstants();
        this.variables = new LinkedHashMap<String, GVariable>();
        if (variableList != null) {
            for (GVariable variable : variableList) {
                this.variables.put(variable.getName(), variable);
            }
        }
    }

    private void makeConstants() {
        logger.info((Object)"");
        this.constants = new LinkedHashMap<String, GConstant>();
        GPi pi = new GPi();
        this.constants.put(pi.getName().toLowerCase(), pi);
    }

    public Map<GToken, GTokenBounds> tokenize(String input) throws Exception {
        GToken token;
        logger.info((Object)input);
        ArrayList<GToken> tokenList = new ArrayList<GToken>();
        ArrayList<GTokenBounds> tokenBoundsList = new ArrayList<GTokenBounds>();
        StringBuffer buf = new StringBuffer();
        for (int pos = 0; pos < input.length(); ++pos) {
            GOperator token2;
            GTokenBounds tokenBounds;
            char ch = input.charAt(pos);
            if (String.valueOf(ch).matches(CHARSET)) {
                buf.append(ch);
                if (pos != input.length() - 1) continue;
                tokenBounds = new GTokenBounds(pos - buf.length() + 1, buf.length());
                try {
                    token = this.makeAlphaNumericToken(buf);
                }
                catch (Exception exception) {
                    this.errorTokenBounds = tokenBounds;
                    throw exception;
                }
                tokenList.add(token);
                tokenBoundsList.add(tokenBounds);
                continue;
            }
            if (buf.length() > 0) {
                tokenBounds = new GTokenBounds(pos - buf.length(), buf.length());
                try {
                    token = this.makeAlphaNumericToken(buf);
                }
                catch (Exception exception) {
                    this.errorTokenBounds = tokenBounds;
                    throw exception;
                }
                tokenList.add(token);
                tokenBoundsList.add(tokenBounds);
                buf = new StringBuffer();
            }
            if (ch == ' ') continue;
            if (ch == '(') {
                tokenList.add(new GLeftParanthesis());
                tokenBoundsList.add(new GTokenBounds(pos, 1));
                continue;
            }
            if (ch == ')') {
                tokenList.add(new GRightParanthesis());
                tokenBoundsList.add(new GTokenBounds(pos, 1));
                continue;
            }
            GToken prevToken = tokenList.isEmpty() ? null : (GToken)tokenList.get(tokenList.size() - 1);
            GTokenBounds tokenBounds2 = new GTokenBounds(pos, 1);
            try {
                token2 = this.makeOperator(ch, prevToken);
            }
            catch (Exception exception) {
                this.errorTokenBounds = tokenBounds2;
                throw exception;
            }
            tokenList.add(token2);
            tokenBoundsList.add(tokenBounds2);
        }
        Iterator tokenIterator = tokenList.iterator();
        Iterator tokenBoundsIterator = tokenBoundsList.iterator();
        LinkedHashMap<GToken, GTokenBounds> tokenMap = new LinkedHashMap<GToken, GTokenBounds>();
        while (tokenIterator.hasNext()) {
            token = (GToken)tokenIterator.next();
            GTokenBounds tokenBounds = (GTokenBounds)tokenBoundsIterator.next();
            tokenMap.put(token, tokenBounds);
        }
        return tokenMap;
    }

    private GToken makeAlphaNumericToken(StringBuffer buf) throws Exception {
        double value;
        logger.info((Object)"");
        String bufValue = String.valueOf(buf);
        if (bufValue.equalsIgnoreCase("acos")) {
            return new GAcos();
        }
        if (bufValue.equalsIgnoreCase("asin")) {
            return new GAsin();
        }
        if (bufValue.equalsIgnoreCase("atan")) {
            return new GAtan();
        }
        if (bufValue.equalsIgnoreCase("cos")) {
            return new GCos();
        }
        if (bufValue.equalsIgnoreCase("sin")) {
            return new GSin();
        }
        if (bufValue.equalsIgnoreCase("sqrt")) {
            return new GSqrt();
        }
        if (bufValue.equalsIgnoreCase("tan")) {
            return new GTan();
        }
        GConstant constant = this.constants.get(bufValue.toLowerCase());
        if (constant != null) {
            return this.copyOf(constant);
        }
        GVariable variable = this.variables.get(bufValue);
        if (variable != null) {
            return this.copyOf(variable);
        }
        try {
            value = Double.parseDouble(bufValue);
        }
        catch (Exception exception) {
            logger.info((Object)("Bad token: " + bufValue));
            throw new Exception(GDictionary.get("BadToken", bufValue));
        }
        return new GDecimal(value);
    }

    private GToken copyOf(final GVariable variable) {
        logger.info((Object)variable);
        GVariable v = new GVariable(){

            @Override
            public String getName() {
                return variable.getName();
            }

            @Override
            public double getValue() {
                return variable.getValue();
            }

            public String toString() {
                return variable.toString();
            }
        };
        return v;
    }

    private GToken copyOf(final GConstant constant) {
        logger.info((Object)constant);
        GConstant c = new GConstant(){

            @Override
            public String getName() {
                return constant.getName();
            }

            @Override
            public double getValue() {
                return constant.getValue();
            }

            public String toString() {
                return constant.toString();
            }
        };
        return c;
    }

    private GOperator makeOperator(char ch, GToken prevToken) throws Exception {
        logger.info((Object)(ch + " " + prevToken));
        if (ch == '+') {
            return new GAdd();
        }
        if (ch == '*') {
            return new GTimes();
        }
        if (ch == '/') {
            return new GDivide();
        }
        if (ch == '^') {
            return new GPower();
        }
        if (ch == '-') {
            if (prevToken == null) {
                return new GNegate();
            }
            if (prevToken instanceof GValueToken) {
                return new GSubtract();
            }
            if (prevToken instanceof GRightParanthesis) {
                return new GSubtract();
            }
            if (prevToken instanceof GFunction) {
                logger.info((Object)"Misplaced operator -");
                throw new Exception(GDictionary.get("MisplacedOperator", "-"));
            }
            return new GNegate();
        }
        logger.info((Object)("Bad token: " + ch));
        throw new Exception(GDictionary.get("BadToken", String.valueOf(ch)));
    }

    public Map<String, GConstant> getConstants() {
        return this.constants;
    }

    public Map<String, GVariable> getVariables() {
        return this.variables;
    }

    public GTokenBounds getErrorTokenBounds() {
        return this.errorTokenBounds;
    }
}

