/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.io;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.io.GExtensionFileFilter;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GLocalFileReader
implements GFileReader {
    protected String filePath;
    private JFileChooser fc;
    private Frame ownerFrame;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GLocalFileReader(Frame ownerFrame, String filePath, FileFilter[] filters, boolean acceptAllFileFilter) {
        logger.info((Object)filePath);
        this.ownerFrame = ownerFrame;
        this.filePath = filePath;
        this.fc = new JFileChooser(filePath);
        for (FileFilter filter : filters) {
            this.fc.addChoosableFileFilter(filter);
        }
        this.fc.setAcceptAllFileFilterUsed(acceptAllFileFilter);
    }

    @Override
    public void init() throws Exception {
        logger.info((Object)"");
    }

    @Override
    public void selectFile() throws Exception {
        logger.info((Object)"");
        int option = this.fc.showOpenDialog(this.ownerFrame);
        if (option != 0) {
            this.filePath = null;
        } else {
            File file = this.fc.getSelectedFile();
            if (file != null) {
                this.filePath = file.getPath();
                FileFilter filter = this.fc.getFileFilter();
                if (filter instanceof GExtensionFileFilter) {
                    String extension = ((GExtensionFileFilter)filter).getExtension();
                    if (!this.filePath.endsWith("." + extension)) {
                        this.filePath = this.filePath + "." + extension;
                    }
                }
            } else {
                this.filePath = null;
            }
        }
        logger.info((Object)this.filePath);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        logger.info((Object)this.filePath);
        try {
            return new FileInputStream(this.filePath);
        }
        catch (Exception exception) {
            logger.info((Object)("Cannot read file:" + this.filePath));
            throw new Exception(GDictionary.get("CannotReadFile", this.filePath));
        }
    }

    @Override
    public String getSelectedFilePath() {
        return this.filePath;
    }

    @Override
    public String getSelectedFileName() {
        File file = new File(this.filePath);
        return file.getName();
    }

    public FileFilter getFileFilter() {
        return this.fc.getFileFilter();
    }
}

