/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GXmlEntity;
import org.apache.log4j.Logger;

public abstract class GDocument
extends GXmlEntity {
    protected LinkedHashMap<String, GFigure> figures = new LinkedHashMap();
    protected GNotepad notepad = new GNotepad(this);
    private boolean prime;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public void removeAllFigures() {
        logger.info(this.figures.keySet());
        this.figures = new LinkedHashMap();
    }

    public GFigure getSelectedFigure() {
        for (GFigure figure : this.figures.values()) {
            if (!figure.isSelected()) continue;
            return figure;
        }
        return null;
    }

    public void setSelectedFigure(String figureName) {
        logger.info((Object)figureName);
        for (GFigure figure : this.figures.values()) {
            if (!figure.isSelected()) continue;
            figure.setSelected(false);
            break;
        }
        GFigure figure = this.figures.get(figureName);
        figure.setSelected(true);
    }

    public void setSelectedFigure(int index) {
        logger.info((Object)index);
        if (this.figures.isEmpty()) {
            return;
        }
        Iterator<GFigure> it = this.figures.values().iterator();
        GFigure figure = null;
        for (int i = 0; i <= index; ++i) {
            if (!it.hasNext()) {
                return;
            }
            figure = it.next();
        }
        figure.setSelected(true);
    }

    public void addFigure(GFigure figure, int index) {
        logger.info((Object)(figure + ", " + index));
        LinkedHashMap<String, GFigure> fs = new LinkedHashMap<String, GFigure>();
        int i = 0;
        Iterator<GFigure> it = this.figures.values().iterator();
        while (true) {
            if (i == index) {
                fs.put(figure.getName(), figure);
            }
            if (!it.hasNext()) break;
            GFigure f = it.next();
            fs.put(f.getName(), f);
            ++i;
        }
        this.figures = fs;
    }

    public void addFigure(GFigure figure) {
        logger.info((Object)figure);
        this.figures.put(figure.getName(), figure);
    }

    public int removeFigure(String figureName) {
        logger.info((Object)figureName);
        int index = 0;
        Iterator<GFigure> it = this.figures.values().iterator();
        while (it.hasNext() && !it.next().getName().equals(figureName)) {
            ++index;
        }
        GFigure figure = (GFigure)this.figures.remove(figureName);
        if (figure.isSelected() && !this.figures.isEmpty()) {
            Iterator<GFigure> it2 = this.figures.values().iterator();
            GFigure f = null;
            while (it2.hasNext()) {
                f = it2.next();
            }
            if (f != null) {
                f.setSelected(true);
            }
        }
        return index;
    }

    public void renameFigure(GFigure figure, String newName) {
        logger.info((Object)(figure + ", " + newName));
        LinkedHashMap<String, GFigure> fs = new LinkedHashMap<String, GFigure>();
        for (GFigure f : this.figures.values()) {
            if (f == figure) {
                figure.setName(newName);
            }
            fs.put(f.getName(), f);
        }
        this.figures = fs;
    }

    public GNotepadVariable getVariable(String variableName) {
        GNotepadRecord record = this.notepad.getRecord(variableName);
        return record == null ? null : record.getVariable();
    }

    public boolean hasFigures() {
        return !this.figures.isEmpty();
    }

    public GFigure getFigure(String figureName) {
        return this.figures.get(figureName);
    }

    public List<String> getFigureNames() {
        ArrayList<String> figureNames = new ArrayList<String>();
        for (String figureName : this.figures.keySet()) {
            figureNames.add(figureName);
        }
        return figureNames;
    }

    public Iterator<GFigure> getFigureIterator() {
        return this.figures.values().iterator();
    }

    public int getFigureCount() {
        return this.figures.size();
    }

    public GNotepad getNotepad() {
        return this.notepad;
    }

    public boolean isPrime() {
        return this.prime;
    }

    public void setPrime(boolean prime) {
        this.prime = prime;
    }

    public abstract GDocumentEnvelope getEnvelope();

    public abstract void setEnvelope(GDocumentEnvelope var1);
}

