/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.Font;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.util.GVersionManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class GOptions
extends GXmlEntity {
    private static final Font DEFAULT_FONT = new Font("Sans-serif", 1, 12);
    private static final String DEFAULT_LANGUAGE = "en";
    private Font font;
    private String language;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public Font getFont() {
        return this.font;
    }

    public void setFontSize(int fontSize) {
        String fontName = this.font.getName();
        int fontStyle = this.font.getStyle();
        this.font = new Font(fontName, fontStyle, fontSize);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public void make(Element node, GXmlEntity parent) throws Exception {
        logger.info((Object)"");
        this.makeVersion(node, parent);
        this.makeFont(node);
        this.makeLanguage(node);
    }

    private void makeFont(Element node) throws Exception {
        String fontName = node.getElementsByTagName("name").item(0).getTextContent();
        String fontStyleString = node.getElementsByTagName("style").item(0).getTextContent();
        int fontStyle = fontStyleString.equalsIgnoreCase("bold") ? 1 : (fontStyleString.equalsIgnoreCase("italic") ? 2 : 0);
        int fontSize = Integer.valueOf(node.getElementsByTagName("size").item(0).getTextContent());
        this.font = new Font(fontName, fontStyle, fontSize);
    }

    private void makeLanguage(Element node) throws Exception {
        this.language = node.getElementsByTagName("language").item(0).getTextContent();
    }

    @Override
    public void serialize(StringBuffer buf, boolean preamble) {
        String fontStyleString;
        logger.info((Object)"");
        if (preamble) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n<options xmlns=\"").append("http://geocentral.net").append("\">").append("\n<version>").append(GVersionManager.getInstance().getApplicationVersion()).append("</version>");
        } else {
            buf.append("\n<options>");
        }
        switch (this.font.getStyle()) {
            case 1: {
                fontStyleString = "bold";
                break;
            }
            case 2: {
                fontStyleString = "italic";
                break;
            }
            default: {
                fontStyleString = "plain";
            }
        }
        buf.append("\n<font>").append("\n<name>").append(this.font.getName()).append("</name>").append("\n<style>").append(fontStyleString).append("</style>").append("\n<size>").append(this.font.getSize()).append("</size>").append("\n</font>").append("\n<language>").append(this.language).append("</language>").append("\n</options>");
    }

    public void setDefaults() {
        logger.info((Object)"Setting default options");
        this.font = DEFAULT_FONT;
        this.language = System.getProperty("language");
        if (this.language == null) {
            this.language = DEFAULT_LANGUAGE;
        }
    }

    @Override
    public String getSchemaFile(String version) {
        return GVersionManager.getInstance().getOptionsSchema(version);
    }
}

