/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Container;
import java.awt.Frame;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.io.GFileWriter;
import net.geocentral.geometria.io.GRemoteFileReader;
import net.geocentral.geometria.io.GRemoteFileWriter;
import net.geocentral.geometria.model.GOptions;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GHelpManager;
import net.geocentral.geometria.util.GOptionsManager;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import net.geocentral.geometria.view.GContainer;
import net.geocentral.geometria.view.GMainPanel;
import net.geocentral.geometria.view.GMenuBar;
import org.apache.log4j.Logger;

public class GApplet
extends JApplet
implements GContainer {
    private GMainPanel mainPanel;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    @Override
    public void init() {
        logger.info((Object)"");
        try {
            String language = this.getParameter("language");
            GOptions options = GOptionsManager.getInstance().getOptions();
            options.setLanguage(language);
            this.load();
            String documentLocation = this.getParameter("document");
            if (documentLocation != null) {
                GDocumentHandler.getInstance().setDocument(documentLocation, null);
            }
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
        }
    }

    @Override
    public void load() throws Exception {
        GVersionManager versionManager = GVersionManager.getInstance();
        logger.info((Object)String.format("Starting %s %s:%s", versionManager.getApplicationName(), versionManager.getApplicationVersion(), versionManager.getSvnRevision()));
        this.mainPanel = new GMainPanel();
        GDictionary.init();
        GGraphicsFactory.getInstance().setFont();
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        documentHandler.setContainer(this);
        documentHandler.setMainPanel(this.mainPanel);
        documentHandler.init();
        GHelpManager.getInstance().init();
        GMenuBar menuBar = new GMenuBar();
        menuBar.loadMenus();
        this.setJMenuBar(menuBar);
        this.mainPanel.layoutComponents();
        this.layoutComponents();
        documentHandler.documentChanged();
        this.repaint();
        this.validate();
    }

    private void layoutComponents() throws Exception {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        GGraphicsFactory.getInstance().layoutToolBars(this.getContentPane());
        this.getContentPane().add(this.mainPanel);
    }

    @Override
    public GFileReader getFileReader(Frame ownerFrame, String filePath, FileFilter[] fileFilters, boolean acceptAllFilesFilter) {
        URL baseUrl;
        logger.info((Object)filePath);
        try {
            baseUrl = new URL(String.format("%s%s/", this.getCodeBase(), "samples"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return new GRemoteFileReader(this.getOwnerFrame(), baseUrl);
    }

    @Override
    public GFileWriter getFileWriter(Frame ownerFrame, String filePath, FileFilter[] fileFilters, boolean acceptAllFilesFilter) {
        logger.info((Object)filePath);
        URL baseUrl = this.getCodeBase();
        return new GRemoteFileWriter(ownerFrame, baseUrl, filePath);
    }

    @Override
    public Frame getOwnerFrame() {
        Container c = this.getParent();
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    @Override
    public GMainPanel getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public void exit() {
        logger.info((Object)"");
        try {
            String path = GVersionManager.getInstance().getVendor();
            URL url = new URL(path);
            this.getAppletContext().showDocument(url);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
        }
        this.stop();
    }
}

