/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.geocentral.geometria.model.GAuthor;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import org.apache.log4j.Logger;

public class GEnvelopeViewPane
extends JPanel {
    private GDocument document;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GEnvelopeViewPane(GDocument document) {
        logger.info((Object)"");
        this.document = document;
    }

    public void layoutComponents() {
        String authorWeb;
        String authorEmail;
        logger.info((Object)"");
        this.setLayout(new BoxLayout(this, 1));
        GDocumentEnvelope envelope = this.document.getEnvelope();
        JPanel authorWrapPane = new JPanel();
        authorWrapPane.setLayout(new BoxLayout(authorWrapPane, 0));
        authorWrapPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel authorPane = new JPanel();
        authorPane.setLayout(new BoxLayout(authorPane, 1));
        GAuthor author = envelope.getAuthor();
        String authorName = author.getName();
        if (!authorName.isEmpty()) {
            authorPane.add(new JLabel(String.format("%s: %s", GDictionary.get("Author", new String[0]), authorName)));
        }
        if (!(authorEmail = author.getEmail()).isEmpty()) {
            authorPane.add(new JLabel(String.format("%s: %s", GDictionary.get("Email", new String[0]), authorEmail)));
        }
        if (!(authorWeb = author.getWeb()).isEmpty()) {
            authorPane.add(new JLabel(String.format("%s: %s", GDictionary.get("Web", new String[0]), authorWeb)));
        }
        authorWrapPane.add(authorPane);
        authorWrapPane.add(Box.createHorizontalGlue());
        this.add(authorWrapPane);
        String comments = envelope.getComments();
        if (!comments.isEmpty()) {
            JPanel commentsPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Comments", new String[0]));
            commentsPane.setLayout(new BoxLayout(commentsPane, 1));
            JTextArea commentsTextArea = new JTextArea(comments);
            commentsTextArea.setBackground(new Color(238, 238, 238));
            commentsTextArea.setEditable(false);
            JScrollPane sp = GGraphicsFactory.getInstance().createCommentsArea(commentsTextArea);
            commentsPane.add(sp);
            this.add(commentsPane);
        }
        this.add(GGraphicsFactory.getInstance().createSmallRigidArea());
    }
}

