/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.geocentral.geometria.action.GIntersectAction;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GIntersectDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GIntersectAction action;
    private JTextField p11TextField;
    private JTextField p12TextField;
    private JTextField p21TextField;
    private JTextField p22TextField;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GIntersectDialog(Frame ownerFrame, GIntersectAction action) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.action = action;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("IntersectLines", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("ReferencePoints", new String[0]));
        topPane.setLayout(new BoxLayout(topPane, 0));
        this.p11TextField = GGraphicsFactory.getInstance().createLabelInput(null);
        this.p21TextField = GGraphicsFactory.getInstance().createLabelInput(null);
        JPanel leftInputPane = GGraphicsFactory.getInstance().createContainerAdjustCenter(this.p11TextField, this.p21TextField, 45);
        topPane.add(leftInputPane);
        JPanel centerInputPane = GGraphicsFactory.getInstance().createImagePane("/images/Intersect.png");
        topPane.add(centerInputPane);
        this.p22TextField = GGraphicsFactory.getInstance().createLabelInput(null);
        this.p12TextField = GGraphicsFactory.getInstance().createLabelInput(null);
        JPanel rightInputPane = GGraphicsFactory.getInstance().createContainerAdjustCenter(this.p22TextField, this.p12TextField, 45);
        topPane.add(rightInputPane);
        this.getContentPane().add(topPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    public void prefill(String[] pLabels) {
        logger.info(Arrays.asList(pLabels));
        this.p11TextField.setText(pLabels[0]);
        this.p12TextField.setText(pLabels[1]);
        this.p21TextField.setText(pLabels[2]);
        this.p22TextField.setText(pLabels[3]);
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        this.action.setInput(this.p11TextField.getText().trim(), this.p12TextField.getText().trim(), this.p21TextField.getText().trim(), this.p22TextField.getText().trim());
        try {
            this.action.validateApply();
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

