/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.geocentral.geometria.action.GRenamePointAction;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GRenamePointDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GRenamePointAction action;
    private JTextField oldLabelInput;
    private JTextField newLabelInput;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GRenamePointDialog(Frame ownerFrame, GRenamePointAction action) {
        super(ownerFrame, true);
        this.action = action;
        logger.info((Object)"");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("RenamePoint", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel inputPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Labels", new String[0]));
        inputPane.add(Box.createHorizontalGlue());
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        JPanel oldLabelPane = new JPanel();
        oldLabelPane.setLayout(new BoxLayout(oldLabelPane, 0));
        JLabel label1 = new JLabel(GDictionary.get("OldLabel", new String[0]));
        oldLabelPane.add(label1);
        oldLabelPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.oldLabelInput = GGraphicsFactory.getInstance().createLabelInput(null);
        oldLabelPane.add(this.oldLabelInput);
        inputPane.add(oldLabelPane);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel newLabelPane = new JPanel();
        newLabelPane.setLayout(new BoxLayout(newLabelPane, 0));
        JLabel label2 = new JLabel(GDictionary.get("NewLabel", new String[0]));
        newLabelPane.add(label2);
        newLabelPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.newLabelInput = GGraphicsFactory.getInstance().createLabelInput(null);
        newLabelPane.add(this.newLabelInput);
        inputPane.add(newLabelPane);
        inputPane.add(Box.createHorizontalGlue());
        this.getContentPane().add(inputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    public void prefill(String oldLabel) {
        logger.info((Object)oldLabel);
        this.oldLabelInput.setText(oldLabel);
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        this.action.setInput(this.oldLabelInput.getText().trim(), this.newLabelInput.getText().trim());
        try {
            this.action.validateApply();
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

