/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.geocentral.geometria.action.GSolutionAnswerAction;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.model.answer.GNumberAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GSolutionNumberAnswerDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GSolution document;
    private GSolutionAnswerAction action;
    private GNumberAnswer problemAnswer;
    private JTextField inputTextField;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GSolutionNumberAnswerDialog(Frame ownerFrame, GSolution document, GSolutionAnswerAction action, GNumberAnswer problemAnswer) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.document = document;
        this.action = action;
        this.problemAnswer = problemAnswer;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("Answer", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        inputPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        inputPane.add(new JLabel(GDictionary.get("Answer", new String[0])));
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.inputTextField = GGraphicsFactory.getInstance().createVariableInput(null);
        inputPane.add(this.inputTextField);
        this.getContentPane().add(inputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
        GNotepadRecord record = this.document.getNotepad().getSelectedRecord();
        if (record != null) {
            String variableName = record.getVariable().getName();
            this.inputTextField.setText(variableName);
        }
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        GNumberAnswer answer = null;
        answer = new GNumberAnswer();
        try {
            answer.validateInput(this.inputTextField.getText().trim(), this.document);
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.action.setInput(this.inputTextField.getText().trim(), null);
        if (!this.problemAnswer.verify(answer, 1.0E-7)) {
            this.dispose();
            GGraphicsFactory.getInstance().showAnswerEvaluation(false);
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
        GGraphicsFactory.getInstance().showAnswerEvaluation(true);
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

