/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jtides.JTides;
import jtides.MyJButton;

public final class SiteTree
extends JPanel {
    JTides main;
    public JScrollPane scrollPane;
    Enumeration searchEnum;
    private JButton CollapseButton;
    private JButton ExpandButton;
    private JButton FindButton;
    private JButton FindNextButton;
    private JTextArea SearchEntry;
    private JMenuItem closeMenuitem;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JPopupMenu popupMenu;
    public JTree tree;

    public SiteTree(JTides jTides) {
        this.main = jTides;
        this.searchEnum = this.main.tideComp.root.depthFirstEnumeration();
        this.initComponents();
        this.setFocusTraversalKeys(0, new HashSet());
        this.setFocusTraversalKeys(1, new HashSet());
        this.tree.setFocusTraversalKeys(0, new HashSet());
        this.tree.setFocusTraversalKeys(1, new HashSet());
        this.tree.setShowsRootHandles(true);
        this.tree.setScrollsOnExpand(true);
        this.tree.setModel(null);
        this.setupIcons(this.tree);
        this.initWhenReady();
    }

    private void setupIcons(JTree jTree) {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
        defaultTreeCellRenderer.setClosedIcon(new ImageIcon(this.main.getClass().getResource("icons/Folder.png")));
        defaultTreeCellRenderer.setOpenIcon(new ImageIcon(this.main.getClass().getResource("icons/Open.png")));
        defaultTreeCellRenderer.setLeafIcon(new ImageIcon(this.main.getClass().getResource("icons/Document.png")));
    }

    JTree getTree() {
        return this.tree;
    }

    private void initWhenReady() {
        this.tree.setModel(this.main.tideComp.dtm);
        this.tree.expandRow(0);
    }

    private void searchTest(boolean bl) {
        String string = this.SearchEntry.getText();
        if (string.length() > 0) {
            this.search(string, bl);
        }
    }

    public void search(String string, boolean bl) {
        string = string.toLowerCase();
        if (bl) {
            this.searchEnum = this.main.tideComp.root.depthFirstEnumeration();
        }
        boolean bl2 = false;
        while (this.searchEnum.hasMoreElements() && !bl2) {
            Object e = this.searchEnum.nextElement();
            String string2 = e.toString().toLowerCase();
            if (string2.indexOf(string) == -1) continue;
            bl2 = true;
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)e).getPath());
            this.tree.scrollPathToVisible(treePath);
            this.tree.setSelectionRow(this.tree.getRowForPath(treePath));
            this.tree.makeVisible(treePath);
        }
        if (!bl2) {
            Toolkit.getDefaultToolkit().beep();
            this.searchEnum = this.main.tideComp.root.depthFirstEnumeration();
        }
    }

    public void expand(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        } else {
            for (int i = this.tree.getRowCount(); i >= 0; --i) {
                this.tree.collapseRow(i);
            }
            this.tree.expandRow(0);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.closeMenuitem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jToolBar1 = new JToolBar();
        this.CollapseButton = new MyJButton();
        this.ExpandButton = new MyJButton();
        this.jLabel1 = new JLabel();
        this.SearchEntry = new JTextArea();
        this.FindButton = new MyJButton();
        this.FindNextButton = new MyJButton();
        this.closeMenuitem.setText("Close");
        this.closeMenuitem.setToolTipText("Close the site explorer");
        this.closeMenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SiteTree.this.closeMenuitemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuitem);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SiteTree.this.formFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SiteTree.this.formFocusLost(focusEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SiteTree.this.formKeyPressed(keyEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SiteTree.this.formMouseClicked(mouseEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SiteTree.this.treeFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SiteTree.this.treeFocusLost(focusEvent);
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SiteTree.this.treeKeyPressed(keyEvent);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SiteTree.this.treeMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SiteTree.this.treeMouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SiteTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.add((Component)this.jScrollPane1, "Center");
        this.CollapseButton.setText("Collapse");
        this.CollapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SiteTree.this.CollapseButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.CollapseButton);
        this.ExpandButton.setText("Expand");
        this.ExpandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SiteTree.this.ExpandButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.ExpandButton);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Search:");
        this.jLabel1.setMinimumSize(new Dimension(60, 16));
        this.jLabel1.setPreferredSize(new Dimension(60, 16));
        this.jToolBar1.add(this.jLabel1);
        this.SearchEntry.setRows(1);
        this.SearchEntry.setBorder(BorderFactory.createEtchedBorder());
        this.SearchEntry.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SiteTree.this.SearchEntryKeyPressed(keyEvent);
            }
        });
        this.jToolBar1.add(this.SearchEntry);
        this.FindButton.setText("Find");
        this.FindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SiteTree.this.FindButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.FindButton);
        this.FindNextButton.setText("Find Next");
        this.FindNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SiteTree.this.FindNextButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.FindNextButton);
        this.add((Component)this.jToolBar1, "North");
    }

    private void treeFocusLost(FocusEvent focusEvent) {
    }

    private void formFocusLost(FocusEvent focusEvent) {
    }

    private void treeMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void treeMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void closeMenuitemActionPerformed(ActionEvent actionEvent) {
        this.main.tabbedPaneManager.close();
    }

    private void treeFocusGained(FocusEvent focusEvent) {
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.tree.requestFocusInWindow();
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.main.tabbedPaneManager.handleKey(keyEvent);
    }

    private void treeKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            keyEvent.consume();
            this.processMouseSelection();
        } else {
            this.main.tabbedPaneManager.handleKey(keyEvent);
        }
    }

    private void SearchEntryKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            keyEvent.consume();
            this.searchTest(false);
            this.SearchEntry.requestFocusInWindow();
        } else {
            this.main.tabbedPaneManager.handleKey(keyEvent);
        }
    }

    private void CollapseButtonActionPerformed(ActionEvent actionEvent) {
        this.expand(false);
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        this.processMouseSelection();
    }

    private void FindNextButtonActionPerformed(ActionEvent actionEvent) {
        this.searchTest(false);
    }

    private void ExpandButtonActionPerformed(ActionEvent actionEvent) {
        this.expand(true);
    }

    private void FindButtonActionPerformed(ActionEvent actionEvent) {
        this.searchTest(true);
    }

    private void formMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.processMouseSelection();
        }
    }

    private void handleMouse(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.isVisible()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            this.main.setActiveMenu(this.popupMenu);
        }
    }

    public void processMouseSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            String string = "";
            int n = treePath.getPathCount();
            if (n == 5) {
                for (int i = 1; i < n; ++i) {
                    string = string + treePath.getPathComponent(i).toString() + (i < n - 1 ? "\t" : "");
                }
                Vector vector = this.main.tideComp.parseDelimLine(string, "\t");
                String string2 = (String)vector.elementAt(0);
                string2 = string2.indexOf("Current") != -1 ? "C" : "T";
                vector.setElementAt(string2, 0);
                string = this.main.tideComp.mergeDelimLine(vector, "\t");
                this.main.openFileOnPartialPath(string);
            }
        }
    }
}

