/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import jtides.JTides;
import jtides.Pos;
import jtides.Rts;
import jtides.SiteSet;

public final class SunComp {
    long oldTime;
    double oldLat;
    double oldLng;
    public Pos compPos;
    double compSid;
    double compJD;
    JTides main;

    SunComp(JTides jTides) {
        this.main = jTides;
        this.oldTime = -1L;
        this.oldLat = -1.0;
        this.oldLng = -1.0;
    }

    double tf_to_jd(double d) {
        return d + 2440587.5;
    }

    double jd_to_tf(double d) {
        return d - 2440587.5;
    }

    Pos calcsun(double d) {
        double d2;
        Pos pos = new Pos();
        double d3 = (d - 2451545.0) * 2.7378507871321E-5;
        double d4 = 280.46645 + 36000.76983 * d3 + 3.032E-4 * d3 * d3;
        double d5 = 357.5291 + 35999.0503 * d3 - 1.559E-4 * d3 * d3 - 4.8E-7 * d3 * d3 * d3;
        double d6 = d5 * 0.01745329251994329;
        double d7 = 0.016708617 - 4.2037E-5 * d3 - 1.236E-7 * d3 * d3;
        double d8 = (1.9146 - 0.004817 * d3 - 1.4E-5 * d3 * d3) * Math.sin(d6);
        d8 += (0.019993 - 1.01E-4 * d3) * Math.sin(2.0 * d6);
        double d9 = d4 + (d8 += 2.9E-4 * Math.sin(3.0 * d6));
        double d10 = d5 + d8;
        double d11 = 1.000001018 * (1.0 - d7 * d7) / (1.0 + d7 * Math.cos(d10 * 0.01745329251994329));
        double d12 = 125.04 - 1934.136 * d3;
        double d13 = 0.01745329251994329 * (d9 - 0.00569 - 0.00478 * Math.sin(0.01745329251994329 * d12));
        double d14 = 23.4391666666667 - 0.0130041666666666 * d3 - 1.63888888E-7 * d3 * d3 + 5.03611111111E-8 * d3 * d3 * d3;
        double d15 = 57.29577951308232 * Math.atan2(Math.cos(d14 = 0.01745329251994329 * (d14 + 0.00256 * Math.cos(0.01745329251994329 * d12))) * Math.sin(d13), Math.cos(d13));
        if (d15 < 0.0) {
            d15 = 360.0 + d15;
        }
        pos.lat = d2 = 57.29577951308232 * Math.asin(Math.sin(d14) * Math.sin(d13));
        pos.lng = d15;
        return pos;
    }

    double sidtime(double d, double d2) {
        double d3 = (Math.floor(d) + 0.5 - 2451545.0) * 2.7378507871321E-5;
        double d4 = 280.46061837;
        d4 += 360.98564736629 * (d - 2451545.0);
        d4 += 3.87933E-4 * d3 * d3;
        d4 -= d3 * d3 * d3 * 2.58331180573495E-8;
        d4 -= d2;
        d4 *= 0.00277777777777778;
        d4 -= Math.floor(d4);
        return d4 *= 360.0;
    }

    double mod1(double d) {
        double d2 = d;
        d = Math.abs(d);
        d -= Math.floor(d);
        if (d2 < 0.0) {
            d = 1.0 - d;
        }
        return d;
    }

    Rts rmsTime(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Rts rts = new Rts();
        d4 *= 0.0416666666666667;
        rts.transit = (d6 - d3 - d) / 360.0;
        d5 = 0.01745329251994329 * d5;
        d2 = 0.01745329251994329 * d2;
        d7 = 0.01745329251994329 * d7;
        double d8 = Math.sin(d5) - Math.sin(d2) * Math.sin(d7);
        if ((d8 /= Math.cos(d2) * Math.cos(d7)) < 1.0 && d8 > -1.0) {
            d8 = 57.29577951308232 * Math.acos(d8) * 0.00277777777777778;
            rts.rise = this.mod1(rts.transit - d8 + d4) * 24.0;
            rts.set = this.mod1(rts.transit + d8 + d4) * 24.0;
            rts.transit = this.mod1(rts.transit + d4) * 24.0;
        } else {
            rts.rise = d8 = d8 >= 0.0 ? -100.0 : 100.0;
            rts.transit = d8;
            rts.set = d8;
        }
        return rts;
    }

    Rts compRTS(SiteSet siteSet, long l, int n) {
        double d;
        l = (long)((double)l + siteSet.tz * 3600.0);
        l -= l % 86400L;
        l = (long)((double)l - siteSet.tz * 3600.0);
        double[] dArray = new double[]{-0.833333333333333, -6.0, -12.0, -18.0};
        Rts rts = new Rts();
        if (l != this.oldTime || siteSet.lat != this.oldLat || siteSet.lng != this.oldLng) {
            this.oldLat = siteSet.lat;
            this.oldLng = siteSet.lng;
            this.oldTime = l;
            d = (double)l / 3600.0;
            d /= 24.0;
            d = this.tf_to_jd(d);
            this.compSid = this.sidtime(Math.floor(d) + 0.5, 0.0);
            this.compJD = d;
            this.compPos = this.calcsun(d);
        }
        d = dArray[n];
        rts = this.rmsTime(this.compSid, siteSet.lat, siteSet.lng, siteSet.tz, d, this.compPos.lng, this.compPos.lat);
        if (siteSet.daylightInEffect) {
            rts.rise += 1.0;
            rts.transit += 1.0;
            rts.set += 1.0;
        }
        return rts;
    }
}

