package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.metal.*;

public class KunststoffComboBoxUI extends MetalComboBoxUI {
  private Color col1 = new Color(232, 232, 232, 0);
  private Color col2 = new Color(232, 232, 232, 128);
  private Color col3 = new Color(68, 68, 68, 0);
  private Color col4 = new Color(68, 68, 68, 64);

  public static ComponentUI createUI(JComponent c) {
    return new KunststoffComboBoxUI();
  }

  /*
   * Scheint nie aufgerufen zu werden. Noch unklar warum nicht.
   */
  public void paint(Graphics g, JComponent c) {
    c.setBackground(Color.blue);
    super.paint(g, c);
    Graphics2D g2D = (Graphics2D) g;
    GradientPaint gradient1 = new GradientPaint(0.0f, (float) c.getHeight()/3, col1, 0.0f, 0.0f, col2);
    GradientPaint gradient2 = new GradientPaint(0.0f, (float) c.getHeight()/3, col3, 0.0f, (float) c.getHeight(), col4);
    Rectangle rec1 = new Rectangle(c.getX(), c.getY(), c.getWidth(), c.getHeight()/3);
    Rectangle rec2 = new Rectangle(c.getX(), c.getHeight()/3, c.getWidth(), c.getHeight());
    g2D.setPaint(gradient1);
    g2D.fill(rec1);
    g2D.setPaint(gradient2);
    g2D.fill(rec2);
  }


}