package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.metal.*;

public class KunststoffScrollBarUI extends MetalScrollBarUI {
  private Color col1 = new Color(255, 255, 255, 64);
  private Color col2 = new Color(255, 255, 255, 0);
  private Color col3 = new Color(0, 0, 0, 0);
  private Color col4 = new Color(0, 0, 0, 64);

  public static ComponentUI createUI(JComponent c)    {
    return new KunststoffScrollBarUI();
  }

  protected JButton createDecreaseButton(int orientation) {
    decreaseButton = new KunststoffScrollButton(orientation, scrollBarWidth, isFreeStanding);
    return decreaseButton;
  }

  protected JButton createIncreaseButton(int orientation) {
    increaseButton =  new KunststoffScrollButton(orientation, scrollBarWidth, isFreeStanding);
    return increaseButton;
  }


  /**
   * Calls the super classes paint(Graphics g) method and then paints two gradients.
   * The dirction of the gradients depends on the direction of the scrollbar.
   */
  protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
    super.paintThumb(g, c, thumbBounds);
    Graphics2D g2D = (Graphics2D) g;
    Rectangle rec1;
    Rectangle rec2;
    Point grad1Start;
    Point grad1End;
    Point grad2Start;
    Point grad2End;
    if (scrollbar.getOrientation() == JScrollBar.HORIZONTAL ) {
      grad1Start = new Point(thumbBounds.x, thumbBounds.y+1);
      grad1End = new Point(thumbBounds.x, thumbBounds.y + thumbBounds.height/2);
      grad2Start = grad1End;
      grad2End = new Point(thumbBounds.x, thumbBounds.y + thumbBounds.height);
      rec1 = new Rectangle(grad1Start, new Dimension(thumbBounds.width, thumbBounds.height/2));
      rec2 = new Rectangle(grad2Start, new Dimension(thumbBounds.width, thumbBounds.height/2+1));
    } else {
      grad1Start = new Point(thumbBounds.x+1, thumbBounds.y);
      grad1End = new Point(thumbBounds.x + thumbBounds.width/2, thumbBounds.y);
      grad2Start = grad1End;
      grad2End = new Point(thumbBounds.x + thumbBounds.width, thumbBounds.y);
      rec1 = new Rectangle(grad1Start, new Dimension(thumbBounds.width/2, thumbBounds.height));
      rec2 = new Rectangle(grad2Start, new Dimension(thumbBounds.width/2+1, thumbBounds.height));
    }
    GradientPaint gradient1 = new GradientPaint(grad1Start, col1, grad1End, col2);
    GradientPaint gradient2 = new GradientPaint(grad2Start, col3, grad2End, col4);
    g2D.setPaint(gradient1);
    g2D.fill(rec1);
    g2D.setPaint(gradient2);
    g2D.fill(rec2);
  }

}