package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

public class KunststoffTabbedPaneUI extends BasicTabbedPaneUI {
  /*
  private Color col1 = new Color(255, 255, 255, 0);
  private Color col2 = new Color(255, 255, 255, 128);
  private Color col3 = new Color(0, 0, 0, 0);
  private Color col4 = new Color(0, 0, 0, 64);
  */
  private Color col1 = new Color(232, 232, 232, 0);
  private Color col2 = new Color(232, 232, 232, 128);
  private Color col3 = new Color(68, 68, 68, 0);
  private Color col4 = new Color(68, 68, 68, 64);



  private Color selectColor;

  public static ComponentUI createUI(JComponent c) {
    return new KunststoffTabbedPaneUI();
  }

  protected void installDefaults() {
    super.installDefaults();
    selectColor = UIManager.getColor("TabbedPane.selected");
  }

  /* This method only works correctly if there is only one row of tabs. Fixing this
     would be a great way of contributing to the kunststoff L&F.
   */
  protected void paintTab(Graphics g, int tabPlacement,
                            Rectangle[] rects, int tabIndex,
                            Rectangle iconRect, Rectangle textRect) {
    super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
    Graphics2D g2D = (Graphics2D) g;

    Rectangle tabRect = rects[tabIndex];

    // paint shadow that the selected tab throws on the next tab
    int selectedIndex = tabPane.getSelectedIndex();
    if (tabPlacement == JTabbedPane.TOP || tabPlacement == JTabbedPane.BOTTOM) {
      if (tabIndex == selectedIndex+1) {
        GradientPaint gradientShadow = new GradientPaint((float) tabRect.getX(), 0.0f, col4, (float) (tabRect.getX() + 7.0), 0.0f, col3);
        g2D.setPaint(gradientShadow);
        g2D.fill(tabRect);
      }
    } else {
      if (tabIndex == selectedIndex+1) {
        GradientPaint gradientShadow = new GradientPaint(0.0f, (float) tabRect.getY(), col4, 0.0f, (float) (tabRect.getY() + 7.0), col3);
        g2D.setPaint(gradientShadow);
        g2D.fill(tabRect);
      }
    }

    // paint reflection
    if (tabPlacement == JTabbedPane.TOP) {
      GradientPaint gradientReflectionTop = new GradientPaint(0.0f, (float) tabRect.getHeight()/2, col1, 0.0f, 0.0f, col2);
      g2D.setPaint(gradientReflectionTop);
      g2D.fill(tabRect);
    } else if (tabPlacement == JTabbedPane.BOTTOM) {
      if (tabIndex != selectedIndex) {
        GradientPaint gradientReflectionBottom = new GradientPaint(0.0f, (float) tabRect.getY(), col4, 0.0f, (float) (tabRect.getY() + 7.0), col3);
        g2D.setPaint(gradientReflectionBottom);
        g2D.fill(tabRect);
      }
    } else if (tabPlacement == JTabbedPane.RIGHT) {
      if (tabIndex != selectedIndex) {
        GradientPaint gradientReflectionBottom = new GradientPaint((float) tabRect.getX(), 0.0f, col4, (float) (tabRect.getX() + 7.0), 0.0f, col3);
        g2D.setPaint(gradientReflectionBottom);
        g2D.fill(tabRect);
      }
    }
  }


  protected void paintTabBackground(Graphics g, int tabPlacement,
                                      int tabIndex,
                                      int x, int y, int w, int h,
                                      boolean isSelected ) {
    if ( isSelected ) {
      g.setColor( selectColor );
    } else {
      g.setColor( tabPane.getBackgroundAt( tabIndex ) );
    }
    switch(tabPlacement) {
      case LEFT:  g.fillRect(x+1, y+1, w-2, h-3);
      break;
      case RIGHT: g.fillRect(x, y+1, w-2, h-3);
      break;
      case BOTTOM: g.fillRect(x+1, y, w-3, h-1);
      break;
      case TOP: default: g.fillRect(x+1, y+1, w-3, h-1);
    }
  }

}