/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.jeks;

import com.eteks.jeks.ResourceSyntax;
import com.eteks.parser.CompilationException;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JeksFunctionSyntax
extends ResourceSyntax {
    private Hashtable jeksFunctions = new Hashtable();
    private Hashtable messages = new Hashtable();
    private Hashtable jeksFunctionKeys = new Hashtable();
    private NumberFormat numberFormat;
    private DateFormat dateParser;
    private DateFormat timeParser;
    private char quoteCharacter;
    private Locale locale;
    public static final Integer JEKS_FUNCTION_SUM = new Integer(20001);
    public static final Integer JEKS_FUNCTION_RAND = new Integer(20002);
    public static final Integer JEKS_FUNCTION_MODULO = new Integer(20003);
    public static final Integer JEKS_FUNCTION_FACT = new Integer(20004);
    public static final Integer JEKS_FUNCTION_AND = new Integer(20005);
    public static final Integer JEKS_FUNCTION_OR = new Integer(20006);
    public static final Integer JEKS_FUNCTION_TRUE = new Integer(20007);
    public static final Integer JEKS_FUNCTION_FALSE = new Integer(20008);
    public static final Integer JEKS_FUNCTION_DATE = new Integer(20009);
    public static final Integer JEKS_FUNCTION_DATEVALUE = new Integer(20010);
    public static final Integer JEKS_FUNCTION_NOW = new Integer(20011);
    public static final Integer JEKS_FUNCTION_TIME = new Integer(20012);
    public static final Integer JEKS_FUNCTION_TIMEVALUE = new Integer(20013);
    public static final Integer JEKS_FUNCTION_YEAR = new Integer(20014);
    public static final Integer JEKS_FUNCTION_MONTH = new Integer(20015);
    public static final Integer JEKS_FUNCTION_DAY = new Integer(20016);
    public static final Integer JEKS_FUNCTION_WEEKDAY = new Integer(20017);
    public static final Integer JEKS_FUNCTION_HOUR = new Integer(20018);
    public static final Integer JEKS_FUNCTION_MINUTE = new Integer(20019);
    public static final Integer JEKS_FUNCTION_SECOND = new Integer(20020);
    public static final Integer JEKS_FUNCTION_CHAR = new Integer(20021);
    public static final Integer JEKS_FUNCTION_FIND = new Integer(20022);
    public static final Integer JEKS_FUNCTION_CODE = new Integer(20023);
    public static final Integer MESSAGE_COMPILATION_ERROR_TITLE = new Integer(30000);
    public static final Integer MESSAGE_OPENING_BRACKET_EXPECTED = new Integer(30001);
    public static final Integer MESSAGE_INVALID_FUNCTION_NAME = new Integer(30002);
    public static final Integer MESSAGE_RESERVED_WORD = new Integer(30003);
    public static final Integer MESSAGE_FUNCTION_NAME_ALREADY_EXISTS = new Integer(30004);
    public static final Integer MESSAGE_CLOSING_BRACKET_EXPECTED = new Integer(30005);
    public static final Integer MESSAGE_ASSIGN_OPERATOR_EXPECTED = new Integer(30006);
    public static final Integer MESSAGE_INVALID_PARAMETER_NAME = new Integer(30007);
    public static final Integer MESSAGE_DUPLICATED_PARAMETER_NAME = new Integer(30008);
    public static final Integer MESSAGE_SYNTAX_ERROR = new Integer(30009);
    public static final Integer MESSAGE_CLOSING_BRACKET_WITHOUT_OPENING_BRACKET = new Integer(30010);
    public static final Integer MESSAGE_UNKOWN_IDENTIFIER = new Integer(30011);
    public static final Integer MESSAGE_MISSING_PARAMETERS_IN_FUNCTION_CALL = new Integer(30012);
    public static final Integer MESSAGE_INVALID_PARAMETERS_COUNT_IN_FUNCTION_CALL = new Integer(30013);
    public static final Integer MESSAGE_THEN_OPERATOR_EXPECTED = new Integer(30014);
    public static final Integer MESSAGE_ELSE_OPERATOR_EXPECTED = new Integer(30015);
    public static final Integer MESSAGE_THEN_OPERATOR_WITHOUT_IF_OPERATOR = new Integer(30016);
    public static final Integer MESSAGE_ELSE_OPERATOR_WITHOUT_IF_THEN_OPERATORS = new Integer(30017);
    public static final Integer MESSAGE_INVALID_JEKS_FILE = new Integer(30100);

    public JeksFunctionSyntax() {
        this(Locale.getDefault());
    }

    public JeksFunctionSyntax(Locale locale) {
        super(ResourceBundle.getBundle("com.eteks.jeks.resources.syntax", locale));
        this.locale = locale;
        this.setResourceJeksFunction("JEKS_FUNCTION_SUM", JEKS_FUNCTION_SUM, new JeksFunctionSum());
        this.setResourceJeksFunction("JEKS_FUNCTION_RAND", JEKS_FUNCTION_RAND, new JeksFunctionRand());
        this.setResourceJeksFunction("JEKS_FUNCTION_MODULO", JEKS_FUNCTION_MODULO, new JeksFunctionMod());
        this.setResourceJeksFunction("JEKS_FUNCTION_FACT", JEKS_FUNCTION_FACT, new JeksFunctionFact());
        this.setResourceJeksFunction("JEKS_FUNCTION_AND", JEKS_FUNCTION_AND, new JeksFunctionAnd());
        this.setResourceJeksFunction("JEKS_FUNCTION_OR", JEKS_FUNCTION_OR, new JeksFunctionOr());
        this.setResourceJeksFunction("JEKS_FUNCTION_TRUE", JEKS_FUNCTION_TRUE, new JeksFunctionTrue());
        this.setResourceJeksFunction("JEKS_FUNCTION_FALSE", JEKS_FUNCTION_FALSE, new JeksFunctionFalse());
        this.setResourceJeksFunction("JEKS_FUNCTION_DATE", JEKS_FUNCTION_DATE, new JeksFunctionDate());
        this.setResourceJeksFunction("JEKS_FUNCTION_DATEVALUE", JEKS_FUNCTION_DATEVALUE, new JeksFunctionDateValue());
        this.setResourceJeksFunction("JEKS_FUNCTION_NOW", JEKS_FUNCTION_NOW, new JeksFunctionNow());
        this.setResourceJeksFunction("JEKS_FUNCTION_TIME", JEKS_FUNCTION_TIME, new JeksFunctionTime());
        this.setResourceJeksFunction("JEKS_FUNCTION_TIMEVALUE", JEKS_FUNCTION_TIMEVALUE, new JeksFunctionTimeValue());
        this.setResourceJeksFunction("JEKS_FUNCTION_YEAR", JEKS_FUNCTION_YEAR, new JeksFunctionYear());
        this.setResourceJeksFunction("JEKS_FUNCTION_MONTH", JEKS_FUNCTION_MONTH, new JeksFunctionMonth());
        this.setResourceJeksFunction("JEKS_FUNCTION_DAY", JEKS_FUNCTION_DAY, new JeksFunctionDay());
        this.setResourceJeksFunction("JEKS_FUNCTION_WEEKDAY", JEKS_FUNCTION_WEEKDAY, new JeksFunctionWeekDay());
        this.setResourceJeksFunction("JEKS_FUNCTION_HOUR", JEKS_FUNCTION_HOUR, new JeksFunctionHour());
        this.setResourceJeksFunction("JEKS_FUNCTION_MINUTE", JEKS_FUNCTION_MINUTE, new JeksFunctionMinute());
        this.setResourceJeksFunction("JEKS_FUNCTION_SECOND", JEKS_FUNCTION_SECOND, new JeksFunctionSecond());
        this.setResourceJeksFunction("JEKS_FUNCTION_CHAR", JEKS_FUNCTION_CHAR, new JeksFunctionChar());
        this.setResourceJeksFunction("JEKS_FUNCTION_FIND", JEKS_FUNCTION_FIND, new JeksFunctionFind());
        this.setResourceJeksFunction("JEKS_FUNCTION_CODE", JEKS_FUNCTION_CODE, new JeksFunctionCode());
        this.setResourceString(this.messages, "MESSAGE_COMPILATION_ERROR_TITLE", MESSAGE_COMPILATION_ERROR_TITLE);
        this.setResourceString(this.messages, "MESSAGE_OPENING_BRACKET_EXPECTED", MESSAGE_OPENING_BRACKET_EXPECTED);
        this.setResourceString(this.messages, "MESSAGE_INVALID_FUNCTION_NAME", MESSAGE_INVALID_FUNCTION_NAME);
        this.setResourceString(this.messages, "MESSAGE_RESERVED_WORD", MESSAGE_RESERVED_WORD);
        this.setResourceString(this.messages, "MESSAGE_FUNCTION_NAME_ALREADY_EXISTS", MESSAGE_FUNCTION_NAME_ALREADY_EXISTS);
        this.setResourceString(this.messages, "MESSAGE_CLOSING_BRACKET_EXPECTED", MESSAGE_CLOSING_BRACKET_EXPECTED);
        this.setResourceString(this.messages, "MESSAGE_ASSIGN_OPERATOR_EXPECTED", MESSAGE_ASSIGN_OPERATOR_EXPECTED);
        this.setResourceString(this.messages, "MESSAGE_INVALID_PARAMETER_NAME", MESSAGE_INVALID_PARAMETER_NAME);
        this.setResourceString(this.messages, "MESSAGE_DUPLICATED_PARAMETER_NAME", MESSAGE_DUPLICATED_PARAMETER_NAME);
        this.setResourceString(this.messages, "MESSAGE_SYNTAX_ERROR", MESSAGE_SYNTAX_ERROR);
        this.setResourceString(this.messages, "MESSAGE_CLOSING_BRACKET_WITHOUT_OPENING_BRACKET", MESSAGE_CLOSING_BRACKET_WITHOUT_OPENING_BRACKET);
        this.setResourceString(this.messages, "MESSAGE_UNKOWN_IDENTIFIER", MESSAGE_UNKOWN_IDENTIFIER);
        this.setResourceString(this.messages, "MESSAGE_MISSING_PARAMETERS_IN_FUNCTION_CALL", MESSAGE_MISSING_PARAMETERS_IN_FUNCTION_CALL);
        this.setResourceString(this.messages, "MESSAGE_INVALID_PARAMETERS_COUNT_IN_FUNCTION_CALL", MESSAGE_INVALID_PARAMETERS_COUNT_IN_FUNCTION_CALL);
        this.setResourceString(this.messages, "MESSAGE_THEN_OPERATOR_EXPECTED", MESSAGE_THEN_OPERATOR_EXPECTED);
        this.setResourceString(this.messages, "MESSAGE_ELSE_OPERATOR_EXPECTED", MESSAGE_ELSE_OPERATOR_EXPECTED);
        this.setResourceString(this.messages, "MESSAGE_THEN_OPERATOR_WITHOUT_IF_OPERATOR", MESSAGE_THEN_OPERATOR_WITHOUT_IF_OPERATOR);
        this.setResourceString(this.messages, "MESSAGE_ELSE_OPERATOR_WITHOUT_IF_THEN_OPERATORS", MESSAGE_ELSE_OPERATOR_WITHOUT_IF_THEN_OPERATORS);
        this.setResourceString(this.messages, "MESSAGE_INVALID_JEKS_FILE", MESSAGE_INVALID_JEKS_FILE);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.dateParser = DateFormat.getDateInstance(3);
        this.timeParser = DateFormat.getTimeInstance(3);
        this.quoteCharacter = ResourceSyntax.getResourceChar(this.getResourceBundle(), "QUOTE_CHAR");
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setResourceString(Hashtable hashtable, String string, Object object) {
        try {
            hashtable.put(object, this.getResourceBundle().getString(string));
        }
        catch (MissingResourceException missingResourceException) {}
    }

    public String getMessage(Object object) {
        return (String)this.messages.get(object);
    }

    public String getExceptionMessage(CompilationException compilationException) {
        switch (compilationException.getErrorNumber()) {
            case 0: {
                return this.getMessage(MESSAGE_OPENING_BRACKET_EXPECTED);
            }
            case 1: {
                return this.getMessage(MESSAGE_INVALID_FUNCTION_NAME);
            }
            case 2: {
                return this.getMessage(MESSAGE_RESERVED_WORD);
            }
            case 3: {
                return this.getMessage(MESSAGE_FUNCTION_NAME_ALREADY_EXISTS);
            }
            case 4: {
                return this.getMessage(MESSAGE_CLOSING_BRACKET_EXPECTED);
            }
            case 5: {
                return this.getMessage(MESSAGE_ASSIGN_OPERATOR_EXPECTED);
            }
            case 6: {
                return this.getMessage(MESSAGE_INVALID_PARAMETER_NAME);
            }
            case 7: {
                return this.getMessage(MESSAGE_DUPLICATED_PARAMETER_NAME);
            }
            case 8: {
                return this.getMessage(MESSAGE_SYNTAX_ERROR);
            }
            case 9: {
                return this.getMessage(MESSAGE_CLOSING_BRACKET_WITHOUT_OPENING_BRACKET);
            }
            case 10: {
                return this.getMessage(MESSAGE_UNKOWN_IDENTIFIER);
            }
            case 11: {
                return this.getMessage(MESSAGE_MISSING_PARAMETERS_IN_FUNCTION_CALL);
            }
            case 13: {
                return this.getMessage(MESSAGE_THEN_OPERATOR_EXPECTED);
            }
            case 14: {
                return this.getMessage(MESSAGE_ELSE_OPERATOR_EXPECTED);
            }
            case 15: {
                return this.getMessage(MESSAGE_THEN_OPERATOR_WITHOUT_IF_OPERATOR);
            }
            case 16: {
                return this.getMessage(MESSAGE_ELSE_OPERATOR_WITHOUT_IF_THEN_OPERATORS);
            }
        }
        return null;
    }

    protected void setResourceJeksFunction(String string, Object object, Function function) {
        try {
            String string2 = this.getResourceBundle().getString(string);
            this.setJeksFunctionKey(string2, object);
            this.addFunction(function);
        }
        catch (MissingResourceException missingResourceException) {}
    }

    private void setJeksFunctionKey(String string, Object object) {
        if (!this.isCaseSensitive()) {
            string = string.toUpperCase();
        }
        this.jeksFunctions.put(object, string);
        this.jeksFunctionKeys.put(string, object);
    }

    public Object getJeksFunctionKey(String string) {
        return this.jeksFunctionKeys.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public String getJeksFunction(Object object) {
        return (String)this.jeksFunctions.get(object);
    }

    public Object getLiteral(String string, StringBuffer stringBuffer) {
        Number number = this.getLiteralNumber(string, stringBuffer);
        if (number != null) {
            return number;
        }
        return this.getLiteralString(string, stringBuffer);
    }

    protected Number getLiteralNumber(String string, StringBuffer stringBuffer) {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null) {
            stringBuffer.append(string.substring(0, parsePosition.getIndex()));
        }
        return number;
    }

    protected String getLiteralString(String string, StringBuffer stringBuffer) {
        char c = string.charAt(0);
        if (this.getQuoteCharacter() == c && string.length() >= 2) {
            int n = 1;
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n < string.length()) {
                char c2 = string.charAt(n);
                if (c2 != c) {
                    stringBuffer2.append(c2);
                    ++n;
                    continue;
                }
                if (n + 1 >= string.length() || string.charAt(n + 1) != c) break;
                stringBuffer2.append(c2);
                n += 2;
            }
            if (n < string.length()) {
                stringBuffer.append(string.substring(0, n + 1));
                return stringBuffer2.toString();
            }
        }
        return null;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public boolean isValidIdentifier(String string) {
        if (!Character.isLetter(string.charAt(0)) && string.charAt(0) != '_') {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isLetter(string.charAt(n)) && !Character.isDigit(string.charAt(n)) && string.charAt(n) != '_') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private class JeksFunctionSum
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_SUM);
        }

        public boolean isValidParameterCount(int n) {
            return n > 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            double d = 0.0;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof Object[][]) {
                    Object[][] objectArray2 = (Object[][])objectArray[n];
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        int n3 = 0;
                        while (n3 < objectArray2[n2].length) {
                            Object object = objectArray2[n2][n3];
                            if (object != null && !"".equals(object) && object instanceof Number) {
                                d += ((Number)object).doubleValue();
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                } else {
                    d += objectArray[n] instanceof Number ? ((Number)objectArray[n]).doubleValue() : 0.0;
                }
                ++n;
            }
            if (d == Math.floor(d)) {
                return new Integer((int)d);
            }
            return new Double(d);
        }

        JeksFunctionSum() {
        }
    }

    private class JeksFunctionRand
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_RAND);
        }

        public boolean isValidParameterCount(int n) {
            return n == 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return new Double(Math.random());
        }

        JeksFunctionRand() {
        }
    }

    private class JeksFunctionMod
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_MODULO);
        }

        public boolean isValidParameterCount(int n) {
            return n == 2;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            double d;
            double d2 = objectArray[0] instanceof Number ? ((Number)objectArray[0]).doubleValue() : 0.0;
            double d3 = d = objectArray[1] instanceof Number ? ((Number)objectArray[1]).doubleValue() : 0.0;
            if (d == 0.0) {
                throw new IllegalArgumentException();
            }
            double d4 = d2 - d * (double)((int)(d2 / d));
            if (d2 < 0.0 && d > 0.0 || d2 > 0.0 && d < 0.0) {
                d4 += d;
            }
            return new Double(d4);
        }

        JeksFunctionMod() {
        }
    }

    private class JeksFunctionFact
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_FACT);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            double d;
            double d2 = d = objectArray[0] instanceof Number ? ((Number)objectArray[0]).doubleValue() : 0.0;
            if (d < 0.0) {
                return new Double(Double.NaN);
            }
            d = Math.floor(d);
            double d3 = 1.0;
            while (d > 0.0 && !Double.isInfinite(d3)) {
                double d4 = d;
                d = d4 - 1.0;
                d3 *= d4;
            }
            return new Double(d3);
        }

        JeksFunctionFact() {
        }
    }

    private class JeksFunctionAnd
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_AND);
        }

        public boolean isValidParameterCount(int n) {
            return n > 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            Boolean bl = Boolean.TRUE;
            int n = 0;
            while (bl.booleanValue() && n < objectArray.length) {
                if (!interpreter.isTrue(objectArray[n])) {
                    bl = Boolean.FALSE;
                }
                ++n;
            }
            return bl;
        }

        JeksFunctionAnd() {
        }
    }

    private class JeksFunctionOr
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_OR);
        }

        public boolean isValidParameterCount(int n) {
            return n > 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            Boolean bl = Boolean.FALSE;
            int n = 0;
            while (!bl.booleanValue() && n < objectArray.length) {
                if (interpreter.isTrue(objectArray[n])) {
                    bl = Boolean.TRUE;
                }
                ++n;
            }
            return bl;
        }

        JeksFunctionOr() {
        }
    }

    private class JeksFunctionTrue
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_TRUE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return Boolean.TRUE;
        }

        JeksFunctionTrue() {
        }
    }

    private class JeksFunctionFalse
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_FALSE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return Boolean.FALSE;
        }

        JeksFunctionFalse() {
        }
    }

    private class JeksFunctionDate
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_DATE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 3;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            int n = objectArray[0] instanceof Number ? ((Number)objectArray[0]).intValue() : 1900;
            int n2 = objectArray[1] instanceof Number ? ((Number)objectArray[1]).intValue() : 1;
            int n3 = objectArray[2] instanceof Number ? ((Number)objectArray[2]).intValue() : 1;
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, n2 - 1, n3, 0, 0, 0);
            return calendar.getTime();
        }

        JeksFunctionDate() {
        }
    }

    private class JeksFunctionDateValue
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_DATEVALUE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            try {
                if (objectArray[0] instanceof String) {
                    return JeksFunctionSyntax.this.dateParser.parse((String)objectArray[0]);
                }
            }
            catch (ParseException parseException) {}
            throw new IllegalArgumentException();
        }

        JeksFunctionDateValue() {
        }
    }

    private class JeksFunctionNow
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_NOW);
        }

        public boolean isValidParameterCount(int n) {
            return n == 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return new Date();
        }

        JeksFunctionNow() {
        }
    }

    private class JeksFunctionTime
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_TIME);
        }

        public boolean isValidParameterCount(int n) {
            return n == 3;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            int n = objectArray[0] instanceof Number ? ((Number)objectArray[0]).intValue() : 0;
            int n2 = objectArray[1] instanceof Number ? ((Number)objectArray[1]).intValue() : 0;
            int n3 = objectArray[2] instanceof Number ? ((Number)objectArray[2]).intValue() : 0;
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, n);
            calendar.set(12, n2);
            calendar.set(13, n3);
            return calendar.getTime();
        }

        JeksFunctionTime() {
        }
    }

    private class JeksFunctionTimeValue
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_TIMEVALUE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            try {
                if (objectArray[0] instanceof String) {
                    return JeksFunctionSyntax.this.timeParser.parse((String)objectArray[0]);
                }
            }
            catch (ParseException parseException) {}
            throw new IllegalArgumentException();
        }

        JeksFunctionTimeValue() {
        }
    }

    private class JeksFunctionYear
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_YEAR);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(1));
            }
            if (objectArray[0] == null) {
                return new Integer(1900);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionYear() {
        }
    }

    private class JeksFunctionMonth
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_MONTH);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(2) + 1);
            }
            if (objectArray[0] == null) {
                return new Integer(1);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionMonth() {
        }
    }

    private class JeksFunctionDay
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_DAY);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(5));
            }
            if (objectArray[0] == null) {
                return new Integer(0);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionDay() {
        }
    }

    private class JeksFunctionWeekDay
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_WEEKDAY);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(7));
            }
            if (objectArray[0] == null) {
                return new Integer(7);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionWeekDay() {
        }
    }

    private class JeksFunctionHour
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_HOUR);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(11));
            }
            if (objectArray[0] == null) {
                return new Integer(0);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionHour() {
        }
    }

    private class JeksFunctionMinute
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_MINUTE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(12));
            }
            if (objectArray[0] == null) {
                return new Integer(0);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionMinute() {
        }
    }

    private class JeksFunctionSecond
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_SECOND);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)objectArray[0]);
                return new Integer(calendar.get(13));
            }
            if (objectArray[0] == null) {
                return new Integer(0);
            }
            throw new IllegalArgumentException();
        }

        JeksFunctionSecond() {
        }
    }

    private class JeksFunctionChar
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_CHAR);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (!(objectArray[0] instanceof Number) || ((Number)objectArray[0]).doubleValue() < 0.0) {
                throw new IllegalArgumentException();
            }
            return new Character((char)((Number)objectArray[0]).intValue());
        }

        JeksFunctionChar() {
        }
    }

    private class JeksFunctionFind
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_FIND);
        }

        public boolean isValidParameterCount(int n) {
            return n >= 2 && n <= 3;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            int n;
            String string;
            String string2 = objectArray[0] != null ? objectArray[0].toString() : "";
            String string3 = string = objectArray[1] != null ? objectArray[1].toString() : "";
            int n2 = objectArray.length == 2 ? 1 : (n = objectArray[2] instanceof Number ? ((Number)objectArray[2]).intValue() : -1);
            if (string.length() == 0 || n < 0 || n > string.length()) {
                throw new IllegalArgumentException();
            }
            int n3 = string.indexOf(string2.toUpperCase(), n - 1);
            if (n3 == -1) {
                throw new IllegalArgumentException();
            }
            return new Integer(n3 + 1);
        }

        JeksFunctionFind() {
        }
    }

    private class JeksFunctionCode
    implements Function {
        public String getName() {
            return JeksFunctionSyntax.this.getJeksFunction(JEKS_FUNCTION_CODE);
        }

        public boolean isValidParameterCount(int n) {
            return n == 1;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] == null) {
                throw new IllegalArgumentException();
            }
            String string = objectArray[0].toString();
            return new Integer(string.charAt(0));
        }

        JeksFunctionCode() {
        }
    }
}

