/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLDocumentViewer
extends JFrame
implements HyperlinkListener,
ActionListener {
    JEditorPane viewer = new JEditorPane();
    JTextField urlTextField = new JTextField();

    public HTMLDocumentViewer() {
        this(false);
    }

    public HTMLDocumentViewer(boolean textField) {
        if (textField) {
            JPanel inputPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel("URL : ");
            inputPanel.add((Component)label, "West");
            inputPanel.add((Component)this.urlTextField, "Center");
            this.getContentPane().add((Component)inputPanel, "North");
        }
        JScrollPane scrollPane = new JScrollPane(this.viewer);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(this);
        this.urlTextField.addActionListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (this.urlTextField != null) {
                this.urlTextField.setText(event.getURL().toString());
            }
            if (event instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument doc = (HTMLDocument)this.viewer.getDocument();
                doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)event);
            } else {
                this.setPage(this.urlTextField.getText());
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.setPage(this.urlTextField.getText());
    }

    public void setPage(String urlString) {
        try {
            this.setPage(new URL(urlString));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Acces impossible a " + urlString);
        }
    }

    public void setPage(URL url) {
        try {
            this.viewer.setPage(url);
        }
        catch (Exception exception) {
            System.err.println("Acces impossible a " + url);
        }
    }
}

