/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIFrame;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUITextField;
import emsl.objects.FontPlus;
import emsl.objects.TextStyle;
import emsl.system.UndoGroup;
import emsl.text.AttributeList;
import emsl.text.EditPanel;
import emsl.text.TextData;
import emsl.text.TextPanel;
import emsl.text.TextSelector;
import emsl.tools.lineAndArrow.LineAndArrow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public class ChemicalEquations
extends GUIDialogueBox {
    private GUIFrame parent;
    private GUIButton applyButton;
    private GUIButton undoButton;
    private GUITextField superScriptField;
    private GUITextField subScriptField;
    private GUITextField replaceField;
    private GUIChoice fillChoice;
    private GUIChoice arrowChoice;

    public ChemicalEquations(GUIFrame gUIFrame) {
        super(gUIFrame, "Chemical Equations...", true);
        this.parent = gUIFrame;
        this.setModal(false);
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new GridLayout(2, 0, 10, 10));
        GUIPanel gUIPanel2 = new GUIPanel(new Dimension(200, 150), 3);
        gUIPanel2.setText("Font Sizes");
        gUIPanel.add(gUIPanel2);
        this.superScriptField = new GUITextField(2, 10);
        this.superScriptField.setText(120);
        GUILabelPanel gUILabelPanel = new GUILabelPanel((Component)this.superScriptField, "SuperScript Text %", 120);
        gUILabelPanel.setBehaviour(3);
        gUIPanel2.add(gUILabelPanel);
        this.subScriptField = new GUITextField(2, 10);
        this.subScriptField.setText(100);
        gUILabelPanel = new GUILabelPanel((Component)this.subScriptField, "SubScript Text %", 120);
        gUILabelPanel.setBehaviour(3);
        gUIPanel2.add(gUILabelPanel);
        GUIPanel gUIPanel3 = new GUIPanel(new Dimension(200, 150), 3);
        gUIPanel3.setText("Arrows");
        gUIPanel.add(gUIPanel3);
        this.replaceField = new GUITextField(0, 10);
        this.replaceField.setText("=");
        gUILabelPanel = new GUILabelPanel((Component)this.replaceField, "Replace", 120);
        gUILabelPanel.setBehaviour(3);
        gUIPanel3.add(gUILabelPanel);
        this.fillChoice = new GUIChoice(new Dimension(120, 30));
        this.fillChoice.setChoices(LineAndArrow.arrowTypeTags);
        this.fillChoice.select("Hollow Fill", true);
        gUILabelPanel = new GUILabelPanel((Component)this.fillChoice, "With Arrow Fill", 120);
        gUILabelPanel.setBehaviour(3);
        gUIPanel3.add(gUILabelPanel);
        this.arrowChoice = new GUIChoice(new Dimension(120, 30));
        this.arrowChoice.setChoices(LineAndArrow.lineTypeTags);
        this.arrowChoice.select("Right Arrow", true);
        gUILabelPanel = new GUILabelPanel((Component)this.arrowChoice, "With Line Type", 120);
        gUILabelPanel.setBehaviour(3);
        gUIPanel3.add(gUILabelPanel);
        this.undoButton = this.addExitButton("Undo", false);
        this.applyButton = this.addExitButton("Apply", false);
        this.setWindowCloseButton(this.addExitButton("Close", false));
    }

    public void applyStyle() {
        try {
            int n;
            TextPanel textPanel = (TextPanel)this.parent.getFocusTextPanel();
            TextSelector textSelector = textPanel.getTextSelector();
            if (!textSelector.isSelected()) {
                return;
            }
            int n2 = textSelector.getSelectionStart();
            if (n2 > (n = textSelector.getSelectionEnd())) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            textPanel.setMouseBusy();
            textSelector.selectionOff();
            UndoGroup undoGroup = textPanel.getTextUndo().getUndoGroup("Chemcial Styling");
            Object object = textPanel.getTextData().getStyleList().clone();
            boolean bl = this.applyStyle(textPanel.getTextData(), n2, n);
            if (bl) {
                Object object2 = textPanel.getTextData().getStyleList().clone();
                textPanel.getTextUndo().setUndoStyle(undoGroup, n2, n, (AttributeList)object, (AttributeList)object2);
            }
            this.applyArrows(undoGroup, textPanel, textPanel.getTextData(), n2, n);
            textPanel.getTextUndo().setUndoGroup(undoGroup);
            textSelector.setSelection(n2, n);
            textPanel.setMouseNormal();
            textPanel.layoutRange(n2, n + 1);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error in Chemcial Equation Styling");
            System.out.println(exception.toString());
            return;
        }
    }

    private boolean applyStyle(TextData textData, int n, int n2) {
        boolean bl = false;
        int n3 = n - 1;
        while (n3 <= n2) {
            char c = textData.getCharacter(n3);
            if (!textData.isBreak(n3 - 1)) {
                if (Character.isDigit(c)) {
                    bl = true;
                    this.subScriptCharacter(textData, n3);
                }
                if (c == '+' || c == '-') {
                    bl = true;
                    this.superScriptCharacter(textData, n3);
                }
            }
            ++n3;
        }
        return bl;
    }

    private void superScriptCharacter(TextData textData, int n) {
        TextStyle textStyle = (TextStyle)textData.getTextStyle(n).clone();
        FontPlus fontPlus = textStyle.getFontPlus();
        fontPlus.setSuperScript(true);
        fontPlus.setSize(fontPlus.getSize() * this.superScriptField.getInteger() / 100);
        textStyle.setFontPlus(fontPlus);
        textData.setTextStyle(textStyle, n, n);
    }

    private void subScriptCharacter(TextData textData, int n) {
        TextStyle textStyle = (TextStyle)textData.getTextStyle(n).clone();
        FontPlus fontPlus = textStyle.getFontPlus();
        fontPlus.setSubScript(true);
        fontPlus.setSize(fontPlus.getSize() * this.subScriptField.getInteger() / 100);
        textStyle.setFontPlus(fontPlus);
        textData.setTextStyle(textStyle, n, n);
    }

    private boolean applyArrows(UndoGroup undoGroup, TextPanel textPanel, TextData textData, int n, int n2) {
        String string = this.replaceField.getText();
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        char c = string.charAt(0);
        int n3 = n;
        while (n3 <= n2) {
            if (textData.getCharacter(n3) == c) {
                int n4 = textData.getTextStyle(n3).getFontSize();
                textPanel.delete(n3, 1, undoGroup);
                EditPanel editPanel = new EditPanel();
                int n5 = 600;
                int n6 = 140;
                int n7 = 1;
                n5 = n5 * n4 / 12;
                n6 = n6 * n4 / 12;
                n7 = n7 * n4 / 12;
                LineAndArrow lineAndArrow = new LineAndArrow();
                lineAndArrow.setLineTypeName(this.arrowChoice.getText());
                lineAndArrow.setArrowTypeName(this.fillChoice.getText());
                lineAndArrow.setLineThickness(n7);
                lineAndArrow.setForeground(textData.getTextStyle(n3).getForeground());
                editPanel.setInchBounds(new Rectangle(0, 0, n5, n6));
                editPanel.updateBounds();
                editPanel.setComponent(lineAndArrow);
                editPanel.setEditing(false);
                textPanel.insert(editPanel, n3, undoGroup);
            }
            ++n3;
        }
        return false;
    }

    protected boolean exitButtonPressed(GUIButton gUIButton) {
        if (gUIButton == null) {
            return false;
        }
        if (gUIButton == this.applyButton) {
            this.applyStyle();
            return false;
        }
        if (gUIButton == this.undoButton) {
            this.parent.actionPerformed(new ActionEvent(this, 0, "Undo"));
            return false;
        }
        return super.exitButtonPressed(gUIButton);
    }
}

