/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIButton;
import emsl.awt.GUIIconBox;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GUIRuler
extends GUIPanel
implements ActionListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INCHES = 0;
    public static final int CM = 1;
    private int direction;
    private int units;
    private int rulerWidth;
    private int rulerHeight;
    private Rectangle pageBounds;
    private int viewScale;
    private int scrollBarWidth;
    private int scrollBarHeight;
    private ScrollPane scrollPane;
    private GUIPopUpButton popUpMenu;
    private Image backImage;
    private Dimension backImageSize;
    private boolean drawEvenNumber;
    private boolean drawOddNumber;
    private boolean drawHalf;
    private boolean drawQuater;
    private boolean drawEigth;

    public GUIRuler(int n) {
        super(1);
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(0, 0));
        this.direction = n;
        this.setUnits(0);
        this.rulerWidth = 30;
        this.rulerHeight = 30;
        this.setSize(new Dimension(this.rulerWidth, this.rulerHeight));
        this.backImageSize = new Dimension(0, 0);
        GUIIconBox gUIIconBox = new GUIIconBox(0, 0, "unitsBox");
        gUIIconBox.add(new GUIButton(new Dimension(100, 30), "Inches"));
        gUIIconBox.add(new GUIButton(new Dimension(100, 30), "Centimetres"));
        if (n == 0) {
            this.popUpMenu = new GUIPopUpButton(new Dimension(15, -1), gUIIconBox);
            this.add("East", this.popUpMenu);
        } else {
            this.popUpMenu = new GUIPopUpButton(new Dimension(-1, 15), gUIIconBox);
            this.add("South", this.popUpMenu);
        }
        this.popUpMenu.addActionListener(this);
        if (n == 0) {
            this.popUpMenu.setTipText("Horizontal Ruler Units");
            return;
        }
        this.popUpMenu.setTipText("Vertical Ruler Units");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popUpMenu) {
            String string = this.popUpMenu.getText();
            this.popUpMenu.setText("");
            if (string.startsWith("Inch")) {
                this.setUnits(0);
            }
            if (string.startsWith("Cent")) {
                this.setUnits(1);
            }
            this.repaint();
        }
    }

    public void setUnits(int n) {
        this.units = 0;
        if (n == 1) {
            this.units = 1;
        }
        this.repaint();
    }

    public void setRulerView(ScrollPane scrollPane, Component component, int n) {
        this.scrollPane = scrollPane;
        this.viewScale = n;
        this.pageBounds = new Rectangle();
        this.pageBounds.x = component.getBounds().x - scrollPane.getScrollPosition().x;
        this.pageBounds.y = component.getBounds().y - scrollPane.getScrollPosition().y;
        if (this.direction == 0) {
            this.pageBounds.x += scrollPane.getLocation().x;
        }
        this.pageBounds.width = component.getBounds().width;
        this.pageBounds.height = component.getBounds().height;
        this.scrollBarHeight = scrollPane.getHScrollbarHeight();
        this.scrollBarWidth = scrollPane.getVScrollbarWidth();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.backImageSize.equals(this.getSize())) {
            this.backImage = null;
        }
        if (this.backImage == null) {
            this.backImageSize = this.getSize();
            this.backImage = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.backImage.getGraphics();
        super.paint(graphics2);
        if (this.pageBounds != null) {
            this.setMarkerVisibility();
            Rectangle rectangle = this.getRulerBounds();
            this.paintBackground(graphics2, rectangle);
            double d = this.getDPI();
            d = d * (double)this.viewScale / 100.0;
            if (this.units == 1) {
                d /= 2.54;
            }
            graphics2.setFont(new Font("SansSerif", 0, 10));
            graphics2.setColor(Color.black);
            if (this.direction == 0) {
                this.paintHorizontalRuler(graphics2, rectangle, d);
            } else {
                this.paintVerticalRuler(graphics2, rectangle, d);
            }
        }
        graphics.drawImage(this.backImage, 0, 0, this);
    }

    private void setMarkerVisibility() {
        if (this.units == 0) {
            this.drawEvenNumber = true;
            this.drawOddNumber = true;
            if (this.viewScale < 8) {
                this.drawOddNumber = false;
            }
            this.drawHalf = true;
            if (this.viewScale < 15) {
                this.drawHalf = false;
            }
            this.drawQuater = true;
            if (this.viewScale < 30) {
                this.drawQuater = false;
            }
            this.drawEigth = true;
            if (this.viewScale < 50) {
                this.drawEigth = false;
                return;
            }
        } else {
            this.drawEvenNumber = true;
            this.drawOddNumber = true;
            if (this.viewScale < 30) {
                this.drawOddNumber = false;
            }
            this.drawHalf = true;
            if (this.viewScale < 50) {
                this.drawHalf = false;
            }
            this.drawQuater = true;
            if (this.viewScale < 75) {
                this.drawQuater = false;
            }
            this.drawEigth = false;
        }
    }

    private Rectangle getRulerBounds() {
        Rectangle rectangle = new Rectangle(this.getSize());
        if (this.direction == 0) {
            this.rulerWidth = this.scrollPane.getLocation().x;
            rectangle.x += this.rulerWidth;
            rectangle.width = rectangle.width - this.rulerWidth - this.scrollBarWidth - 2;
            rectangle = rectangle.intersection(this.pageBounds);
            rectangle.y = 5;
            rectangle.height = this.getSize().height - rectangle.y * 2;
        } else {
            rectangle.height = rectangle.height - this.scrollBarHeight - 2;
            rectangle = rectangle.intersection(this.pageBounds);
            rectangle.x = 5;
            rectangle.width = this.getSize().width - rectangle.x * 2;
        }
        return rectangle;
    }

    private void paintBackground(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(new Color(240, 240, 240));
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.gray);
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    public void paintHorizontalRuler(Graphics graphics, Rectangle rectangle, double d) {
        double d2 = this.pageBounds.x;
        int n = rectangle.height / 2 + rectangle.y;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n + fontMetrics.getAscent() / 2;
        double d3 = d / 8.0;
        int n3 = 0;
        do {
            double d4;
            String string = String.valueOf(n3);
            int n4 = (int)d2 - fontMetrics.stringWidth(string) / 2;
            if (this.drawOddNumber && (n3 & 1) != 0) {
                graphics.drawString(string, n4, n2);
            }
            if (this.drawEvenNumber && n3 != 0 && (n3 & 1) == 0) {
                graphics.drawString(string, n4, n2);
            }
            if (this.drawHalf) {
                d4 = d2 + d3 * 4.0;
                graphics.drawLine((int)d4, n - 3, (int)d4, n + 3);
            }
            if (this.drawQuater) {
                d4 = d2 + d3 * 2.0;
                graphics.drawLine((int)d4, n - 1, (int)d4, n + 1);
                d4 = d2 + d3 * 6.0;
                graphics.drawLine((int)d4, n - 1, (int)d4, n + 1);
            }
            if (this.drawEigth) {
                d4 = d2 + d3;
                graphics.drawLine((int)d4, n - 1, (int)d4, n + 1);
                d4 = d2 + d3 * 3.0;
                graphics.drawLine((int)d4, n - 1, (int)d4, n + 1);
                d4 = d2 + d3 * 5.0;
                graphics.drawLine((int)d4, n - 1, (int)d4, n + 1);
                d4 = d2 + d3 * 7.0;
                graphics.drawLine((int)d4, n - 1, (int)d4, n + 1);
            }
            ++n3;
        } while ((int)(d2 += d) < this.pageBounds.x + this.pageBounds.width);
    }

    public void paintVerticalRuler(Graphics graphics, Rectangle rectangle, double d) {
        double d2 = this.pageBounds.y;
        int n = rectangle.width / 2 + rectangle.x;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        double d3 = d / 8.0;
        int n2 = 0;
        do {
            double d4;
            String string = String.valueOf(n2);
            int n3 = n - fontMetrics.stringWidth(string) / 2;
            int n4 = (int)d2 + fontMetrics.getAscent() / 2;
            if (this.drawOddNumber && (n2 & 1) != 0) {
                graphics.drawString(string, n3, n4);
            }
            if (this.drawEvenNumber && n2 != 0 && (n2 & 1) == 0) {
                graphics.drawString(string, n3, n4);
            }
            if (this.drawHalf) {
                d4 = d2 + d3 * 4.0;
                graphics.drawLine(n - 3, (int)d4, n + 3, (int)d4);
            }
            if (this.drawQuater) {
                d4 = d2 + d3 * 2.0;
                graphics.drawLine(n - 1, (int)d4, n + 1, (int)d4);
                d4 = d2 + d3 * 6.0;
                graphics.drawLine(n - 1, (int)d4, n + 1, (int)d4);
            }
            if (this.drawEigth) {
                d4 = d2 + d3;
                graphics.drawLine(n - 1, (int)d4, n + 1, (int)d4);
                d4 = d2 + d3 * 3.0;
                graphics.drawLine(n - 1, (int)d4, n + 1, (int)d4);
                d4 = d2 + d3 * 5.0;
                graphics.drawLine(n - 1, (int)d4, n + 1, (int)d4);
                d4 = d2 + d3 * 7.0;
                graphics.drawLine(n - 1, (int)d4, n + 1, (int)d4);
            }
            ++n2;
        } while ((int)(d2 += d) < this.pageBounds.y + this.pageBounds.height);
    }

    private void drawVMarker(Graphics graphics, double d, int n, int n2) {
        graphics.drawLine((int)d, n - n2, (int)d, n + n2);
    }

    private void drawHMarker(Graphics graphics, int n, double d, int n2) {
        graphics.drawLine(n - n2, (int)d, n + n2, (int)d);
    }
}

