/*
 * Decompiled with CFR 0.152.
 */
package emsl.editors;

import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public abstract class PropertySheet
extends Frame
implements ActionListener,
Runnable {
    public static final int LABEL_WIDTH = 120;
    private transient GUIPanel mainPanel;
    private transient ScrollPane scrollPane;
    private transient GUIPanel propertyPanel;
    private transient GUIButton exitButton;
    private transient GUIChoice borderChoice;
    private transient GUIPanel parent;
    private transient Thread motor;

    public PropertySheet(GUIPanel gUIPanel, String string) {
        super(string);
        this.parent = gUIPanel;
        new GUIPopUpManager(this);
        this.setSize(new Dimension(300, 500));
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(Color.lightGray);
        this.enableEvents(64L);
        this.mainPanel = new GUIPanel(1);
        this.add("Center", this.mainPanel);
        GUIPanel gUIPanel2 = new GUIPanel(1);
        this.add("South", gUIPanel2);
        this.exitButton = new GUIButton(new Dimension(100, 25), "Close");
        gUIPanel2.add(this.exitButton);
        this.exitButton.addActionListener(this);
        this.scrollPane = new ScrollPane(0);
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.add("Center", this.scrollPane);
        this.propertyPanel = new GUIPanel(new Dimension(280, 500));
        this.propertyPanel.setLayout(new FlowLayout(1, 2, 0));
        this.scrollPane.add(this.propertyPanel);
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        Frame frame = this.parent.getParentFrame();
        if (frame != null) {
            Rectangle rectangle = frame.getBounds();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = Math.min(rectangle.x + rectangle.width, dimension2.width - dimension.width);
            int n2 = Math.min(rectangle.y, dimension2.height - dimension.height);
            ((Component)this).setLocation(n, n2);
        }
    }

    public void resetPropertyPanel() {
        this.propertyPanel.removeAll();
        this.borderChoice = new GUIChoice(new Dimension(200, 30), "None, Outline, Raised, Lowered");
        this.addProperty(this.borderChoice, "Border");
        int n = this.parent.getBorder();
        if (n == 0) {
            this.borderChoice.select("None", true);
        }
        if (n == 3) {
            this.borderChoice.select("Outline", true);
        }
        if (n == 1) {
            this.borderChoice.select("Raised", true);
        }
        if (n == 2) {
            this.borderChoice.select("Lowered", true);
        }
        this.borderChoice.addActionListener(this);
    }

    public void addProperty(Component component, String string) {
        GUILabelPanel gUILabelPanel = new GUILabelPanel(component, string, 120);
        gUILabelPanel.setBehaviour(3);
        this.propertyPanel.add(gUILabelPanel);
    }

    public void addProperty(Component component) {
        this.propertyPanel.add(component);
    }

    public GUIPanel getDisplayPanel() {
        return this.mainPanel;
    }

    public void resizePanel() {
        int n = 10;
        this.propertyPanel.doLayout();
        this.scrollPane.doLayout();
        this.doLayout();
        try {
            int n2 = 0;
            while (n2 < this.propertyPanel.getComponentCount()) {
                Component component = this.propertyPanel.getComponent(n2);
                n += component.getSize().height;
                ++n2;
            }
        }
        catch (Exception exception) {}
        Dimension dimension = this.propertyPanel.getSize();
        dimension.height = n * 110 / 100;
        this.propertyPanel.setSize(dimension);
        this.propertyPanel.doLayout();
        this.scrollPane.doLayout();
        this.doLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exitButton) {
            this.setVisible(false);
        }
        if (actionEvent.getSource() == this.borderChoice) {
            String string = this.borderChoice.getText();
            if (string.equals("None")) {
                this.parent.setBorder(0);
            }
            if (string.equals("Outline")) {
                this.parent.setBorder(3);
            }
            if (string.equals("Raised")) {
                this.parent.setBorder(1);
            }
            if (string.equals("Lowered")) {
                this.parent.setBorder(2);
            }
            this.parent.repaint();
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
        }
    }

    public synchronized void run() {
        do {
            try {
                Container container;
                Thread.sleep(500L);
                if (!this.isVisible() || (container = this.parent.getParent()) != null) continue;
                this.setVisible(false);
            }
            catch (Exception exception) {}
        } while (this.isVisible());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.motor = new Thread(this);
            this.motor.start();
        }
    }
}

