/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.inch.ComponentPanel;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.Vector;

public class CharacterList
implements Serializable {
    public static final char COMPONENT = '\u0001';
    public static final char PAGE_BREAK = '\u0002';
    private StringBuffer characterList = new StringBuffer();
    private Vector componentList = new Vector();
    private transient String stringList = null;

    public CharacterList() {
        this.insert(" ", 0);
    }

    public StringBuffer getCharacterList() {
        return this.characterList;
    }

    public void setCharacterList(StringBuffer stringBuffer) {
        this.characterList = stringBuffer;
    }

    public Vector getComponentList() {
        return this.componentList;
    }

    public void setComponentList(Vector vector) {
        this.componentList = vector;
    }

    public int getSize() {
        return this.characterList.length();
    }

    public CharacterList getCharacterList(int n, int n2, boolean bl) {
        CharacterList characterList = new CharacterList();
        int n3 = n;
        while (n3 <= n2) {
            if (this.isComponent(n3)) {
                ComponentPanel componentPanel = this.getComponent(n3);
                if (bl) {
                    componentPanel = (ComponentPanel)componentPanel.clone();
                }
                characterList.insert(componentPanel, n3 - n + 1);
            } else {
                characterList.insert(this.getCharacter(n3), n3 - n + 1);
            }
            ++n3;
        }
        return characterList;
    }

    public void insert(CharacterList characterList, int n, boolean bl) {
        int n2 = 1;
        while (n2 < characterList.getSize()) {
            int n3 = n2 - 1 + n;
            if (characterList.isComponent(n2)) {
                ComponentPanel componentPanel = characterList.getComponent(n2);
                if (bl) {
                    componentPanel = (ComponentPanel)componentPanel.clone();
                }
                this.insert(componentPanel, n3);
            } else {
                this.insert(characterList.getCharacter(n2), n3);
            }
            ++n2;
        }
    }

    public void insert(char c, int n) {
        try {
            this.characterList.insert(n, c);
        }
        catch (Exception exception) {
            System.out.println("Error at insert(Char) in CharacterList for index = " + n);
            System.out.println(exception.toString());
        }
        this.stringList = null;
    }

    public void insert(String string, int n) {
        try {
            this.characterList.insert(n, string);
        }
        catch (Exception exception) {
            System.out.println("Error at insert(Text) in CharacterList for index = " + n);
            System.out.println(exception.toString());
        }
        this.stringList = null;
    }

    public void insert(ComponentPanel componentPanel, int n) {
        try {
            this.insert('\u0001', n);
            int n2 = this.getComponentIndex(n);
            this.componentList.insertElementAt(componentPanel, n2);
        }
        catch (Exception exception) {
            System.out.println("Error at insert(Component) in CharacterList for index = " + n);
            System.out.println(exception.toString());
        }
        this.stringList = null;
    }

    public void delete(int n, int n2) {
        Object object;
        if (n <= 1) {
            n = 1;
        }
        try {
            int n3 = n2;
            while (n3 >= n) {
                char c = this.characterList.charAt(n3);
                if (c == '\u0001') {
                    object = this.getComponent(n3);
                    this.componentList.removeElement(object);
                    ((Component)object).getParent().remove((Component)object);
                }
                --n3;
            }
        }
        catch (Exception exception) {
            System.out.println("Error at delete(Components) in CharacterList for index = " + n + " to " + n2);
            System.out.println(exception.toString());
        }
        try {
            String string = this.characterList.toString();
            String string2 = string.substring(0, n);
            object = string.substring(n2 + 1);
            this.characterList = new StringBuffer(String.valueOf(string2) + (String)object);
        }
        catch (Exception exception) {
            System.out.println("Error at delete(Text) in CharacterList for index = " + n + " to " + n2);
            System.out.println(exception.toString());
        }
        this.stringList = null;
    }

    public char getCharacter(int n) {
        try {
            return this.characterList.charAt(n);
        }
        catch (Exception exception) {
            System.out.println("Error at getCharacter in CharacterList for index = " + n);
            System.out.println(exception.toString());
            return '\u0000';
        }
    }

    public ComponentPanel getComponent(int n) {
        int n2 = this.getComponentIndex(n);
        if (n2 == -1) {
            return null;
        }
        try {
            return (ComponentPanel)this.componentList.elementAt(n2);
        }
        catch (Exception exception) {
            System.out.println("Error at getComponent in CharacterList for index = " + n);
            System.out.println(exception.toString());
            return null;
        }
    }

    public int getCharacterIndex(Component component) {
        int n = this.componentList.indexOf(component);
        if (n == -1) {
            return -1;
        }
        String string = this.getString();
        int n2 = -1;
        try {
            int n3 = 0;
            while (n3 <= n) {
                n2 = string.indexOf(1, n2 + 1);
                ++n3;
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    public boolean isComponent(int n) {
        char c = this.characterList.charAt(n);
        return c == '\u0001';
    }

    public boolean isSymbol(int n) {
        char c = this.characterList.charAt(n);
        return c > '\u00ff';
    }

    public boolean isNewPage(int n) {
        char c = this.characterList.charAt(n);
        return c == '\u0002';
    }

    public boolean isNewLine(int n) {
        char c = this.characterList.charAt(n);
        if (c == '\n' || c == '\r') {
            return true;
        }
        if (c == '\u0002') {
            return true;
        }
        return c == '\u0000';
    }

    public boolean isTab(int n) {
        char c = this.characterList.charAt(n);
        return c == '\t';
    }

    public boolean isBreak(int n) {
        char c = this.characterList.charAt(n);
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c == '\u0002') {
            return true;
        }
        if (c == '\u0000') {
            return true;
        }
        return c > '\u00ff';
    }

    private boolean isBreakOrComponent(int n) {
        char c = this.characterList.charAt(n);
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c == '\u0002') {
            return true;
        }
        if (c == '\u0000') {
            return true;
        }
        if (c == '\u0001') {
            return true;
        }
        return c > '\u00ff';
    }

    public String getWord(int n) {
        int n2;
        if (this.isComponent(n2 = n--)) {
            return new String(String.valueOf('\u0001'));
        }
        if (this.isTab(n2)) {
            return new String(" ");
        }
        if (this.isSymbol(n2)) {
            return this.getString(n2, n2);
        }
        boolean bl = false;
        try {
            do {
                if (this.isBreakOrComponent(++n)) {
                    bl = true;
                }
                if (n - n2 <= 15) continue;
                bl = true;
            } while (!bl);
        }
        catch (Exception exception) {}
        String string = this.getString(n2, n - 1);
        return string;
    }

    private int getComponentIndex(int n) {
        String string = this.getString();
        int n2 = -1;
        int n3 = -1;
        try {
            do {
                if ((n3 = string.indexOf(1, n3 + 1)) > n) {
                    n3 = -1;
                }
                if (n3 == -1) continue;
                ++n2;
            } while (n3 != -1);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    public void removeComponents(int n, int n2) {
        String string = this.getString();
        int n3 = 0;
        int n4 = -1;
        try {
            do {
                Container container;
                if ((n4 = string.indexOf(1, n4 + 1)) < 0) continue;
                Component component = (Component)this.componentList.elementAt(n3);
                if ((n4 < n || n4 > n2) && (container = component.getParent()) != null) {
                    container.remove(component);
                }
                ++n3;
            } while (n4 != -1);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getString(int n, int n2) {
        if (this.stringList == null) {
            this.stringList = this.characterList.toString();
        }
        return this.stringList.substring(n, n2 + 1);
    }

    public String getString() {
        return this.characterList.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Text :");
        stringBuffer.append(this.getString());
        stringBuffer.append("\nComponents :" + this.componentList.size());
        return stringBuffer.toString();
    }
}

