/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jabref.Globals;

public final class EntryEditorTabList {
    private List<List<String>> list = null;
    private List<String> names = null;

    public EntryEditorTabList() {
        this.init();
    }

    private void init() {
        this.list = new ArrayList<List<String>>();
        this.names = new ArrayList<String>();
        int n = 0;
        if (Globals.prefs.hasKey("customTabName_0")) {
            while (Globals.prefs.hasKey("customTabName_" + n)) {
                String string = Globals.prefs.get("customTabName_" + n);
                String[] stringArray = Globals.prefs.get("customTabFields_" + n).split(";");
                List<String> list = Arrays.asList(stringArray);
                this.names.add(string);
                this.list.add(list);
                ++n;
            }
        } else {
            while (Globals.prefs.get("customTabName__def" + n) != null) {
                String string = Globals.prefs.get("customTabName__def" + n);
                String[] stringArray = Globals.prefs.get("customTabFields__def" + n).split(";");
                List<String> list = Arrays.asList(stringArray);
                this.names.add(string);
                this.list.add(list);
                ++n;
            }
        }
    }

    public int getTabCount() {
        return this.list.size();
    }

    public String getTabName(int n) {
        return this.names.get(n);
    }

    public List<String> getTabFields(int n) {
        return this.list.get(n);
    }
}

