/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.sf.jabref.BasePanel;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.util.Util;

public class FieldContentSelector
extends JComponent {
    private final JComboBox comboBox;
    private final FieldEditor editor;
    private final MetaData metaData;
    private final JabRefFrame frame;
    private final Window owner;
    private final AbstractAction action;
    private final String delimiter;

    public FieldContentSelector(JabRefFrame jabRefFrame, final BasePanel basePanel, Window window, final FieldEditor fieldEditor, final MetaData metaData, AbstractAction abstractAction, boolean bl, String string) {
        this.frame = jabRefFrame;
        this.editor = fieldEditor;
        this.metaData = metaData;
        this.owner = window;
        this.action = abstractAction;
        this.delimiter = string;
        this.comboBox = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width > 240) {
                    dimension.width = 240;
                }
                return dimension;
            }
        };
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.comboBox.setMaximumRowCount(35);
        this.comboBox.putClientProperty("ComboBox.popupPrototypeDisplayValue", "The longest text in the combo popup menu. And even longer.");
        this.rebuildComboBox();
        gridBagConstraints.gridwidth = bl ? 3 : 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.comboBox, gridBagConstraints);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged") && actionEvent.getModifiers() == 0) {
                    return;
                }
                FieldContentSelector.this.selectionMade();
            }
        });
        this.comboBox.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.comboBox.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldContentSelector.this.selectionMade();
                FieldContentSelector.this.comboBox.setPopupVisible(false);
            }
        });
        this.add(this.comboBox);
        if (bl) {
            this.add(Box.createHorizontalStrut(Sizes.dialogUnitXAsPixel(2, this)));
        }
        JButton jButton = new JButton(Globals.lang("Manage"));
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2 contentSelectorDialog2 = new ContentSelectorDialog2(FieldContentSelector.this.owner, FieldContentSelector.this.frame, basePanel, true, metaData, fieldEditor.getFieldName());
                Util.placeDialog(contentSelectorDialog2, FieldContentSelector.this.frame);
                contentSelectorDialog2.setVisible(true);
                FieldContentSelector.this.rebuildComboBox();
            }
        });
    }

    private void selectionMade() {
        if (this.comboBox.getSelectedIndex() == 0) {
            return;
        }
        String string = (String)this.comboBox.getSelectedItem();
        if (string == null || string.equals("")) {
            return;
        }
        if (!this.editor.getText().equals("")) {
            this.editor.append(this.delimiter);
        }
        this.editor.append(string);
        this.comboBox.setSelectedIndex(0);
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this.editor, 0, ""));
        }
        this.editor.requestFocus();
    }

    void rebuildComboBox() {
        this.comboBox.removeAllItems();
        this.comboBox.addItem("");
        Vector<String> vector = this.metaData.getData("selector_" + this.editor.getFieldName());
        if (vector != null) {
            for (String string : vector) {
                this.comboBox.addItem(string);
            }
        }
    }
}

