/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;

public class FileHistory
extends JMenu
implements ActionListener {
    private final JabRefPreferences prefs;
    private final LinkedList<String> history = new LinkedList();
    private final JabRefFrame frame;

    public FileHistory(JabRefPreferences jabRefPreferences, JabRefFrame jabRefFrame) {
        String string = Globals.menuTitle("Recent files");
        int n = string.indexOf(38);
        if (n >= 0) {
            this.setText(string.substring(0, n) + string.substring(n + 1));
            char c = Character.toUpperCase(string.charAt(n + 1));
            this.setMnemonic((int)c);
        } else {
            this.setText(string);
        }
        this.prefs = jabRefPreferences;
        this.frame = jabRefFrame;
        String[] stringArray = jabRefPreferences.getStringArray("recentFiles");
        if (stringArray != null && stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                this.history.addFirst(stringArray[n]);
            }
            this.setItems();
        } else {
            this.setEnabled(false);
        }
    }

    public void newFile(String string) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!this.history.get(i).equals(string)) continue;
            this.history.remove(i);
            --i;
        }
        this.history.addFirst(string);
        while (this.history.size() > this.prefs.getInt("historySize")) {
            this.history.removeLast();
        }
        this.setItems();
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
    }

    private void setItems() {
        this.removeAll();
        Iterator iterator = this.history.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            this.addItem((String)iterator.next(), n);
            ++n;
        }
    }

    private void addItem(String string, int n) {
        String string2 = n + "";
        JMenuItem jMenuItem = new JMenuItem(string2 + ". " + string);
        char c = Character.toUpperCase(string2.charAt(0));
        jMenuItem.setMnemonic((int)c);
        jMenuItem.addActionListener(this);
        this.add(jMenuItem);
    }

    private void removeItem(String string) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!this.history.get(i).equals(string)) continue;
            this.history.remove(i);
            this.setItems();
            return;
        }
    }

    public void storeHistory() {
        if (!this.history.isEmpty()) {
            String[] stringArray = new String[this.history.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.history.get(i);
            }
            this.prefs.putStringArray("recentFiles", stringArray);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((JMenuItem)actionEvent.getSource()).getText();
        int n = string.indexOf(" ");
        final File file = new File(string = string.substring(n + 1));
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("File not found") + ": " + file.getName(), "Error", 0);
            this.removeItem(string);
            return;
        }
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                ((FileHistory)FileHistory.this).frame.open.openIt(file, true);
            }
        });
    }
}

