/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class GeneralRenderer
extends DefaultTableCellRenderer {
    private Color background;
    private Color selBackground = null;

    public GeneralRenderer(Color color) {
        this.background = color;
        this.setBackground(color);
    }

    public GeneralRenderer(Color color, Color color2) {
        this(color);
        this.background = color;
        this.setForeground(color2);
    }

    public GeneralRenderer(Color color, Color color2, Color color3) {
        this(color);
        this.background = color;
        this.setForeground(color2);
        this.selBackground = color3;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.selBackground == null) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (bl) {
            component.setBackground(this.selBackground);
        } else {
            component.setBackground(this.background);
        }
        return component;
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    protected void setValue(Object object) {
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
            this.setText(null);
        } else if (object instanceof JLabel) {
            JLabel jLabel = (JLabel)object;
            this.setIcon(jLabel.getIcon());
            this.setToolTipText(jLabel.getToolTipText());
            if (jLabel.getIcon() != null) {
                this.setText(null);
            }
        } else {
            this.setIcon(null);
            this.setToolTipText(null);
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText(null);
            }
        }
    }
}

