/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import net.sf.jabref.Globals;
import net.sf.jabref.export.ExportFormats;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JabRefCLI {
    private String[] leftOver;
    private final CommandLine cl;

    public boolean isHelp() {
        return this.cl.hasOption("help");
    }

    public boolean isShowVersion() {
        return this.cl.hasOption("version");
    }

    public boolean isBlank() {
        return this.cl.hasOption("blank");
    }

    public boolean isLoadSession() {
        return this.cl.hasOption("loads");
    }

    public boolean isDisableGui() {
        return this.cl.hasOption("nogui");
    }

    public JabRefCLI(String[] stringArray) {
        Options options = this.getOptions();
        try {
            this.cl = new DefaultParser().parse(options, stringArray);
            this.leftOver = this.cl.getArgs();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            this.printUsage();
            throw new RuntimeException();
        }
    }

    public boolean isPreferencesExport() {
        return this.cl.hasOption("prexp");
    }

    public String getPreferencesExport() {
        return this.cl.getOptionValue("prexp", "jabref_prefs.xml");
    }

    public boolean isPreferencesImport() {
        return this.cl.hasOption("primp");
    }

    public String getPreferencesImport() {
        return this.cl.getOptionValue("primp", "jabref_prefs.xml");
    }

    public boolean isPreferencesReset() {
        return this.cl.hasOption("prdef");
    }

    public String getPreferencesReset() {
        return this.cl.getOptionValue("prdef");
    }

    public boolean isFileExport() {
        return this.cl.hasOption("output");
    }

    public String getFileExport() {
        return this.cl.getOptionValue("output");
    }

    public boolean isFileImport() {
        return this.cl.hasOption("import");
    }

    public String getFileImport() {
        return this.cl.getOptionValue("import");
    }

    public boolean isAuxImport() {
        return this.cl.hasOption("aux");
    }

    public String getAuxImport() {
        return this.cl.getOptionValue("aux");
    }

    public boolean isImportToOpenBase() {
        return this.cl.hasOption("importToOpen");
    }

    public String getImportToOpenBase() {
        return this.cl.getOptionValue("importToOpen");
    }

    public boolean isFetcherEngine() {
        return this.cl.hasOption("fetch");
    }

    public String getFetcherEngine() {
        return this.cl.getOptionValue("fetch");
    }

    public boolean isExportMatches() {
        return this.cl.hasOption("exportMatches");
    }

    public String getExportMatches() {
        return this.cl.getOptionValue("exportMatches");
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("v", "version", false, Globals.lang("Display version"));
        options.addOption("n", "nogui", false, Globals.lang("No GUI. Only process command line options."));
        options.addOption("h", "help", false, Globals.lang("Display help on command line options"));
        options.addOption("l", "loads", false, Globals.lang("Load session"));
        options.addOption("b", "blank", false, Globals.lang("Do not open any files at startup"));
        options.addOption(Option.builder("i").longOpt("import").desc(String.format("%s: %s[,import format]", Globals.lang("Import file"), Globals.lang("filename"))).hasArg().argName("FILE").build());
        options.addOption(Option.builder("o").longOpt("output").desc(String.format("%s: %s[,export format]", Globals.lang("Output or export file"), Globals.lang("filename"))).hasArg().argName("FILE").build());
        options.addOption(Option.builder("x").longOpt("prexp").desc(Globals.lang("Export preferences to file")).hasArg().argName("FILE").build());
        options.addOption(Option.builder("p").longOpt("primp").desc(Globals.lang("Import preferences from file")).hasArg().argName("FILE").build());
        options.addOption(Option.builder("d").longOpt("prdef").desc(Globals.lang("Reset preferences (key1,key2,... or 'all')")).hasArg().argName("FILE").build());
        options.addOption(Option.builder("a").longOpt("aux").desc(String.format("%s: %s[.aux],%s[.bib]", Globals.lang("Subdatabase from aux"), Globals.lang("file"), Globals.lang("new"))).hasArg().argName("FILE").build());
        options.addOption(Option.builder().longOpt("importToOpen").desc(Globals.lang("Import to open tab")).hasArg().argName("FILE").build());
        options.addOption(Option.builder("f").longOpt("fetch").desc(Globals.lang("Run Fetcher, e.g. \"--fetch=Medline:cancer\"")).hasArg().argName("FILE").build());
        options.addOption(Option.builder("m").longOpt("exportMatches").desc(JabRefCLI.getExportMatchesSyntax()).hasArg().argName("FILE").build());
        return options;
    }

    public void displayVersion() {
        System.out.println(this.getVersionInfo());
    }

    public void printUsage() {
        String string = "";
        String string2 = Globals.importFormatReader.getImportFormatList();
        String string3 = String.format("%s:%n%s%n", Globals.lang("Available import formats"), string2);
        String string4 = ExportFormats.getConsoleExportList(70, 20, "");
        String string5 = String.format("%s: %s%n", Globals.lang("Available export formats"), string4);
        String string6 = '\n' + string3 + string5 + "\nPlease report issues at http://sourceforge.net/p/jabref/bugs/";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("jabref [OPTIONS] [BIBTEX_FILE]\n\nOptions:", string, this.getOptions(), string6, true);
    }

    private String getVersionInfo() {
        return String.format("JabRef %s", Globals.BUILD_INFO.getVersion());
    }

    public String[] getLeftOver() {
        return this.leftOver;
    }

    public static String getExportMatchesSyntax() {
        return String.format("[%s]searchTerm,outputFile: %s[,%s]", Globals.lang("field"), Globals.lang("file"), Globals.lang("exportFormat"));
    }
}

