/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Collection;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.SearchRules;

class SearchManagerNoGUI {
    private String searchTerm;
    private final BibtexDatabase database;
    private BibtexDatabase base = null;

    public SearchManagerNoGUI(String string, BibtexDatabase bibtexDatabase) {
        this.searchTerm = string;
        this.database = bibtexDatabase;
    }

    public BibtexDatabase getDBfromMatches() {
        SearchRule searchRule;
        int n = 0;
        System.out.println("search term: " + this.searchTerm);
        if (this.specifiedYears()) {
            this.searchTerm = this.fieldYear();
        }
        if (!(searchRule = SearchRules.getSearchRuleByQuery(this.searchTerm, Globals.prefs.getBoolean("caseSensitiveSearch"), Globals.prefs.getBoolean("regExpSearch"))).validateSearchStrings(this.searchTerm)) {
            System.out.println(Globals.lang("Search failed: illegal search expression"));
            return this.base;
        }
        Collection<BibtexEntry> collection = this.database.getEntries();
        Vector<BibtexEntry> vector = new Vector<BibtexEntry>();
        for (BibtexEntry bibtexEntry : collection) {
            boolean bl = searchRule.applyRule(this.searchTerm, bibtexEntry);
            bibtexEntry.setSearchHit(bl);
            if (!bl) continue;
            ++n;
            vector.add(bibtexEntry);
        }
        this.base = ImportFormatReader.createDatabase(vector);
        return this.base;
    }

    private boolean specifiedYears() {
        return this.searchTerm.matches("year=[0-9]{4}-[0-9]{4}");
    }

    private String fieldYear() {
        String string = "";
        String string2 = "";
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray = this.searchTerm.split("=");
        String string4 = stringArray[0];
        String[] stringArray2 = stringArray[1].split("-");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        if (n < 2000 && n2 >= 2000) {
            string = "199+[" + stringArray2[0].substring(3, 4) + "-9]";
            bl = true;
        } else if (n < 2000) {
            string = "199+[" + stringArray2[0].substring(3, 4) + "-" + Math.min(Integer.parseInt(stringArray2[1].substring(3, 4)), 9) + "]";
            bl = true;
        }
        if (Integer.parseInt(stringArray2[1]) >= 2000 && n < 2000) {
            string2 = "200+[0-" + stringArray2[1].substring(3, 4) + "]";
            bl2 = true;
        } else if (n2 >= 2000) {
            string2 = "200+[" + stringArray2[0].substring(3, 4) + "-" + Math.min(Integer.parseInt(stringArray2[1].substring(3, 4)), 9) + "]";
            bl2 = true;
        }
        if (bl && bl2) {
            string3 = string4 + "=" + string + "|" + string2;
        } else {
            if (bl) {
                string3 = string4 + "=" + string;
            }
            if (bl2) {
                string3 = string4 + "=" + string2;
            }
        }
        return string3;
    }
}

