/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.BibtexStringComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableRemoveString;
import net.sf.jabref.undo.UndoableStringChange;

class StringDialog
extends JDialog {
    private final BibtexDatabase base;
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final JabRefPreferences prefs;
    private Object[] strings;
    JLabel lab;
    private final StringTable table;
    private final HelpAction helpAction;
    private final CloseAction closeAction = new CloseAction(this);
    StoreContentAction storeContentAction = new StoreContentAction(this);

    public StringDialog(JabRefFrame jabRefFrame, BasePanel basePanel, BibtexDatabase bibtexDatabase, JabRefPreferences jabRefPreferences) {
        super(jabRefFrame);
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.base = bibtexDatabase;
        this.prefs = jabRefPreferences;
        this.sortStrings();
        this.helpAction = new HelpAction(jabRefFrame.helpDiag, "StringEditorHelp.html", "Help");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StringDialog.this.closeAction.actionPerformed(null);
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                return super.accept(component) && component instanceof StringTable;
            }
        });
        this.setLocation(jabRefPreferences.getInt("stringsPosX"), jabRefPreferences.getInt("stringsPosY"));
        this.setSize(jabRefPreferences.getInt("stringsSizeX"), jabRefPreferences.getInt("stringsSizeY"));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        StringTableModel stringTableModel = new StringTableModel(this, bibtexDatabase);
        this.table = new StringTable(stringTableModel);
        if (bibtexDatabase.getStringCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        gridBagLayout.setConstraints(this.table.getPane(), gridBagConstraints);
        jPanel.add(this.table.getPane());
        JToolBar jToolBar = new JToolBar();
        InputMap inputMap = jToolBar.getInputMap(2);
        ActionMap actionMap = jToolBar.getActionMap();
        inputMap.put(jabRefPreferences.getKey("String dialog, add string"), "add");
        NewStringAction newStringAction = new NewStringAction(this);
        actionMap.put("add", newStringAction);
        inputMap.put(jabRefPreferences.getKey("String dialog, remove string"), "remove");
        RemoveStringAction removeStringAction = new RemoveStringAction(this);
        actionMap.put("remove", removeStringAction);
        inputMap.put(jabRefPreferences.getKey("Close dialog"), "close");
        actionMap.put("close", this.closeAction);
        inputMap.put(jabRefPreferences.getKey("Help"), "help");
        actionMap.put("help", this.helpAction);
        inputMap.put(jabRefPreferences.getKey("Undo"), "undo");
        UndoAction undoAction = new UndoAction();
        actionMap.put("undo", undoAction);
        inputMap.put(jabRefPreferences.getKey("Redo"), "redo");
        RedoAction redoAction = new RedoAction();
        actionMap.put("redo", redoAction);
        jToolBar.add(newStringAction);
        jToolBar.add(removeStringAction);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(this.helpAction);
        Container container = this.getContentPane();
        container.add((Component)jToolBar, "North");
        container.add((Component)jPanel, "Center");
        if (basePanel.getFile() != null) {
            this.setTitle(Globals.lang("Strings for database") + ": " + basePanel.getFile().getName());
        } else {
            this.setTitle(Globals.lang("Strings for database") + ": " + Globals.lang("untitled"));
        }
    }

    private void sortStrings() {
        TreeSet<BibtexString> treeSet = new TreeSet<BibtexString>(new BibtexStringComparator(false));
        for (String string : this.base.getStringKeySet()) {
            treeSet.add(this.base.getString(string));
        }
        this.strings = treeSet.toArray();
    }

    public void refreshTable() {
        this.sortStrings();
        this.table.revalidate();
        this.table.clearSelection();
        this.table.repaint();
    }

    private boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    void assureNotEditing() {
        if (this.table.isEditing()) {
            int n = this.table.getEditingColumn();
            int n2 = this.table.getEditingRow();
            this.table.getCellEditor(n2, n).stopCellEditing();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", Globals.lang("Redo"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                StringDialog.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", Globals.lang("Undo"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                StringDialog.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RemoveStringAction
    extends AbstractAction {
        final StringDialog parent;

        public RemoveStringAction(StringDialog stringDialog2) {
            super("Remove selected strings", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Remove selected strings"));
            this.parent = stringDialog2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = StringDialog.this.table.getSelectedRows();
            if (nArray.length > 0) {
                StringDialog.this.assureNotEditing();
                String string = Globals.lang("Really delete the selected") + ' ' + (nArray.length > 1 ? nArray.length + " " + Globals.lang("entries") : Globals.lang("entry")) + '?';
                int n = JOptionPane.showConfirmDialog(this.parent, string, Globals.lang("Delete strings"), 0, 3);
                if (n == 0) {
                    CompoundEdit compoundEdit = new CompoundEdit();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        BibtexString bibtexString = (BibtexString)StringDialog.this.strings[nArray[i]];
                        compoundEdit.addEdit(new UndoableRemoveString(StringDialog.this.panel, StringDialog.this.base, bibtexString));
                        StringDialog.this.base.removeString(bibtexString.getId());
                    }
                    compoundEdit.end();
                    ((StringDialog)StringDialog.this).panel.undoManager.addEdit(compoundEdit);
                    StringDialog.this.refreshTable();
                    if (StringDialog.this.base.getStringCount() > 0) {
                        StringDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                }
            }
        }
    }

    static class StoreContentAction
    extends AbstractAction {
        final StringDialog parent;

        public StoreContentAction(StringDialog stringDialog) {
            super("Store string", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Store string"));
            this.parent = stringDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class NewStringAction
    extends AbstractAction {
        final StringDialog parent;

        public NewStringAction(StringDialog stringDialog2) {
            super("New string", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("New string"));
            this.parent = stringDialog2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(this.parent, (Object)Globals.lang("Please enter the string's label"));
            if (string == null) {
                return;
            }
            if (StringDialog.this.isNumber(string)) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                return;
            }
            if (string.contains("#")) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain the '#' character."), Globals.lang("Label"), 0);
                return;
            }
            if (string.contains(" ")) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain spaces."), Globals.lang("Label"), 0);
                return;
            }
            try {
                String string2 = IdGenerator.next();
                BibtexString bibtexString = new BibtexString(string2, string, "");
                ((StringDialog)StringDialog.this).panel.undoManager.addEdit(new UndoableInsertString(StringDialog.this.panel, ((StringDialog)StringDialog.this).panel.database, bibtexString));
                StringDialog.this.base.addString(bibtexString);
                StringDialog.this.refreshTable();
                StringDialog.this.panel.markBaseChanged();
            }
            catch (KeyCollisionException keyCollisionException) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        final StringDialog parent;

        public CloseAction(StringDialog stringDialog2) {
            super("Close window");
            this.putValue("ShortDescription", Globals.lang("Close dialog"));
            this.parent = stringDialog2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StringDialog.this.panel.stringsClosing();
            StringDialog.this.dispose();
            Point point = StringDialog.this.getLocation();
            Dimension dimension = StringDialog.this.getSize();
            StringDialog.this.prefs.putInt("stringsPosX", point.x);
            StringDialog.this.prefs.putInt("stringsPosY", point.y);
            StringDialog.this.prefs.putInt("stringsSizeX", dimension.width);
            StringDialog.this.prefs.putInt("stringsSizeY", dimension.height);
        }
    }

    class StringTableModel
    extends AbstractTableModel {
        final BibtexDatabase base;
        final StringDialog parent;

        public StringTableModel(StringDialog stringDialog2, BibtexDatabase bibtexDatabase) {
            this.parent = stringDialog2;
            this.base = bibtexDatabase;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? ((BibtexString)StringDialog.this.strings[n]).getName() : ((BibtexString)StringDialog.this.strings[n]).getContent();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (!object.equals(((BibtexString)StringDialog.this.strings[n]).getName())) {
                    if (this.base.hasStringLabel((String)object)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
                    } else if (((String)object).contains(" ")) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain spaces."), Globals.lang("Label"), 0);
                    } else if (((String)object).contains("#")) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain the '#' character."), Globals.lang("Label"), 0);
                    } else if (StringDialog.this.isNumber((String)object)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                    } else {
                        BibtexString bibtexString = (BibtexString)StringDialog.this.strings[n];
                        ((StringDialog)StringDialog.this).panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, bibtexString, true, bibtexString.getName(), (String)object));
                        bibtexString.setName((String)object);
                        StringDialog.this.panel.markBaseChanged();
                        StringDialog.this.refreshTable();
                    }
                }
            } else {
                BibtexString bibtexString = (BibtexString)StringDialog.this.strings[n];
                if (!object.equals(bibtexString.getContent())) {
                    try {
                        new LatexFieldFormatter().format((String)object, "__dummy");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return;
                    }
                    ((StringDialog)StringDialog.this).panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, bibtexString, false, bibtexString.getContent(), (String)object));
                    bibtexString.setContent((String)object);
                    StringDialog.this.panel.markBaseChanged();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StringDialog.this.strings.length;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? Globals.lang("Name") : Globals.lang("Content");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    class StringTable
    extends JTable {
        final JScrollPane sp;

        public StringTable(StringTableModel stringTableModel) {
            super(stringTableModel);
            this.sp = new JScrollPane(this);
            this.setShowVerticalLines(true);
            this.setShowHorizontalLines(true);
            this.setColumnSelectionAllowed(true);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
            defaultCellEditor.setClickCountToStart(2);
            this.setDefaultEditor(String.class, defaultCellEditor);
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(800);
            tableColumnModel.getColumn(1).setPreferredWidth(2000);
            this.sp.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
            this.getInputMap().put(((StringDialog)StringDialog.this).frame.prefs.getKey("Close dialog"), "close");
            this.getActionMap().put("close", StringDialog.this.closeAction);
            this.getInputMap().put(((StringDialog)StringDialog.this).frame.prefs.getKey("Help"), "help");
            this.getActionMap().put("help", StringDialog.this.helpAction);
        }

        public JComponent getPane() {
            return this.sp;
        }
    }
}

