/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.util.Stack;
import net.sf.jabref.bst.BibtexCaseChanger;
import net.sf.jabref.bst.VM;
import net.sf.jabref.bst.VMException;

public class ChangeCaseFunction
implements VM.BstFunction {
    private final VM vm;

    public ChangeCaseFunction(VM vM) {
        this.vm = vM;
    }

    @Override
    public void execute(VM.BstEntry bstEntry) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation change.case$");
        }
        Object object = stack.pop();
        Object object2 = stack.pop();
        if (!(object instanceof String) || ((String)object).length() != 1) {
            throw new VMException("A format string of length 1 is needed for change.case$");
        }
        if (!(object2 instanceof String)) {
            throw new VMException("A string is needed as second parameter for change.case$");
        }
        char c = ((String)object).toLowerCase().charAt(0);
        String string = (String)object2;
        stack.push(BibtexCaseChanger.changeCase(string, c, this.vm));
    }
}

