/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.EntryComparator;
import net.sf.jabref.EntrySorter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.ChangeDisplayDialog;
import net.sf.jabref.collab.EntryAddChange;
import net.sf.jabref.collab.EntryChange;
import net.sf.jabref.collab.EntryDeleteChange;
import net.sf.jabref.collab.GroupChange;
import net.sf.jabref.collab.MetaDataChange;
import net.sf.jabref.collab.PreambleChange;
import net.sf.jabref.collab.StringAddChange;
import net.sf.jabref.collab.StringChange;
import net.sf.jabref.collab.StringNameChange;
import net.sf.jabref.collab.StringRemoveChange;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.util.Util;

public class ChangeScanner
implements Runnable {
    private final String[] sortBy = new String[]{"year", "author", "title"};
    private final File f;
    private final BibtexDatabase inMem;
    private final MetaData mdInMem;
    private final BasePanel panel;
    private final JabRefFrame frame;
    private BibtexDatabase inTemp = null;
    private MetaData mdInTemp;
    private final DefaultMutableTreeNode changes = new DefaultMutableTreeNode(Globals.lang("External changes"));

    public ChangeScanner(JabRefFrame jabRefFrame, BasePanel basePanel, File file) {
        this.panel = basePanel;
        this.frame = jabRefFrame;
        this.inMem = basePanel.database();
        this.mdInMem = basePanel.metaData();
        this.f = file;
    }

    @Override
    public void run() {
        try {
            File file = Globals.fileUpdateMonitor.getTempFile(this.panel.fileMonitorHandle());
            ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, Globals.prefs.get("defaultEncoding"));
            this.inTemp = parserResult.getDatabase();
            this.mdInTemp = parserResult.getMetaData();
            parserResult = OpenDatabaseAction.loadDatabase(this.f, Globals.prefs.get("defaultEncoding"));
            BibtexDatabase bibtexDatabase = parserResult.getDatabase();
            MetaData metaData = parserResult.getMetaData();
            EntryComparator entryComparator = new EntryComparator(false, true, this.sortBy[2]);
            entryComparator = new EntryComparator(false, true, this.sortBy[1], entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[0], entryComparator);
            EntrySorter entrySorter = this.inTemp.getSorter(entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[2]);
            entryComparator = new EntryComparator(false, true, this.sortBy[1], entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[0], entryComparator);
            EntrySorter entrySorter2 = bibtexDatabase.getSorter(entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[2]);
            entryComparator = new EntryComparator(false, true, this.sortBy[1], entryComparator);
            entryComparator = new EntryComparator(false, true, this.sortBy[0], entryComparator);
            EntrySorter entrySorter3 = this.inMem.getSorter(entryComparator);
            this.scanMetaData(this.mdInMem, this.mdInTemp, metaData);
            this.scanPreamble(this.inMem, this.inTemp, bibtexDatabase);
            this.scanStrings(this.inMem, this.inTemp, bibtexDatabase);
            this.scanEntries(entrySorter3, entrySorter, entrySorter2);
            this.scanGroups(this.mdInMem, this.mdInTemp, metaData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean changesFound() {
        return this.changes.getChildCount() > 0;
    }

    public void displayResult(final DisplayResultCallback displayResultCallback) {
        if (this.changes.getChildCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangeDisplayDialog changeDisplayDialog = new ChangeDisplayDialog(ChangeScanner.this.frame, ChangeScanner.this.panel, ChangeScanner.this.inTemp, ChangeScanner.this.changes);
                    Util.placeDialog(changeDisplayDialog, ChangeScanner.this.frame);
                    changeDisplayDialog.setVisible(true);
                    displayResultCallback.scanResultsResolved(changeDisplayDialog.isOkPressed());
                    if (changeDisplayDialog.isOkPressed()) {
                        ChangeScanner.this.storeTempDatabase();
                    }
                }
            });
        } else {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("No actual changes found."), Globals.lang("External changes"), 1);
            displayResultCallback.scanResultsResolved(true);
        }
    }

    private void storeTempDatabase() {
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SaveSession saveSession = FileActions.saveDatabase(ChangeScanner.this.inTemp, ChangeScanner.this.mdInTemp, Globals.fileUpdateMonitor.getTempFile(ChangeScanner.this.panel.fileMonitorHandle()), Globals.prefs, false, false, ChangeScanner.this.panel.getEncoding(), true);
                    saveSession.commit();
                }
                catch (SaveException saveException) {
                    System.out.println("Problem updating tmp file after accepting external changes");
                }
            }
        });
    }

    private void scanMetaData(MetaData metaData, MetaData metaData2, MetaData metaData3) {
        MetaDataChange metaDataChange = new MetaDataChange(metaData, metaData2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : metaData2) {
            Vector<String> vector = metaData3.getData(string);
            if (vector == null) {
                metaDataChange.insertMetaDataRemoval(string);
                continue;
            }
            Vector<String> vector2 = metaData2.getData(string);
            if (!vector.equals(vector2)) {
                metaDataChange.insertMetaDataChange(string, vector);
            }
            arrayList.add(string);
        }
        for (String string : metaData3) {
            if (arrayList.contains(string)) continue;
            metaDataChange.insertMetaDataAddition(string, metaData3.getData(string));
        }
        if (metaDataChange.getChangeCount() > 0) {
            this.changes.add(metaDataChange);
        }
    }

    private void scanEntries(EntrySorter entrySorter, EntrySorter entrySorter2, EntrySorter entrySorter3) {
        int n;
        int n2;
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>(entrySorter3.getEntryCount());
        HashSet<Integer> hashSet2 = new HashSet<Integer>(entrySorter2.getEntryCount());
        block0: for (n2 = 0; n2 < entrySorter2.getEntryCount(); ++n2) {
            double d = -1.0;
            if (!hashSet.contains("" + n3) && n3 < entrySorter3.getEntryCount()) {
                d = DuplicateCheck.compareEntriesStrictly(entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(n3));
            }
            if (d > 1.0) {
                hashSet.add("" + n3);
                ++n3;
                continue;
            }
            if (n3 < entrySorter3.getEntryCount() - 1) {
                for (int i = n3 + 1; i < entrySorter3.getEntryCount(); ++i) {
                    d = !hashSet.contains("" + i) ? DuplicateCheck.compareEntriesStrictly(entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(i)) : -1.0;
                    if (!(d > 1.0)) continue;
                    hashSet.add("" + i);
                    continue block0;
                }
            }
            hashSet2.add(n2);
        }
        if (!hashSet2.isEmpty()) {
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                Change change;
                double d;
                n2 = (Integer)iterator.next();
                n = -1;
                double d2 = 0.0;
                if (n3 < entrySorter3.getEntryCount() - 1) {
                    for (int i = n3; i < entrySorter3.getEntryCount(); ++i) {
                        double d3 = !hashSet.contains("" + i) ? DuplicateCheck.compareEntriesStrictly(entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(i)) : -1.0;
                        if (!(d3 > d2)) continue;
                        d2 = d3;
                        n = i;
                    }
                }
                if (d2 > (d = 0.4)) {
                    hashSet.add("" + n);
                    iterator.remove();
                    change = new EntryChange(this.bestFit(entrySorter2, entrySorter, n2), entrySorter2.getEntryAt(n2), entrySorter3.getEntryAt(n));
                    this.changes.add(change);
                    continue;
                }
                change = new EntryDeleteChange(this.bestFit(entrySorter2, entrySorter, n2), entrySorter2.getEntryAt(n2));
                this.changes.add(change);
            }
        }
        if (hashSet.size() < entrySorter3.getEntryCount()) {
            for (int i = 0; i < entrySorter3.getEntryCount(); ++i) {
                if (hashSet.contains("" + i)) continue;
                n = 0;
                for (int j = 0; j < entrySorter.getEntryCount(); ++j) {
                    if (!(DuplicateCheck.compareEntriesStrictly(entrySorter.getEntryAt(j), entrySorter3.getEntryAt(i)) >= 1.0)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                EntryAddChange entryAddChange = new EntryAddChange(entrySorter3.getEntryAt(i));
                this.changes.add(entryAddChange);
            }
        }
    }

    private BibtexEntry bestFit(EntrySorter entrySorter, EntrySorter entrySorter2, int n) {
        double d = -1.0;
        int n2 = 0;
        for (int i = 0; i < entrySorter2.getEntryCount(); ++i) {
            double d2 = DuplicateCheck.compareEntriesStrictly(entrySorter.getEntryAt(n), entrySorter2.getEntryAt(i));
            if (d2 > d) {
                d = d2;
                n2 = i;
            }
            if (d > 1.0) break;
        }
        return entrySorter2.getEntryAt(n2);
    }

    private void scanPreamble(BibtexDatabase bibtexDatabase, BibtexDatabase bibtexDatabase2, BibtexDatabase bibtexDatabase3) {
        String string = bibtexDatabase.getPreamble();
        String string2 = bibtexDatabase2.getPreamble();
        String string3 = bibtexDatabase3.getPreamble();
        if (string2 != null) {
            if (string3 == null || !string2.equals(string3)) {
                this.changes.add(new PreambleChange(string2, string, string3));
            }
        } else if (string3 != null && !string3.isEmpty()) {
            this.changes.add(new PreambleChange(string2, string, string3));
        }
    }

    private void scanStrings(BibtexDatabase bibtexDatabase, BibtexDatabase bibtexDatabase2, BibtexDatabase bibtexDatabase3) {
        BibtexString bibtexString;
        Object object;
        int n = bibtexDatabase2.getStringCount();
        int n2 = bibtexDatabase3.getStringCount();
        if (n == 0 && n2 == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet<String> hashSet3 = new HashSet<String>(bibtexDatabase2.getStringCount());
        block0: for (String object2 : bibtexDatabase2.getStringKeySet()) {
            object = bibtexDatabase2.getString(object2);
            for (String string : bibtexDatabase3.getStringKeySet()) {
                if (hashSet.contains(string) || !(bibtexString = bibtexDatabase3.getString(string)).getName().equals(((BibtexString)object).getName())) continue;
                if (((BibtexString)object).getContent() != null && !((BibtexString)object).getContent().equals(bibtexString.getContent())) {
                    BibtexString bibtexString2 = this.findString(bibtexDatabase, ((BibtexString)object).getName(), hashSet2);
                    if (bibtexString2 != null) {
                        this.changes.add(new StringChange(bibtexString2, (BibtexString)object, ((BibtexString)object).getName(), bibtexString2.getContent(), ((BibtexString)object).getContent(), bibtexString.getContent()));
                    } else {
                        this.changes.add(new StringChange(null, (BibtexString)object, ((BibtexString)object).getName(), null, ((BibtexString)object).getContent(), bibtexString.getContent()));
                    }
                }
                hashSet.add(string);
                continue block0;
            }
            hashSet3.add(((BibtexString)object).getId());
        }
        if (!hashSet3.isEmpty()) {
            Iterator<String> iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                BibtexString bibtexString3 = bibtexDatabase2.getString(iterator.next());
                for (String string : bibtexDatabase3.getStringKeySet()) {
                    BibtexString bibtexString4;
                    if (hashSet.contains(string) || !(bibtexString4 = bibtexDatabase3.getString(string)).getContent().equals(bibtexString3.getContent())) continue;
                    bibtexString = null;
                    for (String string2 : bibtexDatabase.getStringKeySet()) {
                        BibtexString bibtexString5 = bibtexDatabase.getString(string2);
                        if (!bibtexString5.getContent().equals(bibtexString4.getContent()) || hashSet2.contains(string2)) continue;
                        hashSet2.add(string2);
                        bibtexString = bibtexString5;
                        break;
                    }
                    this.changes.add(new StringNameChange(bibtexString, bibtexString3, bibtexString.getName(), bibtexString3.getName(), bibtexString4.getName(), bibtexString3.getContent()));
                    iterator.remove();
                    hashSet.add(string);
                }
            }
        }
        if (!hashSet3.isEmpty()) {
            for (String string : hashSet3) {
                object = bibtexDatabase2.getString(string);
                BibtexString bibtexString6 = this.findString(bibtexDatabase, ((BibtexString)object).getName(), hashSet2);
                if (bibtexString6 == null) continue;
                this.changes.add(new StringRemoveChange((BibtexString)object, (BibtexString)object, bibtexString6));
            }
        }
        for (String string : bibtexDatabase3.getStringKeySet()) {
            if (hashSet.contains(string)) continue;
            object = bibtexDatabase3.getString(string);
            hashSet.add(string);
            this.changes.add(new StringAddChange((BibtexString)object));
        }
    }

    private BibtexString findString(BibtexDatabase bibtexDatabase, String string, HashSet<Object> hashSet) {
        if (!bibtexDatabase.hasStringLabel(string)) {
            return null;
        }
        for (String string2 : bibtexDatabase.getStringKeySet()) {
            BibtexString bibtexString = bibtexDatabase.getString(string2);
            if (!bibtexString.getName().equals(string) || hashSet.contains(string2)) continue;
            hashSet.add(string2);
            return bibtexString;
        }
        return null;
    }

    private void scanGroups(MetaData metaData, MetaData metaData2, MetaData metaData3) {
        GroupTreeNode groupTreeNode = metaData2.getGroups();
        GroupTreeNode groupTreeNode2 = metaData3.getGroups();
        if (groupTreeNode == null && groupTreeNode2 == null) {
            return;
        }
        if (groupTreeNode != null && groupTreeNode2 == null || groupTreeNode == null) {
            this.changes.add(new GroupChange(groupTreeNode2, groupTreeNode));
            return;
        }
        if (!groupTreeNode.equals(groupTreeNode2)) {
            this.changes.add(new GroupChange(groupTreeNode2, groupTreeNode));
        }
    }

    public static interface DisplayResultCallback {
        public void scanResultsResolved(boolean var1);
    }
}

