/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.sf.jabref.collab.FileUpdateListener;
import net.sf.jabref.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUpdateMonitor
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(FileUpdateMonitor.class);
    private static final int WAIT = 4000;
    private int numberOfUpdateListener = 0;
    private final HashMap<String, Entry> entries = new HashMap();

    @Override
    public void run() {
        while (true) {
            for (Entry entry : this.entries.values()) {
                try {
                    if (!entry.hasBeenUpdated()) continue;
                    entry.notifyListener();
                }
                catch (IOException iOException) {
                    entry.notifyFileRemoved();
                }
            }
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.debug("FileUpdateMonitor has been interrupted. Terminating...");
                return;
            }
        }
    }

    public String addUpdateListener(FileUpdateListener fileUpdateListener, File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not found");
        }
        ++this.numberOfUpdateListener;
        String string = "" + this.numberOfUpdateListener;
        this.entries.put(string, new Entry(fileUpdateListener, file));
        return string;
    }

    public boolean hasBeenModified(String string) throws IllegalArgumentException {
        Entry entry = this.entries.get(string);
        if (entry == null) {
            return false;
        }
        try {
            return entry.hasBeenUpdated();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void perturbTimestamp(String string) {
        Entry entry = this.entries.get(string);
        if (entry == null) {
            return;
        }
        --entry.timeStamp;
    }

    public void removeUpdateListener(String string) {
        this.entries.remove(string);
    }

    public void updateTimeStamp(String string) throws IllegalArgumentException {
        Entry entry = this.entries.get(string);
        if (entry == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        Entry entry2 = entry;
        entry2.updateTimeStamp();
    }

    public File getTempFile(String string) throws IllegalArgumentException {
        Entry entry = this.entries.get(string);
        if (entry == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        return entry.tmpFile;
    }

    private static synchronized File getTempFile() {
        File file = null;
        try {
            file = File.createTempFile("jabref", null);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file;
    }

    static class Entry {
        final FileUpdateListener listener;
        final File file;
        final File tmpFile;
        long timeStamp;
        long fileSize;

        public Entry(FileUpdateListener fileUpdateListener, File file) {
            this.listener = fileUpdateListener;
            this.file = file;
            this.timeStamp = this.file.lastModified();
            this.fileSize = this.file.length();
            this.tmpFile = FileUpdateMonitor.getTempFile();
            this.tmpFile.deleteOnExit();
            this.copy();
        }

        public boolean hasBeenUpdated() throws IOException {
            long l = this.file.lastModified();
            long l2 = this.file.length();
            if (l == 0L) {
                throw new IOException("File deleted");
            }
            return this.timeStamp != l || this.fileSize != l2;
        }

        public void updateTimeStamp() {
            this.timeStamp = this.file.lastModified();
            if (this.timeStamp == 0L) {
                this.notifyFileRemoved();
            }
            this.fileSize = this.file.length();
            this.copy();
        }

        public boolean copy() {
            boolean bl = false;
            try {
                bl = FileUtil.copyFile(this.file, this.tmpFile, true);
            }
            catch (IOException iOException) {
                LOGGER.info("Cannot copy to temporary file '" + this.tmpFile.getPath() + '\'', iOException);
            }
            return bl;
        }

        public void notifyListener() {
            this.timeStamp = this.file.lastModified();
            this.fileSize = this.file.length();
            this.listener.fileUpdated();
        }

        public void notifyFileRemoved() {
            this.listener.fileRemoved();
        }
    }
}

