/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.UndoableModifySubtree;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.undo.NamedCompound;

class GroupChange
extends Change {
    private final GroupTreeNode changedGroups;
    private final GroupTreeNode tmpGroupRoot;

    public GroupChange(GroupTreeNode groupTreeNode, GroupTreeNode groupTreeNode2) {
        super(groupTreeNode != null ? "Modified groups tree" : "Removed all groups");
        this.changedGroups = groupTreeNode;
        this.tmpGroupRoot = groupTreeNode2;
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        GroupTreeNode groupTreeNode = basePanel.metaData().getGroups();
        UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(basePanel.getGroupSelector(), basePanel.metaData().getGroups(), groupTreeNode, Globals.lang("Modified groups"));
        groupTreeNode.removeAllChildren();
        if (this.changedGroups == null) {
            groupTreeNode.setGroup(new AllEntriesGroup());
        } else {
            groupTreeNode.setGroup(this.changedGroups.getGroup());
            for (int i = 0; i < this.changedGroups.getChildCount(); ++i) {
                groupTreeNode.add(((GroupTreeNode)this.changedGroups.getChildAt(i)).deepCopy());
            }
            groupTreeNode.refreshGroupsForNewDatabase(basePanel.database());
        }
        if (basePanel.getGroupSelector().getGroupTreeRoot() == groupTreeNode) {
            basePanel.getGroupSelector().revalidateGroups();
        }
        namedCompound.addEdit(undoableModifySubtree);
        GroupTreeNode groupTreeNode2 = this.changedGroups.deepCopy();
        this.tmpGroupRoot.removeAllChildren();
        this.tmpGroupRoot.setGroup(groupTreeNode2.getGroup());
        for (int i = 0; i < groupTreeNode2.getChildCount(); ++i) {
            this.tmpGroupRoot.add(((GroupTreeNode)groupTreeNode2.getChildAt(i)).deepCopy());
        }
        this.tmpGroupRoot.refreshGroupsForNewDatabase(bibtexDatabase);
        return true;
    }

    @Override
    JComponent description() {
        return new JLabel("<html>" + this.name + '.' + (this.changedGroups != null ? " Accepting the change replaces the complete groups tree with the externally modified groups tree." : "") + "</html>");
    }
}

