/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.config;

import java.util.Vector;

public class SaveOrderConfig {
    public boolean saveInOriginalOrder;
    public boolean saveInSpecifiedOrder;
    public final SortCriterion[] sortCriteria = new SortCriterion[3];

    public SaveOrderConfig() {
        this.setSaveInOriginalOrder();
        this.sortCriteria[0] = new SortCriterion();
        this.sortCriteria[1] = new SortCriterion();
        this.sortCriteria[2] = new SortCriterion();
    }

    public SaveOrderConfig(Vector<String> vector) {
        if (vector == null) {
            throw new NullPointerException();
        }
        if (vector.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String string = vector.elementAt(0);
        if ("original".equals(string)) {
            this.setSaveInOriginalOrder();
        } else {
            this.setSaveInSpecifiedOrder();
        }
        this.sortCriteria[0] = vector.size() >= 3 ? new SortCriterion(vector.elementAt(1), vector.elementAt(2)) : new SortCriterion();
        this.sortCriteria[1] = vector.size() >= 5 ? new SortCriterion(vector.elementAt(3), vector.elementAt(4)) : new SortCriterion();
        this.sortCriteria[2] = vector.size() >= 7 ? new SortCriterion(vector.elementAt(5), vector.elementAt(6)) : new SortCriterion();
    }

    public void setSaveInOriginalOrder() {
        this.saveInOriginalOrder = true;
        this.saveInSpecifiedOrder = false;
    }

    public void setSaveInSpecifiedOrder() {
        this.saveInOriginalOrder = false;
        this.saveInSpecifiedOrder = true;
    }

    public Vector<String> getVector() {
        Vector<String> vector = new Vector<String>(7);
        if (this.saveInOriginalOrder) {
            vector.insertElementAt("original", 0);
        } else {
            assert (this.saveInSpecifiedOrder);
            vector.insertElementAt("specified", 0);
        }
        vector.insertElementAt(this.sortCriteria[0].field, 1);
        vector.insertElementAt(Boolean.toString(this.sortCriteria[0].descending), 2);
        vector.insertElementAt(this.sortCriteria[1].field, 3);
        vector.insertElementAt(Boolean.toString(this.sortCriteria[1].descending), 4);
        vector.insertElementAt(this.sortCriteria[2].field, 5);
        vector.insertElementAt(Boolean.toString(this.sortCriteria[2].descending), 6);
        return vector;
    }

    public static class SortCriterion {
        public String field;
        public boolean descending = false;

        public SortCriterion() {
            this.field = "";
        }

        public SortCriterion(String string, String string2) {
            this.field = string;
            this.descending = Boolean.parseBoolean(string2);
        }
    }
}

