/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;

public class AutoSaveManager {
    private final JabRefFrame frame;
    private Timer t = null;

    public AutoSaveManager(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
    }

    public void startAutoSaveTimer() {
        if (this.t != null) {
            this.t.cancel();
        }
        AutoSaveTask autoSaveTask = new AutoSaveTask();
        this.t = new Timer();
        long l = 60000 * Globals.prefs.getInt("autoSaveInterval");
        this.t.scheduleAtFixedRate((TimerTask)autoSaveTask, l, l);
    }

    public void stopAutoSaveTimer() {
        this.t.cancel();
    }

    public static File getAutoSaveFile(File file) {
        String string = file.getName();
        return new File(file.getParentFile(), ".$" + string + '$');
    }

    private static boolean autoSave(BasePanel basePanel) {
        File file = AutoSaveManager.getAutoSaveFile(basePanel.getFile());
        try {
            SaveSession saveSession = FileActions.saveDatabase(basePanel.database(), basePanel.metaData(), file, Globals.prefs, false, false, basePanel.getEncoding(), true);
            saveSession.commit();
        }
        catch (SaveException saveException) {
            saveException.printStackTrace();
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean deleteAutoSaveFile(BasePanel basePanel) {
        if (basePanel.getFile() == null) {
            return true;
        }
        File file = AutoSaveManager.getAutoSaveFile(basePanel.getFile());
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public void clearAutoSaves() {
        ArrayList<BasePanel> arrayList = new ArrayList<BasePanel>();
        for (int i = 0; i < this.frame.baseCount(); ++i) {
            arrayList.add(this.frame.baseAt(i));
        }
        for (BasePanel basePanel : arrayList) {
            AutoSaveManager.deleteAutoSaveFile(basePanel);
        }
    }

    public static boolean newerAutoSaveExists(File file) {
        File file2 = AutoSaveManager.getAutoSaveFile(file);
        return file2.exists() && file2.lastModified() > file.lastModified();
    }

    private class AutoSaveTask
    extends TimerTask {
        private AutoSaveTask() {
        }

        @Override
        public void run() {
            ArrayList<BasePanel> arrayList = new ArrayList<BasePanel>();
            for (int i = 0; i < AutoSaveManager.this.frame.baseCount(); ++i) {
                arrayList.add(AutoSaveManager.this.frame.baseAt(i));
            }
            for (BasePanel basePanel : arrayList) {
                if (!basePanel.isBaseChanged() || basePanel.getFile() == null) continue;
                AutoSaveManager.autoSave(basePanel);
            }
        }
    }
}

