/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import java.util.TreeMap;
import net.sf.jabref.Globals;
import net.sf.jabref.export.ExportFormat;

public class CustomExportList {
    private final EventList<String[]> list;
    private final SortedList<String[]> sorted;
    private final TreeMap<String, ExportFormat> formats = new TreeMap();
    private Object[] array;

    public CustomExportList(Comparator<String[]> comparator) {
        this.list = new BasicEventList<String[]>();
        this.sorted = new SortedList<String[]>(this.list, comparator);
    }

    public TreeMap<String, ExportFormat> getCustomExportFormats() {
        this.formats.clear();
        this.readPrefs();
        return this.formats;
    }

    public int size() {
        return this.list.size();
    }

    public EventList<String[]> getSortedList() {
        return this.sorted;
    }

    private void readPrefs() {
        String[] stringArray;
        this.formats.clear();
        this.list.clear();
        int n = 0;
        while ((stringArray = Globals.prefs.getStringArray("customExportFormat" + n)) != null) {
            ExportFormat exportFormat = this.createFormat(stringArray);
            if (exportFormat != null) {
                this.formats.put(exportFormat.getConsoleName(), exportFormat);
                this.list.add(stringArray);
            } else {
                String string = Globals.prefs.get("customExportFormat" + n);
                System.out.println(Globals.lang("Error initializing custom export format from string '%0'", string));
            }
            ++n;
        }
    }

    private ExportFormat createFormat(String[] stringArray) {
        if (stringArray.length < 3) {
            return null;
        }
        String string = stringArray[1].endsWith(".layout") ? stringArray[1].substring(0, stringArray[1].length() - 7) : stringArray[1];
        ExportFormat exportFormat = new ExportFormat(stringArray[0], stringArray[0], string, null, stringArray[2]);
        exportFormat.setCustomExport(true);
        return exportFormat;
    }

    public void addFormat(String[] stringArray) {
        this.list.add(stringArray);
        ExportFormat exportFormat = this.createFormat(stringArray);
        this.formats.put(exportFormat.getConsoleName(), exportFormat);
    }

    public void remove(String[] stringArray) {
        ExportFormat exportFormat = this.createFormat(stringArray);
        this.formats.remove(exportFormat.getConsoleName());
        this.list.remove(stringArray);
    }

    public void store() {
        if (this.list.isEmpty()) {
            this.purge(0);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Globals.prefs.putStringArray("customExportFormat" + i, (String[])this.list.get(i));
            }
            this.purge(this.list.size());
        }
    }

    private void purge(int n) {
        int n2 = n;
        while (Globals.prefs.getStringArray("customExportFormat" + n2) != null) {
            Globals.prefs.remove("customExportFormat" + n2);
            ++n2;
        }
    }
}

