/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.CustomExportDialog;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.util.Util;

public class ExportCustomizationDialog
extends JDialog {
    private final JabRefFrame frame;
    private JTable table;

    public ExportCustomizationDialog(JabRefFrame jabRefFrame) throws HeadlessException {
        super(jabRefFrame, Globals.lang("Manage custom exports"), false);
        this.frame = jabRefFrame;
        JButton jButton = new JButton(Globals.lang("Add new"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomExportDialog customExportDialog = new CustomExportDialog(ExportCustomizationDialog.this.frame);
                customExportDialog.setVisible(true);
                if (customExportDialog.okPressed()) {
                    String[] stringArray = new String[]{customExportDialog.name(), customExportDialog.layoutFile(), customExportDialog.extension()};
                    Globals.prefs.customExports.addFormat(stringArray);
                    Globals.prefs.customExports.store();
                }
            }
        });
        JButton jButton2 = new JButton(Globals.lang("Modify"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ExportCustomizationDialog.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                String[] stringArray = (String[])Globals.prefs.customExports.getSortedList().get(n);
                CustomExportDialog customExportDialog = new CustomExportDialog(ExportCustomizationDialog.this.frame, stringArray[0], stringArray[1], stringArray[2]);
                customExportDialog.setVisible(true);
                if (customExportDialog.okPressed()) {
                    stringArray[0] = customExportDialog.name();
                    stringArray[1] = customExportDialog.layoutFile();
                    stringArray[2] = customExportDialog.extension();
                    ExportCustomizationDialog.this.table.revalidate();
                    ExportCustomizationDialog.this.table.repaint();
                    Globals.prefs.customExports.store();
                }
            }
        });
        JButton jButton3 = new JButton(Globals.lang("Remove"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int[] nArray = ExportCustomizationDialog.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                String[][] stringArrayArray = new String[nArray.length][];
                for (n = 0; n < nArray.length; ++n) {
                    stringArrayArray[n] = (String[])Globals.prefs.customExports.getSortedList().get(nArray[n]);
                }
                for (n = 0; n < nArray.length; ++n) {
                    Globals.prefs.customExports.remove(stringArrayArray[n]);
                }
                Globals.prefs.customExports.store();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportCustomizationDialog.this.dispose();
            }
        };
        JButton jButton4 = new JButton(Globals.lang("Close"));
        jButton4.addActionListener(abstractAction);
        JButton jButton5 = new JButton(Globals.lang("Help"));
        jButton5.addActionListener(new HelpAction(this.frame.helpDiag, "CustomExports.html", "Help"));
        EventTableModel<String[]> eventTableModel = new EventTableModel<String[]>(Globals.prefs.customExports.getSortedList(), new ExportTableFormat());
        this.table = new JTable(eventTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(200);
        tableColumnModel.getColumn(2).setPreferredWidth(30);
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        JPanel jPanel = new JPanel();
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addButton((JComponent)jButton3);
        buttonBarBuilder.addButton((JComponent)jButton4);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addButton((JComponent)jButton5);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        Util.placeDialog(this, this.frame);
        new FocusRequester(this.table);
    }

    private static class ExportTableFormat
    implements TableFormat<String[]> {
        private ExportTableFormat() {
        }

        @Override
        public Object getColumnValue(String[] stringArray, int n) {
            return stringArray[n];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Globals.lang("Export name");
                }
                case 1: {
                    return Globals.lang("Main layout file");
                }
            }
            return Globals.lang("File extension");
        }
    }
}

