/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryWriter;
import net.sf.jabref.BibtexString;
import net.sf.jabref.BibtexStringComparator;
import net.sf.jabref.CrossRefEntryComparator;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.FieldComparatorStack;
import net.sf.jabref.Globals;
import net.sf.jabref.IdComparator;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.config.SaveOrderConfig;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;

public class FileActions {
    private static final Pattern refPat = Pattern.compile("(#[A-Za-z]+#)");
    private static BibtexString.Type previousStringType;

    private static void writePreamble(Writer writer, String string) throws IOException {
        if (string != null) {
            writer.write("@PREAMBLE{");
            writer.write(string);
            writer.write('}' + Globals.NEWLINE + Globals.NEWLINE);
        }
    }

    private static void writeStrings(Writer writer, BibtexDatabase bibtexDatabase) throws IOException {
        previousStringType = BibtexString.Type.AUTHOR;
        ArrayList<BibtexString> arrayList = new ArrayList<BibtexString>();
        for (String string : bibtexDatabase.getStringKeySet()) {
            arrayList.add(bibtexDatabase.getString(string));
        }
        Collections.sort(arrayList, new BibtexStringComparator(true));
        HashMap hashMap = new HashMap();
        int n = 0;
        for (BibtexString bibtexString : arrayList) {
            hashMap.put(bibtexString.getName(), bibtexString);
            n = Math.max(n, bibtexString.getName().length());
        }
        for (BibtexString.Type type : BibtexString.Type.values()) {
            for (BibtexString bibtexString : arrayList) {
                if (!hashMap.containsKey(bibtexString.getName()) || bibtexString.getType() != type) continue;
                FileActions.writeString(writer, bibtexString, hashMap, n);
            }
        }
        writer.write(Globals.NEWLINE);
    }

    private static void writeString(Writer writer, BibtexString bibtexString, HashMap<String, BibtexString> hashMap, int n) throws IOException {
        int n2;
        String string;
        Matcher matcher;
        hashMap.remove(bibtexString.getName());
        String string2 = bibtexString.getContent();
        while ((matcher = refPat.matcher(string2)).find()) {
            string = matcher.group(1);
            n2 = string2.indexOf(string) + string.length();
            string2 = string2.substring(n2);
            BibtexString bibtexString2 = hashMap.get(string.substring(1, string.length() - 1));
            if (bibtexString2 == null) continue;
            FileActions.writeString(writer, bibtexString2, hashMap, n);
        }
        if (previousStringType != bibtexString.getType()) {
            writer.write(Globals.NEWLINE);
            previousStringType = bibtexString.getType();
        }
        string = "";
        for (n2 = n - bibtexString.getName().length(); n2 > 0; --n2) {
            string = string + " ";
        }
        writer.write("@String { " + bibtexString.getName() + string + " = ");
        if (!bibtexString.getContent().isEmpty()) {
            try {
                String string3 = new LatexFieldFormatter().format(bibtexString.getContent(), "__string");
                writer.write(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(Globals.lang("The # character is not allowed in BibTeX strings unless escaped as in '\\#'.") + '\n' + Globals.lang("Before saving, please edit any strings containing the # character."));
            }
        } else {
            writer.write("{}");
        }
        writer.write(" }" + Globals.NEWLINE);
    }

    private static void writeBibFileHeader(Writer writer, String string) throws IOException {
        writer.write("% ");
        writer.write("This file was created with JabRef");
        writer.write(' ' + Globals.BUILD_INFO.getVersion() + '.' + Globals.NEWLINE + "% " + "Encoding: " + string + Globals.NEWLINE + Globals.NEWLINE);
    }

    public static SaveSession saveDatabase(BibtexDatabase bibtexDatabase, MetaData metaData, File file, JabRefPreferences jabRefPreferences, boolean bl, boolean bl2, String string, boolean bl3) throws SaveException {
        SaveSession saveSession;
        TreeMap<String, BibtexEntryType> treeMap = new TreeMap<String, BibtexEntryType>();
        boolean bl4 = jabRefPreferences.getBoolean("backup");
        if (bl3) {
            bl4 = false;
        }
        BibtexEntry bibtexEntry = null;
        try {
            saveSession = new SaveSession(file, string, bl4);
        }
        catch (Throwable throwable) {
            if (string != null) {
                System.err.println("Error from encoding: '" + string + "' Len: " + string.length());
            }
            throwable.printStackTrace();
            throw new SaveException(throwable.getMessage());
        }
        try {
            BibtexEntryType bibtexEntryType;
            VerifyingWriter verifyingWriter = saveSession.getWriter();
            FileActions.writeBibFileHeader(verifyingWriter, string);
            FileActions.writePreamble(verifyingWriter, bibtexDatabase.getPreamble());
            FileActions.writeStrings(verifyingWriter, bibtexDatabase);
            List<BibtexEntry> list = FileActions.getSortedEntries(bibtexDatabase, metaData, null, true);
            BibtexEntryWriter bibtexEntryWriter = new BibtexEntryWriter(new LatexFieldFormatter(), true);
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                BibtexEntry object;
                bibtexEntry = object = iterator.next();
                bibtexEntryType = object.getType();
                if (BibtexEntryType.getStandardType(bibtexEntryType.getName()) == null) {
                    treeMap.put(bibtexEntryType.getName(), bibtexEntryType);
                }
                boolean customEntryType = true;
                if (bl && !FileActions.nonZeroField(object, "__search")) {
                    customEntryType = false;
                }
                if (bl2 && !FileActions.nonZeroField(object, "__groupsearch")) {
                    customEntryType = false;
                }
                if (!customEntryType) continue;
                bibtexEntryWriter.write(object, verifyingWriter);
                verifyingWriter.write(Globals.NEWLINE);
            }
            if (metaData != null) {
                metaData.writeMetaData(verifyingWriter);
            }
            if (!treeMap.isEmpty()) {
                for (Map.Entry entry : treeMap.entrySet()) {
                    bibtexEntryType = (BibtexEntryType)entry.getValue();
                    if (!(bibtexEntryType instanceof CustomEntryType)) continue;
                    CustomEntryType customEntryType = (CustomEntryType)bibtexEntryType;
                    customEntryType.save(verifyingWriter);
                    verifyingWriter.write(Globals.NEWLINE);
                }
            }
            verifyingWriter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            saveSession.cancel();
            throw new SaveException(throwable.getMessage(), bibtexEntry);
        }
        return saveSession;
    }

    private static List<Comparator<BibtexEntry>> getSaveComparators(boolean bl, MetaData metaData) {
        SaveSettings saveSettings = new SaveSettings(bl, metaData);
        ArrayList<Comparator<BibtexEntry>> arrayList = new ArrayList<Comparator<BibtexEntry>>();
        if (bl) {
            arrayList.add(new CrossRefEntryComparator());
        }
        arrayList.add(new FieldComparator(saveSettings.pri, saveSettings.priD));
        arrayList.add(new FieldComparator(saveSettings.sec, saveSettings.secD));
        arrayList.add(new FieldComparator(saveSettings.ter, saveSettings.terD));
        arrayList.add(new FieldComparator("bibtexkey"));
        return arrayList;
    }

    public static SaveSession savePartOfDatabase(BibtexDatabase bibtexDatabase, MetaData metaData, File file, JabRefPreferences jabRefPreferences, BibtexEntry[] bibtexEntryArray, String string, DatabaseSaveType databaseSaveType) throws SaveException {
        SaveSession saveSession;
        TreeMap<String, BibtexEntryType> treeMap = new TreeMap<String, BibtexEntryType>();
        BibtexEntry object = null;
        boolean bl = jabRefPreferences.getBoolean("backup");
        try {
            saveSession = new SaveSession(file, string, bl);
        }
        catch (IOException iOException) {
            throw new SaveException(iOException.getMessage());
        }
        try {
            BibtexEntryType bibtexEntryType;
            VerifyingWriter verifyingWriter = saveSession.getWriter();
            if (databaseSaveType != DatabaseSaveType.PLAIN_BIBTEX) {
                FileActions.writeBibFileHeader(verifyingWriter, string);
            }
            FileActions.writePreamble(verifyingWriter, bibtexDatabase.getPreamble());
            FileActions.writeStrings(verifyingWriter, bibtexDatabase);
            List<Comparator<BibtexEntry>> list = FileActions.getSaveComparators(true, metaData);
            ArrayList arrayList = new ArrayList(bibtexEntryArray.length);
            Collections.addAll(arrayList, bibtexEntryArray);
            Collections.sort(arrayList, new FieldComparatorStack<BibtexEntry>(list));
            BibtexEntryWriter bibtexEntryWriter = new BibtexEntryWriter(new LatexFieldFormatter(), true);
            for (BibtexEntry object2 : arrayList) {
                object = object2;
                bibtexEntryType = object.getType();
                if (BibtexEntryType.getStandardType(bibtexEntryType.getName()) == null) {
                    treeMap.put(bibtexEntryType.getName(), bibtexEntryType);
                }
                bibtexEntryWriter.write(object, verifyingWriter);
                verifyingWriter.write(Globals.NEWLINE);
            }
            if (databaseSaveType != DatabaseSaveType.PLAIN_BIBTEX && metaData != null) {
                metaData.writeMetaData(verifyingWriter);
            }
            if (!treeMap.isEmpty()) {
                for (Map.Entry entry : treeMap.entrySet()) {
                    bibtexEntryType = (CustomEntryType)entry.getValue();
                    ((CustomEntryType)bibtexEntryType).save(verifyingWriter);
                    verifyingWriter.write(Globals.NEWLINE);
                }
            }
            verifyingWriter.close();
        }
        catch (Throwable throwable) {
            saveSession.cancel();
            throw new SaveException(throwable.getMessage(), object);
        }
        return saveSession;
    }

    public static Reader getReader(String string) throws IOException {
        InputStreamReader inputStreamReader;
        URL uRL = Globals.class.getResource(string);
        if (uRL != null) {
            try {
                inputStreamReader = new InputStreamReader(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(Globals.lang("Could not find layout file") + ": '" + string + "'.");
            }
        }
        File file = new File(string);
        try {
            inputStreamReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(Globals.lang("Could not find layout file") + ": '" + string + "'.");
        }
        return inputStreamReader;
    }

    public static List<BibtexEntry> getSortedEntries(BibtexDatabase bibtexDatabase, MetaData metaData, Set<String> set, boolean bl) {
        Object object;
        boolean bl2;
        List<Object> list;
        if (bl) {
            list = metaData.getData("saveOrderConfig");
            if (list == null) {
                bl2 = Globals.prefs.getBoolean("saveInOriginalOrder");
            } else {
                object = new SaveOrderConfig((Vector<String>)list);
                bl2 = ((SaveOrderConfig)object).saveInOriginalOrder;
            }
        } else {
            bl2 = Globals.prefs.getBoolean("exportInOriginalOrder");
        }
        if (bl2) {
            list = new ArrayList();
            list.add((String)((Object)new CrossRefEntryComparator()));
            list.add(new IdComparator());
        } else {
            list = FileActions.getSaveComparators(bl, metaData);
        }
        object = new FieldComparatorStack(list);
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        if (set == null) {
            set = bibtexDatabase.getKeySet();
        }
        if (set != null) {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(bibtexDatabase.getEntryById(iterator.next()));
            }
        }
        Collections.sort(arrayList, object);
        return arrayList;
    }

    private static boolean nonZeroField(BibtexEntry bibtexEntry, String string) {
        String string2 = bibtexEntry.getField(string);
        return string2 != null && !string2.equals("0");
    }

    private static class SaveSettings {
        public final String pri;
        public final String sec;
        public final String ter;
        public final boolean priD;
        public final boolean secD;
        public final boolean terD;

        public SaveSettings(boolean bl, MetaData metaData) {
            Vector<String> vector = null;
            if (bl) {
                vector = metaData.getData("saveOrderConfig");
            }
            assert (vector == null && bl && !Globals.prefs.getBoolean("saveInOriginalOrder"));
            assert (vector == null && !bl && !Globals.prefs.getBoolean("exportInOriginalOrder"));
            if (vector != null) {
                SaveOrderConfig saveOrderConfig = new SaveOrderConfig(vector);
                assert (!saveOrderConfig.saveInOriginalOrder);
                assert (saveOrderConfig.saveInSpecifiedOrder);
                this.pri = saveOrderConfig.sortCriteria[0].field;
                this.sec = saveOrderConfig.sortCriteria[1].field;
                this.ter = saveOrderConfig.sortCriteria[2].field;
                this.priD = saveOrderConfig.sortCriteria[0].descending;
                this.secD = saveOrderConfig.sortCriteria[1].descending;
                this.terD = saveOrderConfig.sortCriteria[2].descending;
            } else if (bl && Globals.prefs.getBoolean("saveInSpecifiedOrder")) {
                this.pri = Globals.prefs.get("savePriSort");
                this.sec = Globals.prefs.get("saveSecSort");
                this.ter = Globals.prefs.get("saveTerSort");
                this.priD = Globals.prefs.getBoolean("savePriDescending");
                this.secD = Globals.prefs.getBoolean("saveSecDescending");
                this.terD = Globals.prefs.getBoolean("saveTerDescending");
            } else if (!bl && Globals.prefs.getBoolean("exportInSpecifiedOrder")) {
                this.pri = Globals.prefs.get("exportPriSort");
                this.sec = Globals.prefs.get("exportSecSort");
                this.ter = Globals.prefs.get("exportTerSort");
                this.priD = Globals.prefs.getBoolean("exportPriDescending");
                this.secD = Globals.prefs.getBoolean("exportSecDescending");
                this.terD = Globals.prefs.getBoolean("exportTerDescending");
            } else {
                this.pri = Globals.prefs.get("priSort");
                this.sec = Globals.prefs.get("secSort");
                this.ter = Globals.prefs.get("terSort");
                this.priD = Globals.prefs.getBoolean("priDescending");
                this.secD = Globals.prefs.getBoolean("secDescending");
                this.terD = Globals.prefs.getBoolean("terDescending");
            }
        }
    }

    public static enum DatabaseSaveType {
        DEFAULT,
        PLAIN_BIBTEX;

    }
}

