/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.OOCalcDatabase;

public class OpenOfficeDocumentCreator
extends ExportFormat {
    public OpenOfficeDocumentCreator() {
        super(Globals.lang("OpenOffice Calc"), "oocalc", null, null, ".sxc");
    }

    @Override
    public void performExport(BibtexDatabase bibtexDatabase, MetaData metaData, String string, String string2, Set<String> set) throws Exception {
        OpenOfficeDocumentCreator.exportOpenOfficeCalc(new File(string), bibtexDatabase, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeOpenOfficeFile(File file, InputStream inputStream) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            int n;
            ZipEntry zipEntry = new ZipEntry("content.xml");
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = inputStream.read()) >= 0) {
                zipOutputStream.write(n);
            }
            zipOutputStream.closeEntry();
            OpenOfficeDocumentCreator.addResourceFile("meta.xml", "/resource/openoffice/meta.xml", zipOutputStream);
            OpenOfficeDocumentCreator.addResourceFile("mimetype", "/resource/openoffice/mimetype", zipOutputStream);
            OpenOfficeDocumentCreator.addResourceFile("META-INF/manifest.xml", "/resource/openoffice/manifest.xml", zipOutputStream);
        }
        finally {
            zipOutputStream.close();
        }
    }

    private static void exportOpenOfficeCalc(File file, BibtexDatabase bibtexDatabase, Set<String> set) throws Exception {
        File file2 = File.createTempFile("oocalc", null);
        OpenOfficeDocumentCreator.exportOpenOfficeCalcXML(file2, bibtexDatabase, set);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        OpenOfficeDocumentCreator.storeOpenOfficeFile(file, bufferedInputStream);
        file2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportOpenOfficeCalcXML(File file, BibtexDatabase bibtexDatabase, Set<String> set) {
        OOCalcDatabase oOCalcDatabase = new OOCalcDatabase(bibtexDatabase, set);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
            try {
                DOMSource dOMSource = new DOMSource(oOCalcDatabase.getDOMrepresentation());
                StreamResult streamResult = new StreamResult(outputStreamWriter);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(dOMSource, streamResult);
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private static void addResourceFile(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        OpenOfficeDocumentCreator.addFromResource(string2, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFromResource(String string, OutputStream outputStream) {
        URL uRL = OpenOfficeDocumentCreator.class.getResource(string);
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[256];
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

