/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.sf.jabref.Globals;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginBasedExportFormat
extends ExportFormat {
    private final _JabRefPlugin.ExportFormatTemplateExtension extension;
    private static final Log LOGGER = LogFactory.getLog(PluginBasedExportFormat.class);

    public static PluginBasedExportFormat getFormat(_JabRefPlugin.ExportFormatTemplateExtension exportFormatTemplateExtension) {
        String string = exportFormatTemplateExtension.getConsoleName();
        String string2 = exportFormatTemplateExtension.getDisplayName();
        String string3 = exportFormatTemplateExtension.getLayoutFilename();
        String string4 = exportFormatTemplateExtension.getExtension();
        String string5 = exportFormatTemplateExtension.getEncoding();
        if (string4 != null && string4.isEmpty() || string2 != null && string2.isEmpty() || string != null && string.isEmpty() || string3 != null && string3.isEmpty()) {
            LOGGER.info("Could not load extension " + exportFormatTemplateExtension.getId());
            return null;
        }
        return new PluginBasedExportFormat(string2, string, string3, string4, string5, exportFormatTemplateExtension);
    }

    private PluginBasedExportFormat(String string, String string2, String string3, String string4, String string5, _JabRefPlugin.ExportFormatTemplateExtension exportFormatTemplateExtension) {
        super(string, string2, string3, null, string4);
        if (string5 != null) {
            this.setEncoding(string5);
        }
        this.extension = exportFormatTemplateExtension;
    }

    @Override
    public Reader getReader(String string) throws IOException {
        URL uRL = this.extension.getDirAsUrl(string);
        if (uRL != null) {
            try {
                return new InputStreamReader(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        try {
            return new FileReader(new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(Globals.lang("Could not find layout file") + ": '" + string + "'.");
        }
    }
}

