/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.TreeSet;

public class VerifyingWriter
extends OutputStreamWriter {
    private CharsetEncoder encoder;
    private boolean couldEncodeAll = true;
    private final TreeSet<Character> problemCharacters = new TreeSet();

    public VerifyingWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.encoder = Charset.forName(string).newEncoder();
    }

    @Override
    public void write(String string) throws IOException {
        super.write(string);
        if (!this.encoder.canEncode(string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (this.encoder.canEncode(string.charAt(i))) continue;
                this.problemCharacters.add(Character.valueOf(string.charAt(i)));
            }
            this.couldEncodeAll = false;
        }
    }

    public boolean couldEncodeAll() {
        return this.couldEncodeAll;
    }

    public String getProblemCharacters() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Character c : this.problemCharacters) {
            stringBuilder.append(c.charValue());
        }
        return stringBuilder.toString();
    }
}

