/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.util.Vector;
import net.sf.jabref.AuthorList;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.WSITools;
import net.sf.jabref.export.layout.format.XMLChars;

public class CreateDocBookAuthors
implements LayoutFormatter {
    private static final XMLChars xc = new XMLChars();

    @Override
    public String format(String string) {
        StringBuilder stringBuilder = new StringBuilder(100);
        AuthorList authorList = AuthorList.getAuthorList(string);
        this.addBody(stringBuilder, authorList, "author");
        return stringBuilder.toString();
    }

    void addBody(StringBuilder stringBuilder, AuthorList authorList, String string) {
        for (int i = 0; i < authorList.size(); ++i) {
            stringBuilder.append('<').append(string).append('>');
            AuthorList.Author author = authorList.getAuthor(i);
            if (author.getFirst() != null && !author.getFirst().isEmpty()) {
                stringBuilder.append("<firstname>");
                stringBuilder.append(xc.format(author.getFirst()));
                stringBuilder.append("</firstname>");
            }
            if (author.getVon() != null && !author.getVon().isEmpty()) {
                stringBuilder.append("<othername>");
                stringBuilder.append(xc.format(author.getVon()));
                stringBuilder.append("</othername>");
            }
            if (author.getLast() != null && !author.getLast().isEmpty()) {
                stringBuilder.append("<surname>");
                stringBuilder.append(xc.format(author.getLast()));
                if (author.getJr() != null && !author.getJr().isEmpty()) {
                    stringBuilder.append(' ').append(xc.format(author.getJr()));
                }
                stringBuilder.append("</surname>");
            }
            if (i < authorList.size() - 1) {
                stringBuilder.append("</").append(string).append(">\n       ");
                continue;
            }
            stringBuilder.append("</").append(string).append('>');
        }
    }

    protected void singleAuthor(StringBuffer stringBuffer, String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = AuthorList.fixAuthor_firstNameFirst(string);
        WSITools.tokenize(vector, string2, " \n\r");
        if (vector.size() == 1) {
            stringBuffer.append("<surname>");
            stringBuffer.append(vector.get(0));
            stringBuffer.append("</surname>");
        } else if (vector.size() == 2) {
            stringBuffer.append("<firstname>");
            stringBuffer.append(vector.get(0));
            stringBuffer.append("</firstname>");
            stringBuffer.append("<surname>");
            stringBuffer.append(vector.get(1));
            stringBuffer.append("</surname>");
        } else {
            stringBuffer.append("<firstname>");
            stringBuffer.append(vector.get(0));
            stringBuffer.append("</firstname>");
            stringBuffer.append("<othername role=\"mi\">");
            for (int i = 1; i < vector.size() - 1; ++i) {
                stringBuffer.append(vector.get(i));
                if (i >= vector.size() - 2) continue;
                stringBuffer.append(' ');
            }
            stringBuffer.append("</othername>");
            stringBuffer.append("<surname>");
            stringBuffer.append(vector.get(vector.size() - 1));
            stringBuffer.append("</surname>");
        }
    }
}

