/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.util.Util;

public class ExternalFileMenuItem
extends JMenuItem
implements ActionListener {
    private final BibtexEntry entry;
    private final String link;
    private final MetaData metaData;
    private ExternalFileType fileType;
    private final JabRefFrame frame;
    private String fieldName = null;

    public ExternalFileMenuItem(JabRefFrame jabRefFrame, BibtexEntry bibtexEntry, String string, String string2, Icon icon, MetaData metaData, ExternalFileType externalFileType) {
        super(string, icon);
        this.frame = jabRefFrame;
        this.entry = bibtexEntry;
        this.link = string2;
        this.metaData = metaData;
        this.fileType = externalFileType;
        this.addActionListener(this);
    }

    public ExternalFileMenuItem(JabRefFrame jabRefFrame, BibtexEntry bibtexEntry, String string, String string2, Icon icon, MetaData metaData, String string3) {
        this(jabRefFrame, bibtexEntry, string, string2, icon, metaData, (ExternalFileType)null);
        this.fieldName = string3;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.openLink();
        if (!bl) {
            this.frame.output(Globals.lang("Unable to open link."));
        }
    }

    public boolean openLink() {
        this.frame.output(Globals.lang("External viewer called") + ".");
        try {
            ExternalFileType externalFileType = this.fileType;
            if (this.fileType == null) {
                if (this.fieldName != null) {
                    Util.openExternalViewer(this.frame.basePanel().metaData(), this.link, this.fieldName);
                    return true;
                }
                File file = new File(this.link);
                String string = file.getName();
                int n = string.indexOf(46);
                String string2 = n >= 0 && n < string.length() - 1 ? string.substring(n + 1).trim().toLowerCase() : null;
                this.fileType = externalFileType = Globals.prefs.getExternalFileTypeByExt(string2);
            }
            if (externalFileType instanceof UnknownExternalFileType) {
                return Util.openExternalFileUnknown(this.frame, this.entry, this.metaData, this.link, (UnknownExternalFileType)externalFileType);
            }
            return Util.openExternalFileAnyFormat(this.metaData, this.link, externalFileType);
        }
        catch (IOException iOException) {
            if (this.fileType != null && this.fileType.getOpenWith() != null && this.fileType.getOpenWith().length() > 0 && iOException.getMessage().contains(this.fileType.getOpenWith())) {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("Unable to open link. The application '%0' associated with the file type '%1' could not be called.", this.fileType.getOpenWith(), this.fileType.getName()), Globals.lang("Could not open link"), 0);
                return false;
            }
            iOException.printStackTrace();
            return false;
        }
    }
}

